/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.util;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.config.ConfigWriter;
import com.linkedin.d2.balancer.properties.ClusterPropertiesJsonSerializer;
import com.linkedin.d2.balancer.properties.HashBasedPartitionProperties;
import com.linkedin.d2.balancer.properties.PartitionProperties;
import com.linkedin.d2.balancer.properties.ServicePropertiesJsonSerializer;
import com.linkedin.d2.balancer.properties.util.PropertyUtil;
import com.linkedin.d2.balancer.zkfs.ZKFSUtil;
import com.linkedin.d2.discovery.PropertyBuilder;
import com.linkedin.d2.discovery.PropertySerializer;
import com.linkedin.d2.discovery.stores.zk.DeltaWriteZooKeeperPermanentStore;
import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperPermanentStore;
import com.linkedin.d2.discovery.util.D2Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class D2Config {
    private static final Logger _log = LoggerFactory.getLogger(D2Config.class);
    public static final int NO_ERROR_EXIT_CODE = 0;
    public static final int CMD_LINE_ERROR_EXIT_CODE = 1;
    public static final int EXCEPTION_EXIT_CODE = 2;
    public static final int PARTITION_CONFIG_ERROR_EXIT_CODE = 3;
    public static final String LIST_SEPARATOR = ",";
    private final ZKConnection _zkConnection;
    private final String _basePath;
    private final List<Map<String, Object>> _clusterServiceConfigurations;
    private final Map<String, Object> _clusterDefaults;
    private final Map<String, Object> _serviceDefaults;
    private final Map<String, Object> _serviceVariants;
    private final long _timeout;
    private final int _retryLimit;
    private final boolean _useDeltaWrite;
    private final int _maxOutstandingWrites;

    public D2Config(String zkHosts, int sessionTimeout, String basePath, long timeout, int retryLimit, Map<String, Object> clusterDefaults, Map<String, Object> serviceDefaults, Map<String, Object> clusterServiceConfigurations, Map<String, Object> extraClusterServiceConfigurations, Map<String, Object> serviceVariants) {
        this(zkHosts, sessionTimeout, basePath, timeout, retryLimit, clusterDefaults, serviceDefaults, clusterServiceConfigurations, extraClusterServiceConfigurations, serviceVariants, false, 1);
    }

    public D2Config(String zkHosts, int sessionTimeout, String basePath, long timeout, int retryLimit, Map<String, Object> clusterDefaults, Map<String, Object> serviceDefaults, Map<String, Object> clusterServiceConfigurations, Map<String, Object> extraClusterServiceConfigurations, Map<String, Object> serviceVariants, boolean useDeltaWrite, int maxOutstandingWrites) {
        this._retryLimit = retryLimit;
        this._zkConnection = new ZKConnection(zkHosts, sessionTimeout, this._retryLimit, false, null, 0L);
        this._basePath = basePath;
        this._timeout = timeout;
        this._clusterServiceConfigurations = Arrays.asList(clusterServiceConfigurations, extraClusterServiceConfigurations);
        this._clusterDefaults = clusterDefaults;
        this._serviceDefaults = serviceDefaults;
        this._serviceVariants = serviceVariants;
        this._useDeltaWrite = useDeltaWrite;
        this._maxOutstandingWrites = maxOutstandingWrites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int configure() throws Exception {
        Map<String, Object> clusterServiceConfiguration = this.merge(this._clusterServiceConfigurations);
        HashMap<String, Map<String, Object>> clusters = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, Object>> services = new HashMap<String, Map<String, Object>>();
        HashMap serviceVariants = new HashMap();
        HashMap<String, Map<String, Map<String, Object>>> clusterToServiceMapping = new HashMap<String, Map<String, Map<String, Object>>>();
        HashMap<String, List<String>> variantToVariantsMapping = new HashMap<String, List<String>>();
        HashMap<String, List<String>> clusterToColoClustersMapping = new HashMap<String, List<String>>();
        HashMap<String, List<String>> regularClusterToServicesMapping = new HashMap<String, List<String>>();
        _log.info("basePath: " + this._basePath);
        _log.info("clusterDefaults: " + this._clusterDefaults);
        _log.info("serviceDefaults: " + this._serviceDefaults);
        String defaultColo = (String)this._clusterDefaults.remove("defaultColo");
        for (String string : clusterServiceConfiguration.keySet()) {
            int status;
            HashMap<String, Object> clusterConfig = (HashMap<String, Object>)clusterServiceConfiguration.get(string);
            clusterConfig.put("clusterName", string);
            Object servicesProperty = clusterConfig.remove("services");
            Map servicesConfigs = (Map)servicesProperty;
            Object clusterVariantProperty = clusterConfig.remove("clusterVariants");
            Map clusterVariantConfig = (Map)clusterVariantProperty;
            Object coloVariantsProperty = clusterConfig.remove("coloVariants");
            List<String> coloVariants = (List<String>)coloVariantsProperty;
            String masterColo = (String)clusterConfig.remove("masterColo");
            String enableSymlinkString = (String)clusterConfig.remove("enableSymlink");
            regularClusterToServicesMapping.put(string, servicesConfigs.keySet().stream().collect(Collectors.toList()));
            boolean enableSymlink = enableSymlinkString != null && "true".equalsIgnoreCase(enableSymlinkString);
            Object partitionPropertiesProperty = clusterConfig.get("partitionProperties");
            Map partitionProperties = (Map)partitionPropertiesProperty;
            if (partitionProperties != null && (status = this.handlePartitionProperties(partitionProperties, (Map<String, Object>)clusterConfig, string)) != 0) {
                return status;
            }
            HashMap<String, String> clusterProperties = new HashMap<String, String>();
            if (!(coloVariants == null || coloVariants.size() <= 0 || coloVariants.size() == 1 && coloVariants.contains(""))) {
                clusterProperties.put("coloVariants", String.join((CharSequence)LIST_SEPARATOR, (Iterable<? extends CharSequence>)coloVariants));
            }
            if (masterColo != null && !masterColo.equals("")) {
                clusterProperties.put("masterColo", masterColo);
            }
            if (clusterVariantConfig != null && clusterVariantConfig.size() > 0) {
                clusterProperties.put("clusterVariants", String.join((CharSequence)LIST_SEPARATOR, clusterVariantConfig.keySet()));
            }
            clusterConfig.put("properties", clusterProperties);
            if (coloVariants == null || coloVariants.size() == 1 && coloVariants.contains("")) {
                coloVariants = Collections.singletonList("");
            } else {
                if (!coloVariants.contains(defaultColo)) {
                    throw new IllegalStateException("The default colo: " + defaultColo + " is not one of the peer colos = " + coloVariants);
                }
                if (masterColo != null && !coloVariants.contains(masterColo) && !enableSymlink) {
                    throw new IllegalStateException("The master colo: " + masterColo + " is not one of the peer colos = " + coloVariants);
                }
            }
            boolean defaultServicesCreated = false;
            for (String colo : coloVariants) {
                String coloClusterName = D2Utils.addSuffixToBaseName(string, colo);
                HashMap<String, Map<String, Object>> coloServicesConfigs = new HashMap<String, Map<String, Object>>();
                boolean createDefaultServices = !defaultServicesCreated ? this.shouldCreateDefaultServices(colo, defaultColo) : false;
                for (String serviceName : servicesConfigs.keySet()) {
                    boolean defaultRoutingToMasterColo;
                    Map serviceConfig = (Map)servicesConfigs.get(serviceName);
                    String createColoVariants = (String)serviceConfig.get("hasColoVariants");
                    boolean createColoVariantsForService = this.shouldCreateColoVariantsForService(colo, createColoVariants);
                    String coloServiceName = serviceName;
                    boolean bl = defaultRoutingToMasterColo = serviceConfig.containsKey("defaultRouting") && "Master".equals(serviceConfig.get("defaultRouting"));
                    if (createColoVariantsForService) {
                        coloServiceName = D2Utils.addSuffixToBaseName(serviceName, colo);
                    }
                    Object transportClientProperty = serviceConfig.get("transportClientProperties");
                    Map transportClientConfig = (Map)transportClientProperty;
                    serviceConfig.put("transportClientProperties", transportClientConfig);
                    HashMap<String, String> coloServiceConfig = new HashMap<String, String>(serviceConfig);
                    if (createDefaultServices && !defaultServicesCreated) {
                        if (masterColo != null && createColoVariantsForService) {
                            HashMap<String, String> masterServiceConfig = new HashMap<String, String>(serviceConfig);
                            String masterServiceName = serviceName + "Master";
                            String masterClusterName = enableSymlink ? D2Utils.getSymlinkNameForMaster(string) : D2Utils.addSuffixToBaseName(string, masterColo);
                            masterServiceConfig.put("clusterName", masterClusterName);
                            masterServiceConfig.put("serviceName", masterServiceName);
                            masterServiceConfig.put("isMasterService", "true");
                            coloServicesConfigs.put(masterServiceName, masterServiceConfig);
                        }
                        HashMap<String, String> regularServiceConfig = new HashMap<String, String>(serviceConfig);
                        if (createColoVariantsForService) {
                            regularServiceConfig.put("isDefaultService", "true");
                            if (defaultRoutingToMasterColo) {
                                regularServiceConfig.put("defaultRoutingToMaster", "true");
                            }
                        }
                        String defaultColoClusterName = D2Config.clusterNameWithRouting(string, colo, defaultColo, masterColo, defaultRoutingToMasterColo, enableSymlink);
                        regularServiceConfig.put("clusterName", defaultColoClusterName);
                        regularServiceConfig.put("serviceName", serviceName);
                        coloServicesConfigs.put(serviceName, regularServiceConfig);
                    }
                    if (serviceName.equals(coloServiceName)) continue;
                    coloServiceConfig.put("clusterName", coloClusterName);
                    coloServiceConfig.put("serviceName", coloServiceName);
                    coloServicesConfigs.put(coloServiceName, coloServiceConfig);
                }
                status = this.addServicesToServicesMap(coloServicesConfigs, services, coloClusterName);
                if (status != 0) {
                    return status;
                }
                HashMap<String, Object> coloClusterConfig = clusterConfig;
                if (!string.equals(coloClusterName)) {
                    coloClusterConfig = new HashMap<String, Object>(clusterConfig);
                    coloClusterConfig.put("clusterName", coloClusterName);
                    if (createDefaultServices) {
                        clusters.put(string, clusterConfig);
                    }
                }
                clusters.put(coloClusterName, (Map<String, Object>)coloClusterConfig);
                if (clusterVariantConfig != null) {
                    HashMap<String, Map<String, Object>> coloClusterVariantConfig = new HashMap<String, Map<String, Object>>(clusterVariantConfig);
                    status = this.handleClusterVariants(coloClusterVariantConfig, clusterConfig, clusters, coloServicesConfigs, clusterToServiceMapping, colo, variantToVariantsMapping, masterColo, enableSymlink);
                    if (status != 0) {
                        return status;
                    }
                } else {
                    clusterToServiceMapping.put(coloClusterName, coloServicesConfigs);
                    this.addNewVariantToVariantsList(clusterToColoClustersMapping, string, coloClusterName);
                }
                if (defaultServicesCreated || !createDefaultServices) continue;
                defaultServicesCreated = true;
            }
        }
        if (this._serviceVariants != null) {
            for (String string : this._serviceVariants.keySet()) {
                HashMap servicesGroupConfig = new HashMap();
                Map configGroupMap = (Map)this._serviceVariants.get(string);
                String type = (String)configGroupMap.get("type");
                Object clusterListProperty = configGroupMap.get("clusterList");
                List clusterList = (List)clusterListProperty;
                ListIterator iter = clusterList.listIterator();
                while (iter.hasNext()) {
                    String clusterItem = (String)iter.next();
                    List coloClusterVariantList = (List)variantToVariantsMapping.get(clusterItem);
                    if (coloClusterVariantList == null && "fullClusterList".equals(type)) {
                        coloClusterVariantList = (List)clusterToColoClustersMapping.get(clusterItem);
                    }
                    if (coloClusterVariantList == null) {
                        _log.error("Unknown cluster specified: " + clusterItem);
                        return 2;
                    }
                    for (String coloClusterVariant : coloClusterVariantList) {
                        Map candidateServices = (Map)clusterToServiceMapping.get(coloClusterVariant);
                        if (candidateServices == null) {
                            _log.error("Unknown cluster specified: " + coloClusterVariant);
                            return 2;
                        }
                        for (Map.Entry mapEntry : candidateServices.entrySet()) {
                            Object testValue = servicesGroupConfig.put(mapEntry.getKey(), mapEntry.getValue());
                            if (testValue == null) continue;
                            _log.error("Service group has variants of the same cluster: " + string);
                            return 2;
                        }
                    }
                }
                if ("clusterVariantsList".equals(type)) {
                    HashMap fullServiceList = new HashMap(services);
                    fullServiceList.putAll(servicesGroupConfig);
                    serviceVariants.put(string, fullServiceList);
                    continue;
                }
                if ("fullClusterList".equals(type)) {
                    serviceVariants.put(string, servicesGroupConfig);
                    continue;
                }
                _log.error("unknown serviceVariant type: " + type);
                return 2;
            }
        }
        _log.debug("serviceVariants: " + serviceVariants);
        this._zkConnection.start();
        try {
            _log.info("Cluster configuration:\n" + clusters);
            this.writeConfig(ZKFSUtil.clusterPath(this._basePath), new ClusterPropertiesJsonSerializer(), new ClusterPropertiesJsonSerializer(), clusters, this._clusterDefaults);
            _log.info("Wrote cluster configuration");
            _log.info("Service configuration:\n" + services);
            this.writeConfig(ZKFSUtil.servicePath(this._basePath), new ServicePropertiesJsonSerializer(), new ServicePropertiesJsonSerializer(), services, this._serviceDefaults);
            _log.info("Wrote service configuration");
            this.writeChildren(regularClusterToServicesMapping);
            _log.info("Wrote service children nodes under clusters");
            if (!serviceVariants.isEmpty()) {
                for (Map.Entry entry : serviceVariants.entrySet()) {
                    if (_log.isDebugEnabled()) {
                        _log.info("serviceVariant: " + entry + "\n");
                    } else {
                        _log.info("serviceVariant: " + (String)entry.getKey() + "\n");
                    }
                    this.writeConfig(ZKFSUtil.servicePath(this._basePath, (String)entry.getKey()), new ServicePropertiesJsonSerializer(), new ServicePropertiesJsonSerializer(), (Map)entry.getValue(), this._serviceDefaults);
                }
                _log.info("Wrote service variant configurations");
            }
            _log.info("Configuration complete");
            int n = 0;
            return n;
        }
        finally {
            try {
                this._zkConnection.shutdown();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                _log.warn("ZooKeeper shutdown interrupted", (Throwable)interruptedException);
            }
        }
    }

    protected static String clusterNameWithRouting(String clusterName, String destinationColo, String defaultColo, String masterColo, boolean defaultRoutingToMasterColo, boolean enableSymlink) {
        String defaultColoClusterName = "".matches(destinationColo) ? clusterName : (defaultRoutingToMasterColo ? (enableSymlink ? D2Utils.getSymlinkNameForMaster(clusterName) : D2Utils.addSuffixToBaseName(clusterName, masterColo)) : D2Utils.addSuffixToBaseName(clusterName, defaultColo));
        return defaultColoClusterName;
    }

    private <T> void writeConfig(String path, PropertySerializer<T> serializer, PropertyBuilder<T> builder, Map<String, Map<String, Object>> properties, Map<String, Object> propertyDefaults) throws Exception {
        ZooKeeperPermanentStore store = this._useDeltaWrite ? new DeltaWriteZooKeeperPermanentStore<T>(this._zkConnection, serializer, path) : new ZooKeeperPermanentStore<T>(this._zkConnection, serializer, path);
        ConfigWriter<T> writer = new ConfigWriter<T>(store, builder, properties, propertyDefaults, this._timeout, TimeUnit.MILLISECONDS, this._maxOutstandingWrites);
        writer.writeConfig();
    }

    private void writeChildren(Map<String, List<String>> clusterToServices) throws InterruptedException, ExecutionException, TimeoutException {
        for (Map.Entry<String, List<String>> entry : clusterToServices.entrySet()) {
            String clusterName = entry.getKey();
            List<String> services = entry.getValue();
            for (String serviceName : services) {
                FutureCallback callback = new FutureCallback();
                this._zkConnection.ensurePersistentNodeExists(D2Utils.getServicePathAsChildOfCluster(clusterName, serviceName), (Callback<None>)callback);
                callback.get(this._timeout, TimeUnit.MILLISECONDS);
            }
        }
    }

    private Map<String, Object> merge(List<Map<String, Object>> maps) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map<String, Object> map : maps) {
            for (Map.Entry<String, Object> e : map.entrySet()) {
                if (result.put(e.getKey(), e.getValue()) == null) continue;
                throw new IllegalArgumentException("Cluster " + e.getKey() + " is present in multiple maps");
            }
        }
        return result;
    }

    private int handlePartitionProperties(Map<String, Object> partitionProperties, Map<String, Object> clusterConfig, String clusterName) {
        PartitionProperties.PartitionType partitionType = PropertyUtil.checkAndGetValue(partitionProperties, "partitionType", PartitionProperties.PartitionType.class, clusterName);
        switch (partitionType) {
            case RANGE: {
                if (partitionProperties.get("partitionKeyRegex") == null) {
                    _log.error("null partitionKeyRegex for cluster: " + clusterName);
                    return 3;
                }
                Long partitionSize = PropertyUtil.parseLong("partitionSize", PropertyUtil.checkAndGetValue(partitionProperties, "partitionSize", String.class, clusterName));
                int partitionCount = PropertyUtil.parseInt("partitionCount", PropertyUtil.checkAndGetValue(partitionProperties, "partitionCount", String.class, clusterName));
                Long start = PropertyUtil.parseLong("keyRangeStart", PropertyUtil.checkAndGetValue(partitionProperties, "keyRangeStart", String.class, clusterName));
                if (partitionSize <= 0L) {
                    _log.error("Non-positive partition size! Cluster: " + clusterName);
                    return 3;
                }
                if (start < 0L) {
                    _log.error("partition id needs to be non negative");
                    return 3;
                }
                if (partitionCount < 0) {
                    _log.error("partition count needs to be non negative");
                    return 3;
                }
                partitionProperties.put("partitionSize", partitionSize);
                partitionProperties.put("partitionCount", partitionCount);
                partitionProperties.put("keyRangeStart", start);
                clusterConfig.put("partitionProperties", partitionProperties);
                break;
            }
            case HASH: {
                if (partitionProperties.get("partitionKeyRegex") == null) {
                    _log.error("null partitionKeyRegex for cluster: " + clusterName);
                    return 3;
                }
                int partitionCount = PropertyUtil.parseInt("partitionCount", PropertyUtil.checkAndGetValue(partitionProperties, "partitionCount", String.class, clusterName));
                if (partitionCount < 0) {
                    _log.error("partition count needs to be non negative");
                    return 3;
                }
                partitionProperties.put("partitionCount", partitionCount);
                clusterConfig.put("partitionProperties", partitionProperties);
                try {
                    String algorithm = PropertyUtil.checkAndGetValue(partitionProperties, "hashAlgorithm", String.class, clusterName);
                    HashBasedPartitionProperties.HashAlgorithm.valueOf(algorithm.toUpperCase());
                    break;
                }
                catch (Exception e) {
                    _log.error("Hash algorithm not supported", (Throwable)e);
                    return 3;
                }
            }
        }
        return 0;
    }

    private int handleClusterVariants(Map<String, Map<String, Object>> clusterVariantConfig, Map<String, Object> clusterConfig, Map<String, Map<String, Object>> clusters, Map<String, Map<String, Object>> servicesConfigs, Map<String, Map<String, Map<String, Object>>> clusterToServiceMapping, String coloStr, Map<String, List<String>> variantToVariantsMapping, String masterColo, boolean enableSymlink) {
        for (String variant : clusterVariantConfig.keySet()) {
            Map<String, Object> varConfig = clusterVariantConfig.get(variant);
            String variantColoName = D2Utils.addSuffixToBaseName(variant, coloStr);
            String masterColoName = enableSymlink ? D2Utils.getSymlinkNameForMaster(variant) : D2Utils.addSuffixToBaseName(variant, masterColo);
            varConfig = ConfigWriter.merge(varConfig, clusterConfig);
            varConfig.put("clusterName", variantColoName);
            Map<String, Object> oldCluster = clusters.put(variantColoName, varConfig);
            if (oldCluster != null) {
                _log.error("Cluster variant name: " + variantColoName + " is not unique!");
                return 2;
            }
            HashMap<String, Map<String, Object>> varServicesConfig = new HashMap<String, Map<String, Object>>();
            for (Map.Entry<String, Map<String, Object>> entry : servicesConfigs.entrySet()) {
                boolean defaultRoutingToMasterColo;
                Map<String, Object> varServiceConfig = ConfigWriter.merge(entry.getValue(), null);
                String masterServiceString = (String)varServiceConfig.get("isMasterService");
                String defaultServiceString = (String)varServiceConfig.get("isDefaultService");
                boolean bl = defaultRoutingToMasterColo = varServiceConfig.containsKey("defaultRouting") && "Master".equals(varServiceConfig.get("defaultRouting"));
                if (masterServiceString != null && "true".equalsIgnoreCase(masterServiceString)) {
                    varServiceConfig.put("clusterName", masterColoName);
                } else if (defaultRoutingToMasterColo && defaultServiceString != null && "true".equalsIgnoreCase(defaultServiceString)) {
                    varServiceConfig.put("clusterName", masterColoName);
                } else {
                    varServiceConfig.put("clusterName", variantColoName);
                }
                varServicesConfig.put(entry.getKey(), varServiceConfig);
            }
            clusterToServiceMapping.put(variantColoName, varServicesConfig);
            this.addNewVariantToVariantsList(variantToVariantsMapping, variant, variantColoName);
        }
        return 0;
    }

    private void addNewVariantToVariantsList(Map<String, List<String>> variantToVariantsMapping, String variant, String variantName) {
        List<String> variantsList = variantToVariantsMapping.get(variant);
        if (variantsList != null) {
            variantsList.add(variantName);
        } else {
            variantsList = new ArrayList<String>();
            variantsList.add(variantName);
            variantToVariantsMapping.put(variant, variantsList);
        }
    }

    private int addServicesToServicesMap(Map<String, Map<String, Object>> servicesConfigs, Map<String, Map<String, Object>> services, String clusterName) {
        for (Map.Entry<String, Map<String, Object>> entry : servicesConfigs.entrySet()) {
            Map<String, Object> previousEntry = services.put(entry.getKey(), entry.getValue());
            if (previousEntry == null) continue;
            _log.error("Identical service name found in multiple clusters! Service: " + entry.getKey() + ", cluster that caused conflict: " + clusterName);
            return 2;
        }
        return 0;
    }

    private boolean shouldCreateColoVariantsForService(String colo, String createColoVariants) {
        if ("".equals(colo)) {
            return false;
        }
        return createColoVariants == null || !"false".equalsIgnoreCase(createColoVariants);
    }

    private boolean shouldCreateDefaultServices(String colo, String defaultColo) {
        if ("".equals(colo)) {
            return true;
        }
        return defaultColo.equalsIgnoreCase(colo);
    }
}

