/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.schema.AbstractSchemaEncoder;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.schema.JsonBuilder;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.Named;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SchemaToJsonEncoder
extends AbstractSchemaEncoder {
    protected final JsonBuilder _builder;
    protected String _currentNamespace = "";
    protected String _currentPackage = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String schemaToJson(DataSchema schema, JsonBuilder.Pretty pretty) {
        JsonBuilder builder = null;
        try {
            builder = new JsonBuilder(pretty);
            SchemaToJsonEncoder encoder = new SchemaToJsonEncoder(builder);
            encoder.encode(schema);
            String string = builder.result();
            return string;
        }
        catch (IOException exc) {
            String string = exc.getMessage();
            return string;
        }
        finally {
            if (builder != null) {
                builder.closeQuietly();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String schemasToJson(Collection<DataSchema> schemas, JsonBuilder.Pretty pretty) {
        JsonBuilder builder = null;
        try {
            builder = new JsonBuilder(pretty);
            SchemaToJsonEncoder encoder = new SchemaToJsonEncoder(builder);
            for (DataSchema schema : schemas) {
                encoder.encode(schema);
            }
            String string = builder.result();
            return string;
        }
        catch (IOException exc) {
            String string = exc.getMessage();
            return string;
        }
        finally {
            if (builder != null) {
                builder.closeQuietly();
            }
        }
    }

    public SchemaToJsonEncoder(JsonBuilder builder, AbstractSchemaEncoder.TypeReferenceFormat typeReferenceFormat) {
        super(typeReferenceFormat);
        this._builder = builder;
    }

    public SchemaToJsonEncoder(JsonBuilder builder) {
        this._builder = builder;
    }

    public void setCurrentNamespace(String namespace) {
        this._currentNamespace = namespace;
    }

    public String getCurrentNamespace() {
        return this._currentNamespace;
    }

    @Override
    public void encode(DataSchema schema) throws IOException {
        this.encode(schema, true);
    }

    protected void encode(DataSchema schema, boolean originallyInlined) throws IOException {
        AbstractSchemaEncoder.TypeRepresentation representation = this.selectTypeRepresentation(schema, originallyInlined);
        this.markEncountered(schema);
        if (schema.isPrimitive()) {
            this._builder.writeString(schema.getUnionMemberKey());
        } else if (schema instanceof NamedDataSchema) {
            this.encodeNamed((NamedDataSchema)schema, representation);
        } else {
            this.encodeUnnamed(schema);
        }
    }

    protected void encodeUnnamed(DataSchema schema) throws IOException {
        DataSchema.Type type = schema.getType();
        switch (type) {
            case ARRAY: {
                this._builder.writeStartObject();
                this._builder.writeStringField("type", "array", true);
                this._builder.writeFieldName("items");
                ArrayDataSchema arrayDataSchema = (ArrayDataSchema)schema;
                this.encode(arrayDataSchema.getItems(), arrayDataSchema.isItemsDeclaredInline());
                this.encodeProperties(schema);
                this._builder.writeEndObject();
                break;
            }
            case MAP: {
                this._builder.writeStartObject();
                this._builder.writeStringField("type", "map", true);
                this._builder.writeFieldName("values");
                MapDataSchema mapDataSchema = (MapDataSchema)schema;
                this.encode(mapDataSchema.getValues(), mapDataSchema.isValuesDeclaredInline());
                this.encodeProperties(schema);
                this._builder.writeEndObject();
                break;
            }
            case UNION: {
                this._builder.writeStartArray();
                UnionDataSchema unionSchema = (UnionDataSchema)schema;
                for (DataSchema memberSchema : unionSchema.getTypes()) {
                    this.encode(memberSchema, unionSchema.isTypeDeclaredInline(memberSchema));
                }
                this._builder.writeEndArray();
                break;
            }
            default: {
                throw new IllegalStateException("schema type " + (Object)((Object)schema.getType()) + " is not a known unnamed DataSchema type");
            }
        }
    }

    protected void encodeNamed(NamedDataSchema schema) throws IOException {
        AbstractSchemaEncoder.TypeRepresentation representation = this.selectTypeRepresentation(schema, true);
        this.markEncountered(schema);
        this.encodeNamed(schema, representation);
    }

    protected void encodeNamed(NamedDataSchema schema, AbstractSchemaEncoder.TypeRepresentation representation) throws IOException {
        if (representation == AbstractSchemaEncoder.TypeRepresentation.REFERENCED_BY_NAME) {
            this.writeSchemaName(schema);
            return;
        }
        String saveCurrentNamespace = this._currentNamespace;
        String saveCurrentPackage = this._currentPackage;
        this._builder.writeStartObject();
        this._builder.writeStringField("type", schema.getType().toString().toLowerCase(), true);
        this.encodeName("name", schema);
        String packageName = schema.getPackage();
        if (packageName != null && !this._currentPackage.equals(packageName)) {
            this._builder.writeStringField("package", packageName, false);
            this._currentPackage = packageName;
        }
        this._builder.writeStringField("doc", schema.getDoc(), false);
        switch (schema.getType()) {
            case TYPEREF: {
                this._builder.writeFieldName("ref");
                TyperefDataSchema typerefDataSchema = (TyperefDataSchema)schema;
                this.encode(typerefDataSchema.getRef(), typerefDataSchema.isRefDeclaredInline());
                break;
            }
            case ENUM: {
                this._builder.writeStringArrayField("symbols", ((EnumDataSchema)schema).getSymbols(), true);
                this._builder.writeMapField("symbolDocs", ((EnumDataSchema)schema).getSymbolDocs(), false);
                break;
            }
            case FIXED: {
                this._builder.writeIntField("size", ((FixedDataSchema)schema).getSize());
                break;
            }
            case RECORD: {
                RecordDataSchema recordDataSchema = (RecordDataSchema)schema;
                if (this.isEncodeInclude() && !recordDataSchema.getInclude().isEmpty()) {
                    this._builder.writeFieldName("include");
                    this._builder.writeStartArray();
                    for (NamedDataSchema includedSchema : recordDataSchema.getInclude()) {
                        this.encode(includedSchema);
                    }
                    this._builder.writeEndArray();
                }
                this._builder.writeFieldName("fields");
                this.encodeFields(recordDataSchema);
                break;
            }
            default: {
                throw new IllegalStateException("schema type " + (Object)((Object)schema.getType()) + " is not a known NamedDataSchema type");
            }
        }
        this.encodeProperties(schema);
        ArrayList<String> aliases = new ArrayList<String>();
        for (Name name : schema.getAliases()) {
            aliases.add(name.getFullName());
        }
        this._builder.writeStringArrayField("aliases", aliases, false);
        this._builder.writeEndObject();
        this._currentNamespace = saveCurrentNamespace;
        this._currentPackage = saveCurrentPackage;
    }

    protected void writeSchemaName(NamedDataSchema schema) throws IOException {
        this._builder.writeString(this._currentNamespace.equals(schema.getNamespace()) ? schema.getName() : schema.getFullName());
    }

    protected void encodeProperties(DataSchema schema) throws IOException {
        this._builder.writeProperties(schema.getProperties());
    }

    protected void encodeFields(RecordDataSchema recordDataSchema) throws IOException {
        List<RecordDataSchema.Field> fields = recordDataSchema.getFields();
        this._builder.writeStartArray();
        boolean encodeInclude = this.isEncodeInclude();
        for (RecordDataSchema.Field field : fields) {
            if (encodeInclude && recordDataSchema != field.getRecord()) continue;
            this.encodeField(field);
        }
        this._builder.writeEndArray();
    }

    protected void encodeField(RecordDataSchema.Field field) throws IOException {
        this._builder.writeStartObject();
        this._builder.writeStringField("name", field.getName(), true);
        this.encodeFieldType(field);
        this._builder.writeStringField("doc", field.getDoc(), false);
        this.encodeFieldDefault(field);
        this.encodeFieldOptional(field);
        RecordDataSchema.Field.Order order = field.getOrder();
        if (order != RecordDataSchema.Field.Order.ASCENDING) {
            this._builder.writeStringField("order", order.toString().toLowerCase(), true);
        }
        this._builder.writeProperties(field.getProperties());
        this._builder.writeStringArrayField("aliases", field.getAliases(), false);
        this._builder.writeEndObject();
    }

    protected void encodeFieldType(RecordDataSchema.Field field) throws IOException {
        this._builder.writeFieldName("type");
        DataSchema fieldSchema = field.getType();
        this.encode(fieldSchema, field.isDeclaredInline());
    }

    protected void encodeFieldDefault(RecordDataSchema.Field field) throws IOException {
        if (field.getDefault() != null) {
            this._builder.writeFieldName("default");
            this._builder.writeData(field.getDefault());
        }
    }

    protected void encodeFieldOptional(RecordDataSchema.Field field) throws IOException {
        boolean optional = field.getOptional();
        if (optional) {
            this._builder.writeBooleanField("optional", optional);
        }
    }

    protected void encodeName(String nameKey, Named schema) throws IOException {
        String fullName = schema.getFullName();
        if (!fullName.isEmpty()) {
            String namespace = schema.getNamespace();
            this._builder.writeStringField(nameKey, schema.getName(), true);
            if (!this._currentNamespace.equals(namespace)) {
                this._builder.writeStringField("namespace", namespace, true);
            }
            this._currentNamespace = namespace;
        }
    }

    protected boolean isEncodeInclude() {
        return true;
    }
}

