/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.generator;

import com.linkedin.data.schema.AbstractSchemaParser;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PegasusSchemaParser;
import com.linkedin.data.schema.resolver.DefaultDataSchemaResolver;
import com.linkedin.data.schema.resolver.FileDataSchemaLocation;
import com.linkedin.data.schema.resolver.MultiFormatDataSchemaResolver;
import com.linkedin.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class AbstractGenerator {
    public static final String GENERATOR_RESOLVER_PATH = "generator.resolver.path";
    private final StringBuilder _message = new StringBuilder();
    private DataSchemaResolver _schemaResolver = new DefaultDataSchemaResolver();

    protected abstract void handleSchema(DataSchema var1);

    protected abstract Config getConfig();

    protected StringBuilder getMessage() {
        return this._message;
    }

    protected DataSchemaResolver getSchemaResolver() {
        return this._schemaResolver;
    }

    protected void initSchemaResolver() {
        String resolverPath = this.getConfig().getResolverPath();
        if (resolverPath != null) {
            this._schemaResolver = MultiFormatDataSchemaResolver.withBuiltinFormats(resolverPath);
        }
    }

    protected List<File> parseSources(String[] sources) throws IOException {
        try {
            ArrayList<File> sourceFiles = new ArrayList<File>();
            for (String source : sources) {
                File sourceFile = new File(source);
                if (sourceFile.exists()) {
                    if (sourceFile.isDirectory()) {
                        FileUtil.FileExtensionFilter filter = new FileUtil.FileExtensionFilter(MultiFormatDataSchemaResolver.BUILTIN_EXTENSIONS);
                        List<File> sourceFilesInDirectory = FileUtil.listFiles(sourceFile, filter);
                        for (File f : sourceFilesInDirectory) {
                            this.parseFile(f);
                            sourceFiles.add(f);
                        }
                        continue;
                    }
                    this.parseFile(sourceFile);
                    sourceFiles.add(sourceFile);
                    continue;
                }
                StringBuilder errorMessage = new StringBuilder();
                NamedDataSchema schema = this.getSchemaResolver().findDataSchema(source, errorMessage);
                if (schema == null) {
                    this.getMessage().append("File cannot be opened or schema name cannot be resolved: " + source + "\n");
                }
                if (errorMessage.length() > 0) {
                    this.getMessage().append(errorMessage.toString());
                }
                if (schema == null) continue;
                this.handleSchema(schema);
            }
            if (this.getMessage().length() > 0) {
                throw new IOException(this.getMessage().toString());
            }
            this.appendSourceFilesFromSchemaResolver(sourceFiles);
            return sourceFiles;
        }
        catch (RuntimeException e) {
            if (this.getMessage().length() > 0) {
                e = new RuntimeException("Unexpected " + e.getClass().getSimpleName() + " encountered.\nThis may be caused by the following parsing or processing errors:\n" + this.getMessage(), e);
            }
            throw e;
        }
    }

    protected void parseFile(File schemaSourceFile) throws IOException {
        if (this.wasResolved(schemaSourceFile)) {
            return;
        }
        List<DataSchema> schemas = this.parseSchema(schemaSourceFile);
        for (DataSchema schema : schemas) {
            this.validateSchemaWithFilepath(schemaSourceFile, schema);
            this.handleSchema(schema);
        }
    }

    private void validateSchemaWithFilepath(File schemaSourceFile, DataSchema schema) {
        if (schemaSourceFile != null && schemaSourceFile.isFile() && schema instanceof NamedDataSchema) {
            NamedDataSchema namedDataSchema = (NamedDataSchema)schema;
            String namespace = namedDataSchema.getNamespace();
            if (!FileUtil.removeFileExtension(schemaSourceFile.getName()).equalsIgnoreCase(namedDataSchema.getName())) {
                throw new IllegalArgumentException(namedDataSchema.getFullName() + " has name that does not match filename '" + schemaSourceFile.getAbsolutePath() + "'");
            }
            String directory = schemaSourceFile.getParentFile().getAbsolutePath();
            if (!directory.endsWith(namespace.replace('.', File.separatorChar))) {
                throw new IllegalArgumentException(namedDataSchema.getFullName() + " has namespace that does not match file path '" + schemaSourceFile.getAbsolutePath() + "'");
            }
        }
    }

    protected boolean wasResolved(File schemaSourceFile) {
        FileDataSchemaLocation schemaLocation = new FileDataSchemaLocation(schemaSourceFile);
        return this.getSchemaResolver().locationResolved(schemaLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DataSchema> parseSchema(File schemaSourceFile) throws IOException {
        PegasusSchemaParser parser = AbstractSchemaParser.parserForFile(schemaSourceFile, this.getSchemaResolver());
        SchemaFileInputStream schemaStream = new SchemaFileInputStream(schemaSourceFile);
        try {
            parser.setLocation(new FileDataSchemaLocation(schemaSourceFile));
            parser.parse(schemaStream);
            if (parser.hasError()) {
                List<DataSchema> list = Collections.emptyList();
                return list;
            }
            List<DataSchema> list = parser.topLevelDataSchemas();
            return list;
        }
        finally {
            schemaStream.close();
            if (parser.hasError()) {
                this.getMessage().append(schemaSourceFile.getPath() + ",");
                this.getMessage().append(parser.errorMessage());
            }
        }
    }

    protected void appendSourceFilesFromSchemaResolver(List<File> sourceFiles) {
        for (Map.Entry<String, DataSchemaLocation> entry : this.getSchemaResolver().nameToDataSchemaLocations().entrySet()) {
            DataSchemaLocation location = entry.getValue();
            File sourceFile = location.getSourceFile();
            if (sourceFile == null) continue;
            sourceFiles.add(sourceFile);
        }
    }

    class SchemaFileInputStream
    extends FileInputStream {
        private File _schemaSourceFile;

        public SchemaFileInputStream(File file) throws FileNotFoundException {
            super(file);
            this._schemaSourceFile = file;
        }

        public String toString() {
            return this._schemaSourceFile.toString();
        }
    }

    protected static class Config {
        private final String _resolverPath;

        public Config(String resolverPath) {
            this._resolverPath = resolverPath;
        }

        public String getResolverPath() {
            return this._resolverPath;
        }
    }
}

