/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.util;

import com.linkedin.data.DataMap;
import com.linkedin.data.it.Builder;
import com.linkedin.data.it.IterationOrder;
import com.linkedin.data.it.Predicate;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PegasusSchemaParser;
import com.linkedin.data.schema.util.Conversions;

public class Filters {
    static final String NO_SCHEMA_LEFT = "No schema is left after filtering, root object has been removed\n";
    static final String INVALID_SCHEMA_LEFT = "DataMap left after filtering is not a valid schema\n";

    public static NamedDataSchema removeByPredicate(NamedDataSchema schema, Predicate predicate, PegasusSchemaParser parser) {
        DataSchema resultDataSchema;
        DataMap schemaAsDataMap = Conversions.dataSchemaToDataMap(schema);
        DataMap map = (DataMap)Builder.create(schemaAsDataMap, null, IterationOrder.PRE_ORDER).filterBy(predicate).remove();
        if (map == null) {
            parser.errorMessageBuilder().append(NO_SCHEMA_LEFT);
        }
        if ((resultDataSchema = Conversions.dataMapToDataSchema(map, parser)) == null) {
            parser.errorMessageBuilder().append(INVALID_SCHEMA_LEFT + map);
        }
        return (NamedDataSchema)resultDataSchema;
    }
}

