/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.io;

import com.codahale.metrics.Meter;
import com.google.common.base.Optional;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.gobblin.util.io.BatchedMeterDecorator;
import org.apache.gobblin.util.io.FilterStreamUnpacker;
import org.apache.gobblin.util.io.MeteredStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeteredOutputStream
extends FilterOutputStream
implements MeteredStream {
    private static final Logger log = LoggerFactory.getLogger(MeteredOutputStream.class);
    BatchedMeterDecorator meter;

    public static Optional<MeteredOutputStream> findWrappedMeteredOutputStream(OutputStream os) {
        if (os instanceof FilterOutputStream) {
            try {
                Optional<MeteredOutputStream> meteredOutputStream = MeteredOutputStream.findWrappedMeteredOutputStream(FilterStreamUnpacker.unpackFilterOutputStream((FilterOutputStream)os));
                if (meteredOutputStream.isPresent()) {
                    return meteredOutputStream;
                }
            }
            catch (IllegalAccessException iae) {
                log.warn("Cannot unpack input stream due to SecurityManager.", (Throwable)iae);
            }
        }
        if (os instanceof MeteredOutputStream) {
            return Optional.of((Object)((MeteredOutputStream)os));
        }
        return Optional.absent();
    }

    public MeteredOutputStream(OutputStream out, Meter meter, int updateFrequency) {
        super(out);
        this.meter = new BatchedMeterDecorator(meter == null ? new Meter() : meter, updateFrequency > 0 ? updateFrequency : 1000);
    }

    @Override
    public void write(int b) throws IOException {
        this.meter.mark();
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.meter.mark(len);
        this.out.write(b, off, len);
    }

    @Override
    public Meter getBytesProcessedMeter() {
        return this.meter.getUnderlyingMeter();
    }

    public static MeteredOutputStreamBuilder builder() {
        return new MeteredOutputStreamBuilder();
    }

    public static class MeteredOutputStreamBuilder {
        private OutputStream out;
        private Meter meter;
        private int updateFrequency;

        MeteredOutputStreamBuilder() {
        }

        public MeteredOutputStreamBuilder out(OutputStream out) {
            this.out = out;
            return this;
        }

        public MeteredOutputStreamBuilder meter(Meter meter) {
            this.meter = meter;
            return this;
        }

        public MeteredOutputStreamBuilder updateFrequency(int updateFrequency) {
            this.updateFrequency = updateFrequency;
            return this;
        }

        public MeteredOutputStream build() {
            return new MeteredOutputStream(this.out, this.meter, this.updateFrequency);
        }

        public String toString() {
            return "MeteredOutputStream.MeteredOutputStreamBuilder(out=" + this.out + ", meter=" + this.meter + ", updateFrequency=" + this.updateFrequency + ")";
        }
    }
}

