/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.io;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.gobblin.util.io.MeteredInputStream;
import org.apache.gobblin.util.limiter.Limiter;

@NotThreadSafe
public class ThrottledInputStream
extends FilterInputStream {
    private final Limiter limiter;
    private final MeteredInputStream meter;
    private long prevCount;

    public ThrottledInputStream(InputStream in, Limiter limiter, MeteredInputStream meter) {
        super(in);
        this.limiter = limiter;
        this.meter = meter;
        this.prevCount = this.meter.getBytesProcessedMeter().getCount();
    }

    @Override
    public int read() throws IOException {
        this.blockUntilPermitsAvailable();
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.blockUntilPermitsAvailable();
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.blockUntilPermitsAvailable();
        return this.in.read(b, off, len);
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.prevCount = this.meter.getBytesProcessedMeter().getCount();
    }

    private void blockUntilPermitsAvailable() {
        try {
            long currentCount = this.meter.getBytesProcessedMeter().getCount();
            long permitsNeeded = currentCount - this.prevCount;
            this.prevCount = currentCount;
            Closeable permit = this.limiter.acquirePermits(permitsNeeded);
            if (permit == null) {
                throw new RuntimeException("Could not acquire permits.");
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }
}

