/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.limiter.broker;

import org.apache.gobblin.broker.iface.SharedResourceKey;

public class SharedLimiterKey
implements SharedResourceKey {
    private final String resourceLimitedPath;
    private final GlobalLimiterPolicy globalLimiterPolicy;

    public SharedLimiterKey(String resourceLimitedPath) {
        this(resourceLimitedPath, GlobalLimiterPolicy.USE_GLOBAL_IF_CONFIGURED);
    }

    public SharedLimiterKey(String resourceLimitedPath, GlobalLimiterPolicy globalLimiterPolicy) {
        this.resourceLimitedPath = (resourceLimitedPath.startsWith("/") ? "" : "/") + resourceLimitedPath;
        this.globalLimiterPolicy = globalLimiterPolicy;
    }

    public String toString() {
        return this.toConfigurationKey();
    }

    public String toConfigurationKey() {
        return this.resourceLimitedPath.substring(1).replace("/", ".");
    }

    public String getResourceLimitedPath() {
        return this.resourceLimitedPath;
    }

    public GlobalLimiterPolicy getGlobalLimiterPolicy() {
        return this.globalLimiterPolicy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SharedLimiterKey)) {
            return false;
        }
        SharedLimiterKey other = (SharedLimiterKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$resourceLimitedPath = this.getResourceLimitedPath();
        String other$resourceLimitedPath = other.getResourceLimitedPath();
        if (this$resourceLimitedPath == null ? other$resourceLimitedPath != null : !this$resourceLimitedPath.equals(other$resourceLimitedPath)) {
            return false;
        }
        GlobalLimiterPolicy this$globalLimiterPolicy = this.getGlobalLimiterPolicy();
        GlobalLimiterPolicy other$globalLimiterPolicy = other.getGlobalLimiterPolicy();
        return !(this$globalLimiterPolicy == null ? other$globalLimiterPolicy != null : !((Object)((Object)this$globalLimiterPolicy)).equals((Object)other$globalLimiterPolicy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SharedLimiterKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $resourceLimitedPath = this.getResourceLimitedPath();
        result = result * 59 + ($resourceLimitedPath == null ? 43 : $resourceLimitedPath.hashCode());
        GlobalLimiterPolicy $globalLimiterPolicy = this.getGlobalLimiterPolicy();
        result = result * 59 + ($globalLimiterPolicy == null ? 43 : ((Object)((Object)$globalLimiterPolicy)).hashCode());
        return result;
    }

    public static enum GlobalLimiterPolicy {
        USE_GLOBAL,
        USE_GLOBAL_IF_CONFIGURED,
        LOCAL_ONLY;

    }
}

