/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message;

import com.linkedin.r2.message.BaseMessageBuilder;
import com.linkedin.r2.message.MessageHeadersBuilder;
import com.linkedin.r2.message.Request;
import com.linkedin.util.ArgumentUtil;
import java.net.URI;

public abstract class BaseRequestBuilder<B extends BaseRequestBuilder<B>>
extends BaseMessageBuilder<B>
implements MessageHeadersBuilder<B> {
    private URI _uri;
    private String _method = "GET";

    public BaseRequestBuilder(URI uri) {
        this.setURI(uri);
    }

    public BaseRequestBuilder(Request request) {
        super(request);
        this.setURI(request.getURI());
        this.setMethod(request.getMethod());
    }

    public URI getURI() {
        return this._uri;
    }

    public B setURI(URI uri) {
        ArgumentUtil.notNull((Object)uri, (String)"uri");
        this._uri = uri;
        return (B)((BaseRequestBuilder)this.thisBuilder());
    }

    public B setMethod(String method) {
        ArgumentUtil.notNull((Object)method, (String)"method");
        this._method = method;
        return (B)((BaseRequestBuilder)this.thisBuilder());
    }

    public String getMethod() {
        return this._method;
    }

    @Override
    protected void validateCookieHeader(String name) {
        if (name.equalsIgnoreCase("Cookie")) {
            String message = String.format("Header %s are not allowed to be added as a request header.", "Cookie");
            throw new IllegalArgumentException(message);
        }
    }
}

