/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message.rest;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.BaseRequest;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import java.net.URI;
import java.util.List;
import java.util.Map;

final class RestRequestImpl
extends BaseRequest
implements RestRequest {
    private final ByteString _entity;

    RestRequestImpl(ByteString entity, Map<String, String> headers, List<String> cookies, URI uri, String method) {
        super(headers, cookies, uri, method);
        this._entity = entity;
    }

    @Override
    public ByteString getEntity() {
        return this._entity;
    }

    @Override
    public RestRequestBuilder builder() {
        return new RestRequestBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RestRequestImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RestRequestImpl that = (RestRequestImpl)o;
        return this._entity.equals((Object)that._entity);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = result * 31 + this._entity.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RestRequest[headers=").append(this.getHeaders()).append("cookies=").append(this.getCookies()).append(",uri=").append(this.getURI()).append(",method=").append(this.getMethod()).append(",entityLength=").append(this._entity.length()).append("]");
        return builder.toString();
    }
}

