/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.graphite;

import com.google.common.base.Optional;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.event.MultiPartEvent;
import org.apache.gobblin.metrics.graphite.GraphiteConnectionType;
import org.apache.gobblin.metrics.graphite.GraphitePusher;
import org.apache.gobblin.metrics.reporter.EventReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteEventReporter
extends EventReporter {
    private final GraphitePusher graphitePusher;
    private final boolean emitValueAsKey;
    private static final String EMTPY_VALUE = "0";
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphiteEventReporter.class);
    private String prefix;

    public GraphiteEventReporter(Builder<?> builder) throws IOException {
        super(builder);
        this.graphitePusher = builder.graphitePusher.isPresent() ? (GraphitePusher)builder.graphitePusher.get() : (GraphitePusher)this.closer.register((Closeable)new GraphitePusher(builder.hostname, builder.port, builder.connectionType));
        this.emitValueAsKey = builder.emitValueAsKey;
        this.prefix = builder.prefix;
    }

    public void reportEventQueue(Queue<GobblinTrackingEvent> queue) {
        try {
            GobblinTrackingEvent nextEvent;
            while (null != (nextEvent = queue.poll())) {
                this.pushEvent(nextEvent);
            }
            this.graphitePusher.flush();
        }
        catch (IOException e) {
            LOGGER.error("Error sending event to Graphite", (Throwable)e);
            try {
                this.graphitePusher.flush();
            }
            catch (IOException e1) {
                LOGGER.error("Unable to flush previous events to Graphite", (Throwable)e);
            }
        }
    }

    private void pushEvent(GobblinTrackingEvent event) throws IOException {
        Map metadata = event.getMetadata();
        String name = this.getMetricName(metadata, event.getName());
        long timestamp = event.getTimestamp() / 1000L;
        MultiPartEvent multipartEvent = MultiPartEvent.getEvent((String)((String)metadata.get("eventType")));
        if (multipartEvent == null) {
            this.graphitePusher.push(JOINER.join((Object)this.prefix, (Object)name, new Object[0]), EMTPY_VALUE, timestamp);
        } else {
            for (String field : multipartEvent.getMetadataFields()) {
                String value = (String)metadata.get(field);
                if (value == null) {
                    this.graphitePusher.push(JOINER.join((Object)this.prefix, (Object)name, new Object[]{field}), EMTPY_VALUE, timestamp);
                    continue;
                }
                if (this.emitAsKey(field)) {
                    this.graphitePusher.push(JOINER.join((Object)this.prefix, (Object)name, new Object[]{field, value}), EMTPY_VALUE, timestamp);
                    continue;
                }
                this.graphitePusher.push(JOINER.join((Object)this.prefix, (Object)name, new Object[]{field}), this.convertValue(field, value), timestamp);
            }
        }
    }

    private String convertValue(String field, String value) {
        return "durationMillis".equals(field) ? Double.toString(this.convertDuration(TimeUnit.MILLISECONDS.toNanos(Long.parseLong(value)))) : value;
    }

    private boolean emitAsKey(String field) {
        return this.emitValueAsKey && (field.equals("taskWorkingState") || field.equals("jobState"));
    }

    @Deprecated
    public static Builder<? extends Builder> forContext(MetricContext context) {
        return new BuilderImpl(context);
    }

    public static abstract class Builder<T extends EventReporter.Builder<T>>
    extends EventReporter.Builder<T> {
        protected String hostname;
        protected int port;
        protected GraphiteConnectionType connectionType;
        protected Optional<GraphitePusher> graphitePusher = Optional.absent();
        protected boolean emitValueAsKey;
        protected String prefix;

        protected Builder(MetricContext context) {
            super(context);
            this.connectionType = GraphiteConnectionType.TCP;
        }

        public T withGraphitePusher(GraphitePusher pusher) {
            this.graphitePusher = Optional.of((Object)pusher);
            return (T)this.self();
        }

        public T withConnection(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
            return (T)this.self();
        }

        public T withPrefix(String prefix) {
            this.prefix = prefix;
            return (T)this.self();
        }

        public T withConnectionType(GraphiteConnectionType connectionType) {
            this.connectionType = connectionType;
            return (T)this.self();
        }

        public T withEmitValueAsKey(boolean emitValueAsKey) {
            this.emitValueAsKey = emitValueAsKey;
            return (T)this.self();
        }

        public GraphiteEventReporter build() throws IOException {
            return new GraphiteEventReporter(this);
        }
    }

    public static class Factory {
        public static BuilderImpl forContext(MetricContext context) {
            return new BuilderImpl(context);
        }
    }

    public static class BuilderImpl
    extends Builder<BuilderImpl> {
        private BuilderImpl(MetricContext context) {
            super(context);
        }

        protected BuilderImpl self() {
            return this;
        }
    }
}

