/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.instrumented.writer;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.instrumented.writer.InstrumentedDataWriterBase;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.records.ControlMessageHandler;
import org.apache.gobblin.source.extractor.CheckpointableWatermark;
import org.apache.gobblin.stream.RecordEnvelope;
import org.apache.gobblin.util.Decorator;
import org.apache.gobblin.util.DecoratorUtils;
import org.apache.gobblin.util.FinalState;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.WatermarkAwareWriter;

public class InstrumentedDataWriterDecorator<D>
extends InstrumentedDataWriterBase<D>
implements Decorator,
WatermarkAwareWriter<D> {
    private DataWriter<D> embeddedWriter;
    private boolean isEmbeddedInstrumented;
    private Optional<WatermarkAwareWriter> watermarkAwareWriter;

    public InstrumentedDataWriterDecorator(DataWriter<D> writer, State state) {
        super(state, Optional.of(DecoratorUtils.resolveUnderlyingObject(writer).getClass()));
        this.embeddedWriter = (DataWriter)this.closer.register(writer);
        this.isEmbeddedInstrumented = Instrumented.isLineageInstrumented(writer);
        Object underlying = DecoratorUtils.resolveUnderlyingObject(this.embeddedWriter);
        this.watermarkAwareWriter = underlying instanceof WatermarkAwareWriter ? Optional.of((Object)((WatermarkAwareWriter)underlying)) : Optional.absent();
    }

    @Override
    public MetricContext getMetricContext() {
        return this.isEmbeddedInstrumented ? ((InstrumentedDataWriterBase)this.embeddedWriter).getMetricContext() : super.getMetricContext();
    }

    @Override
    public final void write(D record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeEnvelope(RecordEnvelope<D> record) throws IOException {
        if (this.isEmbeddedInstrumented) {
            this.embeddedWriter.writeEnvelope(record);
        } else {
            if (!this.isInstrumentationEnabled()) {
                this.embeddedWriter.writeEnvelope(record);
                return;
            }
            try {
                long startTimeNanos = System.nanoTime();
                this.beforeWrite(record.getRecord());
                this.embeddedWriter.writeEnvelope(record);
                this.onSuccessfulWrite(startTimeNanos);
            }
            catch (IOException exception) {
                this.onException(exception);
                throw exception;
            }
        }
    }

    @Override
    public void writeImpl(D record) throws IOException {
        this.embeddedWriter.write(record);
    }

    @Override
    public void commit() throws IOException {
        this.embeddedWriter.commit();
        super.commit();
    }

    public void cleanup() throws IOException {
        this.embeddedWriter.cleanup();
    }

    public long recordsWritten() {
        return this.embeddedWriter.recordsWritten();
    }

    public long bytesWritten() throws IOException {
        return this.embeddedWriter.bytesWritten();
    }

    @Override
    public State getFinalState() {
        if (this.embeddedWriter instanceof FinalState) {
            return ((FinalState)this.embeddedWriter).getFinalState();
        }
        return super.getFinalState();
    }

    public Object getDecoratedObject() {
        return this.embeddedWriter;
    }

    @Override
    public boolean isWatermarkCapable() {
        return this.watermarkAwareWriter.isPresent() && ((WatermarkAwareWriter)this.watermarkAwareWriter.get()).isWatermarkCapable();
    }

    @Override
    public Map<String, CheckpointableWatermark> getCommittableWatermark() {
        Preconditions.checkState((boolean)this.isWatermarkCapable());
        return ((WatermarkAwareWriter)this.watermarkAwareWriter.get()).getCommittableWatermark();
    }

    @Override
    public Map<String, CheckpointableWatermark> getUnacknowledgedWatermark() {
        Preconditions.checkState((boolean)this.isWatermarkCapable());
        return ((WatermarkAwareWriter)this.watermarkAwareWriter.get()).getUnacknowledgedWatermark();
    }

    public ControlMessageHandler getMessageHandler() {
        return this.embeddedWriter.getMessageHandler();
    }

    public void flush() throws IOException {
        this.embeddedWriter.flush();
    }
}

