/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.common;

import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.jersey.api.uri.UriBuilder;
import com.linkedin.jersey.api.uri.UriComponent;
import com.linkedin.jersey.api.uri.UriTemplate;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.RestConstants;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import com.linkedin.restli.internal.common.AsciiHexEncoding;
import com.linkedin.restli.internal.common.PathSegment;
import com.linkedin.restli.internal.common.QueryParamsDataMap;
import com.linkedin.restli.internal.common.URIConstants;
import com.linkedin.restli.internal.common.URIElementParser;
import com.linkedin.restli.internal.common.URIMaskUtil;
import com.linkedin.restli.internal.common.URLEscaper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class URIParamUtils {
    private static final String[] _EMPTY_STRING_ARRAY = new String[0];
    private static final AsciiHexEncoding CODEC = new AsciiHexEncoding('%', URIConstants.RESERVED_CHARS);

    private static Map<String, String> dataMapToQueryParams(DataMap dataMap) {
        Map<String, String> result = URIParamUtils.encodeDataMapParameters(dataMap);
        for (String parameterName : RestConstants.PROJECTION_PARAMETERS) {
            if (!dataMap.containsKey((Object)parameterName)) continue;
            result.put(parameterName, URIMaskUtil.encodeMaskForURI(dataMap.getDataMap(parameterName)));
        }
        return result;
    }

    private static Map<String, String> encodeDataMapParameters(DataMap dataMap) {
        HashMap<String, String> flattenedMap = new HashMap<String, String>();
        for (Map.Entry entry : dataMap.entrySet()) {
            String flattenedValue = URIParamUtils.encodeElement(entry.getValue(), URLEscaper.Escaping.URL_ESCAPING, UriComponent.Type.QUERY_PARAM);
            String encodedKey = URIParamUtils.encodeString((String)entry.getKey(), URLEscaper.Escaping.URL_ESCAPING, UriComponent.Type.QUERY_PARAM);
            flattenedMap.put(encodedKey, flattenedValue);
        }
        return flattenedMap;
    }

    static String encodeElement(Object obj, URLEscaper.Escaping escaping, UriComponent.Type componentType) {
        StringBuilder builder = new StringBuilder();
        URIParamUtils.encodeDataObject(obj, escaping, componentType, builder);
        return builder.toString();
    }

    public static String encodeKeyForUri(Object key, UriComponent.Type componentType, ProtocolVersion version) {
        return URIParamUtils.keyToString(key, URLEscaper.Escaping.URL_ESCAPING, componentType, true, version);
    }

    public static Map<String, String> encodePathKeysForUri(Map<String, Object> pathKeys, ProtocolVersion version) {
        HashMap<String, String> escapedKeys = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : pathKeys.entrySet()) {
            String value = URIParamUtils.encodeKeyForUri(entry.getValue(), UriComponent.Type.PATH_SEGMENT, version);
            if (value == null) {
                throw new IllegalArgumentException("Missing value for path key " + entry.getKey());
            }
            escapedKeys.put(entry.getKey(), value);
        }
        return escapedKeys;
    }

    public static String encodeKeyForHeader(Object key, ProtocolVersion version) {
        return URIParamUtils.encodeKeyForBody(key, false, version);
    }

    public static String encodeKeyForBody(Object key, boolean full, ProtocolVersion version) {
        if (key instanceof ComplexResourceKey && !full && version.compareTo(AllProtocolVersions.RESTLI_PROTOCOL_1_0_0.getProtocolVersion()) <= 0) {
            return URIParamUtils.keyToString(key, URLEscaper.Escaping.URL_ESCAPING, null, full, version);
        }
        return URIParamUtils.keyToString(key, URLEscaper.Escaping.NO_ESCAPING, null, full, version);
    }

    public static String keyToString(Object key, URLEscaper.Escaping escaping, UriComponent.Type componentType, boolean full, ProtocolVersion version) {
        if (version.compareTo(AllProtocolVersions.RESTLI_PROTOCOL_2_0_0.getProtocolVersion()) >= 0) {
            return URIParamUtils.keyToStringV2(key, escaping, componentType, full);
        }
        return URIParamUtils.keyToStringV1(key, escaping, full);
    }

    private static String keyToStringV1(Object key, URLEscaper.Escaping escaping, boolean full) {
        String result;
        if (key == null) {
            result = null;
        } else if (key instanceof ComplexResourceKey) {
            ComplexResourceKey complexKey = (ComplexResourceKey)key;
            result = full ? QueryParamsDataMap.dataMapToQueryString(complexKey.toDataMap(), escaping) : QueryParamsDataMap.dataMapToQueryString(complexKey.getKey().data(), escaping);
        } else {
            result = key instanceof CompoundKey ? URIParamUtils.compoundKeyToStringV1((CompoundKey)key) : URLEscaper.escape(DataTemplateUtil.stringify((Object)key), escaping);
        }
        return result;
    }

    private static String compoundKeyToStringV1(CompoundKey key) {
        ArrayList<String> keyList = new ArrayList<String>(key.getPartKeys());
        Collections.sort(keyList);
        StringBuilder b = new StringBuilder();
        boolean delimit = false;
        for (String keyPart : keyList) {
            if (delimit) {
                b.append('&');
            }
            try {
                b.append(URLEncoder.encode(keyPart, "UTF-8"));
                b.append('=');
                b.append(URLEncoder.encode(DataTemplateUtil.stringify((Object)key.getPart(keyPart)), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UnsupportedEncodingException while trying to encode the key", e);
            }
            delimit = true;
        }
        return b.toString();
    }

    private static String keyToStringV2(Object key, URLEscaper.Escaping escaping, UriComponent.Type componentType, boolean full) {
        if (key == null) {
            return null;
        }
        if (key instanceof ComplexResourceKey) {
            ComplexResourceKey complexResourceKey = (ComplexResourceKey)key;
            DataMap convertedKey = full ? complexResourceKey.toDataMap() : complexResourceKey.getKey().data();
            return URIParamUtils.encodeElement(convertedKey, escaping, componentType);
        }
        if (key instanceof CompoundKey) {
            return URIParamUtils.encodeElement(URIParamUtils.compoundKeyToDataMap((CompoundKey)key), escaping, componentType);
        }
        return URIParamUtils.simpleKeyToStringV2(key, escaping, componentType);
    }

    private static String simpleKeyToStringV2(Object key, URLEscaper.Escaping escaping, UriComponent.Type componentType) {
        if (escaping == URLEscaper.Escaping.URL_ESCAPING) {
            return URIParamUtils.encodeElement(key, escaping, componentType);
        }
        return DataTemplateUtil.stringify((Object)key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void encodeDataObject(Object obj, URLEscaper.Escaping escaping, UriComponent.Type componentType, StringBuilder stringBuilder) {
        if (obj instanceof DataComplex) {
            if (obj instanceof DataMap) {
                DataMap dataMap = (DataMap)obj;
                stringBuilder.append('(');
                if (!dataMap.isEmpty()) {
                    ArrayList keys = new ArrayList(dataMap.keySet());
                    Collections.sort(keys);
                    ListIterator iterator = keys.listIterator();
                    String currentKey = (String)iterator.next();
                    URIParamUtils.mapEncodingHelper(currentKey, dataMap.get((Object)currentKey), escaping, componentType, stringBuilder);
                    while (iterator.hasNext()) {
                        stringBuilder.append(',');
                        currentKey = (String)iterator.next();
                        URIParamUtils.mapEncodingHelper(currentKey, dataMap.get((Object)currentKey), escaping, componentType, stringBuilder);
                    }
                }
                stringBuilder.append(')');
                return;
            } else {
                if (!(obj instanceof DataList)) throw new IllegalArgumentException(obj.getClass() + " is an unknown subtype of dataComplex.");
                DataList dataList = (DataList)obj;
                stringBuilder.append("List");
                stringBuilder.append('(');
                if (!dataList.isEmpty()) {
                    ListIterator iterator = dataList.listIterator();
                    URIParamUtils.encodeDataObject(iterator.next(), escaping, componentType, stringBuilder);
                    while (iterator.hasNext()) {
                        stringBuilder.append(',');
                        URIParamUtils.encodeDataObject(iterator.next(), escaping, componentType, stringBuilder);
                    }
                }
                stringBuilder.append(')');
            }
            return;
        } else {
            stringBuilder.append(URIParamUtils.encodeString(DataTemplateUtil.stringify((Object)obj), escaping, componentType));
        }
    }

    private static void mapEncodingHelper(String key, Object value, URLEscaper.Escaping escaping, UriComponent.Type componentType, StringBuilder stringBuilder) {
        stringBuilder.append(URIParamUtils.encodeString(key, escaping, componentType));
        stringBuilder.append(':');
        URIParamUtils.encodeDataObject(value, escaping, componentType, stringBuilder);
    }

    private static String encodeString(String toEscape, URLEscaper.Escaping escaping, UriComponent.Type componentType) {
        if (toEscape.isEmpty()) {
            return "''";
        }
        if (escaping.equals((Object)URLEscaper.Escaping.URL_ESCAPING)) {
            String internalEncoding = CODEC.encode(toEscape);
            return UriComponent.contextualEncode((String)internalEncoding, (UriComponent.Type)componentType);
        }
        return CODEC.encode(toEscape);
    }

    public static DataMap parseUriParams(Map<String, List<String>> queryParameters) throws PathSegment.PathSegmentSyntaxException {
        DataMap dataMap = new DataMap();
        for (Map.Entry<String, List<String>> entry : queryParameters.entrySet()) {
            Object value;
            String key = entry.getKey();
            List<String> values = entry.getValue();
            if (values.size() > 1) {
                throw new PathSegment.PathSegmentSyntaxException("unexpected repeated query param in URI: " + key);
            }
            String encodedValue = values.get(0);
            if (RestConstants.PROJECTION_PARAMETERS.contains(key)) {
                value = encodedValue;
            } else {
                try {
                    value = URIElementParser.parse(encodedValue);
                }
                catch (PathSegment.PathSegmentSyntaxException e) {
                    throw new PathSegment.PathSegmentSyntaxException("error while parsing query param '" + key + "'\n" + e.getMessage());
                }
            }
            dataMap.put((Object)key, value);
        }
        return dataMap;
    }

    public static void addSortedParams(UriBuilder uriBuilder, DataMap params) {
        Map<String, String> map = URIParamUtils.dataMapToQueryParams(params);
        URIParamUtils.addSortedParams(uriBuilder, map);
    }

    private static void addSortedParams(UriBuilder uriBuilder, Map<String, String> params) {
        ArrayList<String> keysList = new ArrayList<String>(params.keySet());
        Collections.sort(keysList);
        for (String key : keysList) {
            uriBuilder.queryParam(key, new Object[]{params.get(key)});
        }
    }

    public static DataMap compoundKeyToDataMap(CompoundKey compoundKey) {
        DataMap dataMap = new DataMap(compoundKey.getNumParts());
        for (String key : compoundKey.getPartKeys()) {
            Object value = compoundKey.getPart(key);
            Class<?> valueClass = value.getClass();
            if (DataTemplateUtil.hasCoercer(valueClass) || valueClass.isEnum()) {
                Object coercedValue = DataTemplateUtil.coerceInput((Object)value, valueClass, Object.class);
                dataMap.put((Object)key, coercedValue);
                continue;
            }
            dataMap.put((Object)key, value);
        }
        return dataMap;
    }

    public static String[] extractPathComponentsFromUriTemplate(String uriTemplate) {
        String normalizedUriTemplate = uriTemplate.replaceAll("(^/|/$)", "");
        UriTemplate template = new UriTemplate(normalizedUriTemplate);
        String uri = template.createURI(_EMPTY_STRING_ARRAY);
        return uri.replaceAll("/+", "/").split("/");
    }
}

