/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.restspec;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.JacksonDataTemplateCodec;
import com.linkedin.restli.common.RestConstants;
import com.linkedin.restli.restspec.ParameterSchemaArray;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.restspec.RestMethodSchema;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class RestSpecCodec {
    private static final String ACTIONS_SET_LEGACY_KEY = "actions-set";
    private static final String ACTIONS_SET_KEY = "actionsSet";
    private static final String TYPE_KEY = "type";
    private static final String PARAMETERS_KEY = "parameters";
    private static final String METADATA_KEY = "metadata";
    private static final String RETURNS_KEY = "returns";
    private static final String COLLECTION_KEY = "collection";
    private static final String ASSOCIATION_KEY = "association";
    private static final String SIMPLE_KEY = "simple";
    private static final String METHODS_KEY = "methods";
    private static final String SUPPORTS_KEY = "supports";
    private final JacksonDataCodec _dataCodec = new JacksonDataCodec();
    private final JacksonDataTemplateCodec _templateCodec = new JacksonDataTemplateCodec();

    public RestSpecCodec() {
        this._templateCodec.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
    }

    public ResourceSchema readResourceSchema(InputStream inputStream) throws IOException {
        DataMap data = this._dataCodec.readMap(inputStream);
        this.fixupLegacyRestspec(data);
        return new ResourceSchema(data);
    }

    public void writeResourceSchema(ResourceSchema schema, OutputStream outputStream) throws IOException {
        this._templateCodec.writeDataTemplate((DataTemplate)schema, outputStream, true);
    }

    public static DataSchema textToSchema(String typeText, DataSchemaResolver schemaResolver) {
        if (!(typeText = typeText.trim()).startsWith("{") && !typeText.startsWith("\"")) {
            typeText = "\"" + typeText + "\"";
        }
        return DataTemplateUtil.parseSchema((String)typeText, (DataSchemaResolver)schemaResolver);
    }

    private void fixupLegacyRestspec(DataMap data) throws IOException {
        DataMap methodsContainer;
        if (data.containsKey((Object)ACTIONS_SET_LEGACY_KEY)) {
            Object actionsSet = data.remove((Object)ACTIONS_SET_LEGACY_KEY);
            data.put((Object)ACTIONS_SET_KEY, actionsSet);
        }
        this.serializeTypeFields(data, PathSpec.emptyPath());
        if (data.containsKey((Object)COLLECTION_KEY)) {
            methodsContainer = data.getDataMap(COLLECTION_KEY);
        } else if (data.containsKey((Object)ASSOCIATION_KEY)) {
            methodsContainer = data.getDataMap(ASSOCIATION_KEY);
        } else if (data.containsKey((Object)SIMPLE_KEY)) {
            methodsContainer = data.getDataMap(SIMPLE_KEY);
        } else {
            return;
        }
        if (methodsContainer.containsKey((Object)METHODS_KEY)) {
            return;
        }
        DataList methods = new DataList();
        for (Object methodName : methodsContainer.getDataList(SUPPORTS_KEY)) {
            RestMethodSchema newMethod = new RestMethodSchema();
            newMethod.setMethod((String)methodName);
            newMethod.setParameters(new ParameterSchemaArray());
            methods.add((Object)newMethod.data());
        }
        methodsContainer.put((Object)METHODS_KEY, (Object)methods);
    }

    private boolean isPegasusTypeField(PathSpec path) {
        return path.toString().endsWith("parameters/type") || path.toString().endsWith("metadata/type") || path.toString().endsWith("/returns");
    }

    private void serializeTypeFields(DataMap data, PathSpec path) throws IOException {
        for (Map.Entry entry : data.entrySet()) {
            PathSpec currentElement = new PathSpec(path.getPathComponents(), (String)entry.getKey());
            if (this.isPegasusTypeField(currentElement) && entry.getValue() instanceof DataMap) {
                String value = new String(this._dataCodec.mapToBytes((DataMap)entry.getValue()), RestConstants.DEFAULT_CHARSET);
                data.put(entry.getKey(), (Object)value);
                continue;
            }
            if (entry.getValue() instanceof DataMap) {
                this.serializeTypeFields((DataMap)entry.getValue(), currentElement);
                continue;
            }
            if (!(entry.getValue() instanceof DataList)) continue;
            for (Object o : (DataList)entry.getValue()) {
                if (!(o instanceof DataMap)) continue;
                this.serializeTypeFields((DataMap)o, currentElement);
            }
        }
    }
}

