/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.r2;

import com.google.common.collect.Maps;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.http.ResponseHandler;
import org.apache.gobblin.http.StatusType;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.event.FailureEventBuilder;
import org.apache.gobblin.net.Request;
import org.apache.gobblin.r2.R2ResponseStatus;
import org.apache.gobblin.utils.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R2RestResponseHandler
implements ResponseHandler<RestRequest, RestResponse> {
    private static final Logger log = LoggerFactory.getLogger(R2RestResponseHandler.class);
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    private final String R2_RESPONSE_EVENT_NAMESPACE = "r2.response";
    private final String R2_FAILED_REQUEST_EVENT = "r2FailedRequest";
    private final Set<String> errorCodeWhitelist;
    private MetricContext metricsContext;

    public R2RestResponseHandler() {
        this(new HashSet<String>(), Instrumented.getMetricContext((State)new State(), R2RestResponseHandler.class));
    }

    public R2RestResponseHandler(Set<String> errorCodeWhitelist, MetricContext metricContext) {
        this.errorCodeWhitelist = errorCodeWhitelist;
        this.metricsContext = metricContext;
    }

    public R2ResponseStatus handleResponse(Request<RestRequest> request, RestResponse response) {
        R2ResponseStatus status = new R2ResponseStatus(StatusType.OK);
        int statusCode = response.getStatus();
        status.setStatusCode(statusCode);
        HttpUtils.updateStatusType(status, statusCode, this.errorCodeWhitelist);
        if (status.getType() == StatusType.OK) {
            status.setContent(response.getEntity());
            status.setContentType(response.getHeader(CONTENT_TYPE_HEADER));
        } else {
            log.info("Receive an unsuccessful response with status code: " + statusCode);
            HashMap metadata = Maps.newHashMap();
            metadata.put("statusCode", String.valueOf(statusCode));
            metadata.put("request", request.toString());
            if (status.getType() != StatusType.CONTINUE) {
                FailureEventBuilder failureEvent = new FailureEventBuilder("r2FailedRequest");
                failureEvent.addAdditionalMetadata((Map)metadata);
                failureEvent.submit(this.metricsContext);
            } else {
                GobblinTrackingEvent event = new GobblinTrackingEvent(Long.valueOf(0L), "r2.response", "r2FailedRequest", (Map)metadata);
                this.metricsContext.submitEvent(event);
            }
        }
        return status;
    }
}

