/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.verify;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import org.apache.gobblin.compaction.dataset.DatasetHelper;
import org.apache.gobblin.compaction.mapreduce.MRCompactor;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.gobblin.util.RecordCountProvider;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputRecordCountHelper {
    private static final Logger log = LoggerFactory.getLogger(InputRecordCountHelper.class);
    private final FileSystem fs;
    private final State state;
    private final RecordCountProvider inputRecordCountProvider;
    private final String AVRO = "avro";
    @Deprecated
    public static final String RECORD_COUNT_FILE = "_record_count";
    public static final String STATE_FILE = "_state_file";

    public InputRecordCountHelper(State state) {
        try {
            this.fs = this.getSourceFileSystem(state);
            this.state = state;
            this.inputRecordCountProvider = (RecordCountProvider)Class.forName(state.getProp("compaction.input.record.count.provider", MRCompactor.DEFAULT_COMPACTION_INPUT_RECORD_COUNT_PROVIDER)).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate " + InputRecordCountHelper.class.getName(), e);
        }
    }

    public long calculateRecordCount(Collection<Path> paths) throws IOException {
        long sum = 0L;
        for (Path path : paths) {
            sum += this.inputRecordCountProvider.getRecordCount(DatasetHelper.getApplicableFilePaths(this.fs, path, Lists.newArrayList((Object[])new String[]{"avro"})));
        }
        return sum;
    }

    public State loadState(Path dir) throws IOException {
        return InputRecordCountHelper.loadState(this.fs, dir);
    }

    private static State loadState(FileSystem fs, Path dir) throws IOException {
        State state = new State();
        if (fs.exists(new Path(dir, STATE_FILE))) {
            try (FSDataInputStream inputStream = fs.open(new Path(dir, STATE_FILE));){
                state.readFields((DataInput)inputStream);
            }
        }
        return state;
    }

    public void saveState(Path dir, State state) throws IOException {
        InputRecordCountHelper.saveState(this.fs, dir, state);
    }

    private static void saveState(FileSystem fs, Path dir, State state) throws IOException {
        Path tmpFile = new Path(dir, "_state_file.tmp");
        Path newFile = new Path(dir, STATE_FILE);
        fs.delete(tmpFile, false);
        try (DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)fs.create(new Path(dir, "_state_file.tmp")));){
            state.write((DataOutput)dataOutputStream);
        }
        fs.delete(newFile, false);
        fs.rename(tmpFile, newFile);
    }

    public long readRecordCount(Path dir) throws IOException {
        return InputRecordCountHelper.readRecordCount(this.fs, dir);
    }

    @Deprecated
    public static long readRecordCount(FileSystem fs, Path dir) throws IOException {
        State state = InputRecordCountHelper.loadState(fs, dir);
        if (!state.contains("recordCountTotal")) {
            if (fs.exists(new Path(dir, RECORD_COUNT_FILE))) {
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(dir, RECORD_COUNT_FILE)), Charsets.UTF_8));){
                    long count;
                    long l = count = Long.parseLong(br.readLine());
                    return l;
                }
            }
            return 0L;
        }
        return Long.parseLong(state.getProp("recordCountTotal"));
    }

    public long readExecutionCount(Path dir) throws IOException {
        State state = InputRecordCountHelper.loadState(this.fs, dir);
        return Long.parseLong(state.getProp("executionCountTotal", "0"));
    }

    @Deprecated
    public static void writeRecordCount(FileSystem fs, Path dir, long count) throws IOException {
        State state = InputRecordCountHelper.loadState(fs, dir);
        state.setProp("recordCountTotal", (Object)count);
        InputRecordCountHelper.saveState(fs, dir, state);
    }

    protected FileSystem getSourceFileSystem(State state) throws IOException {
        Configuration conf = HadoopUtils.getConfFromState((State)state);
        String uri = state.getProp("source.filebased.fs.uri", "file:///");
        return HadoopUtils.getOptionallyThrottledFileSystem((FileSystem)FileSystem.get((URI)URI.create(uri), (Configuration)conf), (State)state);
    }

    public FileSystem getFs() {
        return this.fs;
    }
}

