/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metastore.database;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.gobblin.metastore.DatabaseJobHistoryStore;
import org.apache.gobblin.metastore.database.Filter;
import org.apache.gobblin.metastore.database.SupportedDatabaseVersion;
import org.apache.gobblin.metastore.database.VersionedDatabaseJobHistoryStore;
import org.apache.gobblin.rest.JobExecutionInfo;
import org.apache.gobblin.rest.JobExecutionQuery;
import org.apache.gobblin.rest.JobStateEnum;
import org.apache.gobblin.rest.LauncherTypeEnum;
import org.apache.gobblin.rest.Metric;
import org.apache.gobblin.rest.MetricTypeEnum;
import org.apache.gobblin.rest.Table;
import org.apache.gobblin.rest.TableTypeEnum;
import org.apache.gobblin.rest.TaskExecutionInfo;
import org.apache.gobblin.rest.TaskStateEnum;
import org.apache.gobblin.rest.TimeRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedDatabaseVersion(isDefault=true, version="1.0.0")
public class DatabaseJobHistoryStoreV100
implements VersionedDatabaseJobHistoryStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseJobHistoryStore.class);
    private static final String JOB_EXECUTION_INSERT_STATEMENT_TEMPLATE = "INSERT INTO gobblin_job_executions (job_name,job_id,start_time,end_time,duration,state,launched_tasks,completed_tasks,launcher_type,tracking_url) VALUES(?,?,?,?,?,?,?,?,?,?)";
    private static final String TASK_EXECUTION_INSERT_STATEMENT_TEMPLATE = "INSERT INTO gobblin_task_executions (task_id,job_id,start_time,end_time,duration,state,failure_exception,low_watermark,high_watermark,table_namespace,table_name,table_type) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String JOB_METRIC_INSERT_STATEMENT_TEMPLATE = "INSERT INTO gobblin_job_metrics (job_id,metric_group,metric_name,metric_type,metric_value) VALUES(?,?,?,?,?)";
    private static final String TASK_METRIC_INSERT_STATEMENT_TEMPLATE = "INSERT INTO gobblin_task_metrics (task_id,metric_group,metric_name,metric_type,metric_value) VALUES(?,?,?,?,?)";
    private static final String JOB_PROPERTY_INSERT_STATEMENT_TEMPLATE = "INSERT INTO gobblin_job_properties (job_id,property_key,property_value) VALUES(?,?,?)";
    private static final String TASK_PROPERTY_INSERT_STATEMENT_TEMPLATE = "INSERT INTO gobblin_task_properties (task_id,property_key,property_value) VALUES(?,?,?)";
    private static final String JOB_EXECUTION_UPDATE_STATEMENT_TEMPLATE = "UPDATE gobblin_job_executions SET start_time=?,end_time=?,duration=?,state=?,launched_tasks=?,completed_tasks=?,launcher_type=?,tracking_url=? WHERE job_id=?";
    private static final String TASK_EXECUTION_UPDATE_STATEMENT_TEMPLATE = "UPDATE gobblin_task_executions SET start_time=?,end_time=?,duration=?,state=?,failure_exception=?,low_watermark=?,high_watermark=?,table_namespace=?,table_name=?,table_type=? WHERE task_id=?";
    private static final String JOB_METRIC_UPDATE_STATEMENT_TEMPLATE = "UPDATE gobblin_job_metrics SET metric_value=? WHERE job_id=? AND metric_group=? AND metric_name=? AND metric_type=?";
    private static final String TASK_METRIC_UPDATE_STATEMENT_TEMPLATE = "UPDATE gobblin_task_metrics SET metric_value=? WHERE task_id=? AND metric_group=? AND metric_name=? AND metric_type=?";
    private static final String JOB_PROPERTY_UPDATE_STATEMENT_TEMPLATE = "UPDATE gobblin_job_properties SET property_value=? WHERE job_id=? AND property_key=?";
    private static final String TASK_PROPERTY_UPDATE_STATEMENT_TEMPLATE = "UPDATE gobblin_task_properties SET property_value=? WHERE task_id=? AND property_key=?";
    private static final String LIST_DISTINCT_JOB_EXECUTION_QUERY_TEMPLATE = "SELECT j.job_id FROM gobblin_job_executions j, (SELECT MAX(last_modified_ts) AS most_recent_ts, job_name FROM gobblin_job_executions GROUP BY job_name) max_results WHERE j.job_name = max_results.job_name AND j.last_modified_ts = max_results.most_recent_ts";
    private static final String LIST_RECENT_JOB_EXECUTION_QUERY_TEMPLATE = "SELECT job_id FROM gobblin_job_executions";
    private static final String JOB_NAME_QUERY_BY_TABLE_STATEMENT_TEMPLATE = "SELECT j.job_name FROM gobblin_job_executions j, gobblin_task_executions t WHERE j.job_id=t.job_id AND %s GROUP BY j.job_name";
    private static final String JOB_ID_QUERY_BY_JOB_NAME_STATEMENT_TEMPLATE = "SELECT job_id FROM gobblin_job_executions WHERE job_name=?";
    private static final String JOB_EXECUTION_QUERY_BY_JOB_ID_STATEMENT_TEMPLATE = "SELECT * FROM gobblin_job_executions WHERE job_id=?";
    private static final String TASK_EXECUTION_EXIST_QUERY_STATEMENT_TEMPLATE = "SELECT * FROM gobblin_task_executions WHERE task_id=?";
    private static final String TASK_EXECUTION_QUERY_STATEMENT_TEMPLATE = "SELECT * FROM gobblin_task_executions WHERE job_id=?";
    private static final String JOB_METRIC_EXIST_QUERY_STATEMENT_TEMPLATE = "SELECT * FROM gobblin_job_metrics WHERE job_id=? AND metric_group=? AND metric_name=? AND metric_type=?";
    private static final String TASK_METRIC_EXIST_QUERY_STATEMENT_TEMPLATE = "SELECT * FROM gobblin_task_metrics WHERE task_id=? AND metric_group=? AND metric_name=? AND metric_type=?";
    private static final String JOB_METRIC_QUERY_STATEMENT_TEMPLATE = "SELECT metric_group,metric_name,metric_type,metric_value FROM gobblin_job_metrics WHERE job_id=?";
    private static final String TASK_METRIC_QUERY_STATEMENT_TEMPLATE = "SELECT metric_group,metric_name,metric_type,metric_value FROM gobblin_task_metrics WHERE task_id=?";
    private static final String JOB_PROPERTY_EXIST_QUERY_STATEMENT_TEMPLATE = "SELECT * FROM gobblin_job_properties WHERE job_id=? AND property_key=?";
    private static final String TASK_PROPERTY_EXIST_QUERY_STATEMENT_TEMPLATE = "SELECT * FROM gobblin_task_properties WHERE task_id=? AND property_key=?";
    private static final String JOB_PROPERTY_QUERY_STATEMENT_TEMPLATE = "SELECT property_key, property_value FROM gobblin_job_properties WHERE job_id=?";
    private static final String TASK_PROPERTY_QUERY_STATEMENT_TEMPLATE = "SELECT property_key, property_value FROM gobblin_task_properties WHERE task_id=?";
    private static final Timestamp DEFAULT_TIMESTAMP = new Timestamp(1000L);
    private DataSource dataSource;

    @Override
    public void init(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public synchronized void put(JobExecutionInfo jobExecutionInfo) throws IOException {
        Optional connectionOptional = Optional.absent();
        try {
            boolean insert;
            connectionOptional = Optional.of((Object)this.getConnection());
            Connection connection = (Connection)connectionOptional.get();
            connection.setAutoCommit(false);
            if (DatabaseJobHistoryStoreV100.existsJobExecutionInfo(connection, jobExecutionInfo)) {
                DatabaseJobHistoryStoreV100.updateJobExecutionInfo(connection, jobExecutionInfo);
            } else {
                DatabaseJobHistoryStoreV100.insertJobExecutionInfo(connection, jobExecutionInfo);
            }
            if (jobExecutionInfo.hasMetrics()) {
                for (Metric metric : jobExecutionInfo.getMetrics()) {
                    insert = !DatabaseJobHistoryStoreV100.existsMetric(connection, JOB_METRIC_EXIST_QUERY_STATEMENT_TEMPLATE, jobExecutionInfo.getJobId(), metric);
                    DatabaseJobHistoryStoreV100.updateMetric(connection, insert ? JOB_METRIC_INSERT_STATEMENT_TEMPLATE : JOB_METRIC_UPDATE_STATEMENT_TEMPLATE, jobExecutionInfo.getJobId(), metric, insert);
                }
            }
            if (jobExecutionInfo.hasJobProperties()) {
                for (Map.Entry entry : jobExecutionInfo.getJobProperties().entrySet()) {
                    insert = !DatabaseJobHistoryStoreV100.existsProperty(connection, JOB_PROPERTY_EXIST_QUERY_STATEMENT_TEMPLATE, jobExecutionInfo.getJobId(), (String)entry.getKey());
                    DatabaseJobHistoryStoreV100.updateProperty(connection, insert ? JOB_PROPERTY_INSERT_STATEMENT_TEMPLATE : JOB_PROPERTY_UPDATE_STATEMENT_TEMPLATE, jobExecutionInfo.getJobId(), (String)entry.getKey(), (String)entry.getValue(), insert);
                }
            }
            if (jobExecutionInfo.hasTaskExecutions()) {
                for (TaskExecutionInfo info : jobExecutionInfo.getTaskExecutions()) {
                    boolean insert2;
                    if (DatabaseJobHistoryStoreV100.existsTaskExecutionInfo(connection, info)) {
                        DatabaseJobHistoryStoreV100.updateTaskExecutionInfo(connection, info);
                    } else {
                        DatabaseJobHistoryStoreV100.insertTaskExecutionInfo(connection, info);
                    }
                    if (info.hasMetrics()) {
                        for (Metric metric : info.getMetrics()) {
                            insert2 = !DatabaseJobHistoryStoreV100.existsMetric(connection, TASK_METRIC_EXIST_QUERY_STATEMENT_TEMPLATE, info.getTaskId(), metric);
                            DatabaseJobHistoryStoreV100.updateMetric(connection, insert2 ? TASK_METRIC_INSERT_STATEMENT_TEMPLATE : TASK_METRIC_UPDATE_STATEMENT_TEMPLATE, info.getTaskId(), metric, insert2);
                        }
                    }
                    if (!info.hasTaskProperties()) continue;
                    for (Map.Entry entry : info.getTaskProperties().entrySet()) {
                        insert2 = !DatabaseJobHistoryStoreV100.existsProperty(connection, TASK_PROPERTY_EXIST_QUERY_STATEMENT_TEMPLATE, info.getTaskId(), (String)entry.getKey());
                        DatabaseJobHistoryStoreV100.updateProperty(connection, insert2 ? TASK_PROPERTY_INSERT_STATEMENT_TEMPLATE : TASK_PROPERTY_UPDATE_STATEMENT_TEMPLATE, info.getTaskId(), (String)entry.getKey(), (String)entry.getValue(), insert2);
                    }
                }
            }
            connection.commit();
        }
        catch (SQLException se) {
            LOGGER.error("Failed to put a new job execution information record", (Throwable)se);
            if (connectionOptional.isPresent()) {
                try {
                    ((Connection)connectionOptional.get()).rollback();
                }
                catch (SQLException se1) {
                    LOGGER.error("Failed to rollback", (Throwable)se1);
                }
            }
            throw new IOException(se);
        }
        finally {
            if (connectionOptional.isPresent()) {
                try {
                    ((Connection)connectionOptional.get()).close();
                }
                catch (SQLException se) {
                    LOGGER.error("Failed to close connection", (Throwable)se);
                }
            }
        }
    }

    @Override
    public synchronized List<JobExecutionInfo> get(JobExecutionQuery query) throws IOException {
        Preconditions.checkArgument((query.hasId() && query.hasIdType() ? 1 : 0) != 0);
        Optional connectionOptional = Optional.absent();
        try {
            connectionOptional = Optional.of((Object)this.getConnection());
            Connection connection = (Connection)connectionOptional.get();
            switch (query.getIdType()) {
                case JOB_ID: {
                    ArrayList jobExecutionInfos = Lists.newArrayList();
                    JobExecutionInfo jobExecutionInfo = this.processQueryById(connection, query.getId().getString(), query, Filter.MISSING);
                    if (jobExecutionInfo != null) {
                        jobExecutionInfos.add(jobExecutionInfo);
                    }
                    ArrayList arrayList = jobExecutionInfos;
                    return arrayList;
                }
                case JOB_NAME: {
                    List<JobExecutionInfo> list = this.processQueryByJobName(connection, query.getId().getString(), query, Filter.MISSING);
                    return list;
                }
                case TABLE: {
                    List<JobExecutionInfo> list = this.processQueryByTable(connection, query);
                    return list;
                }
                case LIST_TYPE: {
                    List<JobExecutionInfo> list = this.processListQuery(connection, query);
                    return list;
                }
            }
            try {
                throw new IOException("Unsupported query ID type: " + query.getIdType().name());
            }
            catch (SQLException se) {
                LOGGER.error("Failed to execute query: " + query, (Throwable)se);
                throw new IOException(se);
            }
        }
        finally {
            if (connectionOptional.isPresent()) {
                try {
                    ((Connection)connectionOptional.get()).close();
                }
                catch (SQLException se) {
                    LOGGER.error("Failed to close connection", (Throwable)se);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    private Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    /*
     * Exception decompiling
     */
    private static boolean existsJobExecutionInfo(Connection connection, JobExecutionInfo info) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void insertJobExecutionInfo(Connection connection, JobExecutionInfo info) throws SQLException {
        Preconditions.checkArgument((boolean)info.hasJobName());
        Preconditions.checkArgument((boolean)info.hasJobId());
        try (PreparedStatement insertStatement = connection.prepareStatement(JOB_EXECUTION_INSERT_STATEMENT_TEMPLATE);){
            int index = 0;
            insertStatement.setString(++index, info.getJobName());
            insertStatement.setString(++index, info.getJobId());
            insertStatement.setTimestamp(++index, info.hasStartTime() ? new Timestamp(info.getStartTime()) : DEFAULT_TIMESTAMP, DatabaseJobHistoryStoreV100.getCalendarUTCInstance());
            insertStatement.setTimestamp(++index, info.hasEndTime() ? new Timestamp(info.getEndTime()) : DEFAULT_TIMESTAMP, DatabaseJobHistoryStoreV100.getCalendarUTCInstance());
            insertStatement.setLong(++index, info.hasDuration() ? info.getDuration() : -1L);
            insertStatement.setString(++index, info.hasState() ? info.getState().name() : null);
            insertStatement.setInt(++index, info.hasLaunchedTasks() ? info.getLaunchedTasks() : -1);
            insertStatement.setInt(++index, info.hasCompletedTasks() ? info.getCompletedTasks() : -1);
            insertStatement.setString(++index, info.hasLauncherType() ? info.getLauncherType().name() : null);
            insertStatement.setString(++index, info.hasTrackingUrl() ? info.getTrackingUrl() : null);
            insertStatement.executeUpdate();
        }
    }

    private static void updateJobExecutionInfo(Connection connection, JobExecutionInfo info) throws SQLException {
        Preconditions.checkArgument((boolean)info.hasJobId());
        try (PreparedStatement updateStatement = connection.prepareStatement(JOB_EXECUTION_UPDATE_STATEMENT_TEMPLATE);){
            int index = 0;
            updateStatement.setTimestamp(++index, info.hasStartTime() ? new Timestamp(info.getStartTime()) : DEFAULT_TIMESTAMP, DatabaseJobHistoryStoreV100.getCalendarUTCInstance());
            updateStatement.setTimestamp(++index, info.hasEndTime() ? new Timestamp(info.getEndTime()) : DEFAULT_TIMESTAMP, DatabaseJobHistoryStoreV100.getCalendarUTCInstance());
            updateStatement.setLong(++index, info.hasDuration() ? info.getDuration() : -1L);
            updateStatement.setString(++index, info.hasState() ? info.getState().name() : null);
            updateStatement.setInt(++index, info.hasLaunchedTasks() ? info.getLaunchedTasks() : -1);
            updateStatement.setInt(++index, info.hasCompletedTasks() ? info.getCompletedTasks() : -1);
            updateStatement.setString(++index, info.hasLauncherType() ? info.getLauncherType().name() : null);
            updateStatement.setString(++index, info.hasTrackingUrl() ? info.getTrackingUrl() : null);
            updateStatement.setString(++index, info.getJobId());
            updateStatement.executeUpdate();
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean existsTaskExecutionInfo(Connection connection, TaskExecutionInfo info) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void insertTaskExecutionInfo(Connection connection, TaskExecutionInfo info) throws SQLException {
        Preconditions.checkArgument((boolean)info.hasTaskId());
        Preconditions.checkArgument((boolean)info.hasJobId());
        try (PreparedStatement insertStatement = connection.prepareStatement(TASK_EXECUTION_INSERT_STATEMENT_TEMPLATE);){
            int index = 0;
            insertStatement.setString(++index, info.getTaskId());
            insertStatement.setString(++index, info.getJobId());
            insertStatement.setTimestamp(++index, info.hasStartTime() ? new Timestamp(info.getStartTime()) : DEFAULT_TIMESTAMP, DatabaseJobHistoryStoreV100.getCalendarUTCInstance());
            insertStatement.setTimestamp(++index, info.hasEndTime() ? new Timestamp(info.getEndTime()) : DEFAULT_TIMESTAMP, DatabaseJobHistoryStoreV100.getCalendarUTCInstance());
            insertStatement.setLong(++index, info.hasDuration() ? info.getDuration() : -1L);
            insertStatement.setString(++index, info.hasState() ? info.getState().name() : null);
            insertStatement.setString(++index, info.hasFailureException() ? info.getFailureException() : null);
            insertStatement.setLong(++index, info.hasLowWatermark() ? info.getLowWatermark() : -1L);
            insertStatement.setLong(++index, info.hasHighWatermark() ? info.getHighWatermark() : -1L);
            insertStatement.setString(++index, info.hasTable() && info.getTable().hasNamespace() ? info.getTable().getNamespace() : null);
            insertStatement.setString(++index, info.hasTable() && info.getTable().hasName() ? info.getTable().getName() : null);
            insertStatement.setString(++index, info.hasTable() && info.getTable().hasType() ? info.getTable().getType().name() : null);
            insertStatement.executeUpdate();
        }
    }

    private static void updateTaskExecutionInfo(Connection connection, TaskExecutionInfo info) throws SQLException {
        Preconditions.checkArgument((boolean)info.hasTaskId());
        try (PreparedStatement updateStatement = connection.prepareStatement(TASK_EXECUTION_UPDATE_STATEMENT_TEMPLATE);){
            int index = 0;
            updateStatement.setTimestamp(++index, info.hasStartTime() ? new Timestamp(info.getStartTime()) : DEFAULT_TIMESTAMP, DatabaseJobHistoryStoreV100.getCalendarUTCInstance());
            updateStatement.setTimestamp(++index, info.hasEndTime() ? new Timestamp(info.getEndTime()) : DEFAULT_TIMESTAMP, DatabaseJobHistoryStoreV100.getCalendarUTCInstance());
            updateStatement.setLong(++index, info.hasDuration() ? info.getDuration() : -1L);
            updateStatement.setString(++index, info.hasState() ? info.getState().name() : null);
            updateStatement.setString(++index, info.hasFailureException() ? info.getFailureException() : null);
            updateStatement.setLong(++index, info.hasLowWatermark() ? info.getLowWatermark() : -1L);
            updateStatement.setLong(++index, info.hasHighWatermark() ? info.getHighWatermark() : -1L);
            updateStatement.setString(++index, info.hasTable() && info.getTable().hasNamespace() ? info.getTable().getNamespace() : null);
            updateStatement.setString(++index, info.hasTable() && info.getTable().hasName() ? info.getTable().getName() : null);
            updateStatement.setString(++index, info.hasTable() && info.getTable().hasType() ? info.getTable().getType().name() : null);
            updateStatement.setString(++index, info.getTaskId());
            updateStatement.executeUpdate();
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean existsMetric(Connection connection, String template, String id, Metric metric) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void updateMetric(Connection connection, String template, String id, Metric metric, boolean insert) throws SQLException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)metric.hasGroup());
        Preconditions.checkArgument((boolean)metric.hasName());
        Preconditions.checkArgument((boolean)metric.hasType());
        Preconditions.checkArgument((boolean)metric.hasValue());
        try (PreparedStatement updateStatement = connection.prepareStatement(template);){
            int index = 0;
            if (insert) {
                updateStatement.setString(++index, id);
                updateStatement.setString(++index, metric.getGroup());
                updateStatement.setString(++index, metric.getName());
                updateStatement.setString(++index, metric.getType().name());
                updateStatement.setString(++index, metric.getValue());
            } else {
                updateStatement.setString(++index, metric.getValue());
                updateStatement.setString(++index, id);
                updateStatement.setString(++index, metric.getGroup());
                updateStatement.setString(++index, metric.getName());
                updateStatement.setString(++index, metric.getType().name());
            }
            updateStatement.executeUpdate();
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean existsProperty(Connection connection, String template, String id, String key) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void updateProperty(Connection connection, String template, String id, String key, String value, boolean insert) throws SQLException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0);
        try (PreparedStatement updateStatement = connection.prepareStatement(template);){
            int index = 0;
            if (insert) {
                updateStatement.setString(++index, id);
                updateStatement.setString(++index, key);
                updateStatement.setString(++index, value);
            } else {
                updateStatement.setString(++index, value);
                updateStatement.setString(++index, id);
                updateStatement.setString(++index, key);
            }
            updateStatement.executeUpdate();
        }
    }

    /*
     * Exception decompiling
     */
    private JobExecutionInfo processQueryById(Connection connection, String jobId, JobExecutionQuery query, Filter tableFilter) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [116[UNCONDITIONALDOLOOP]], but top level block is 117[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<JobExecutionInfo> processQueryByJobName(Connection connection, String jobName, JobExecutionQuery query, Filter tableFilter) throws SQLException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)jobName) ? 1 : 0) != 0);
        Filter timeRangeFilter = Filter.MISSING;
        String jobIdByNameQuery = JOB_ID_QUERY_BY_JOB_NAME_STATEMENT_TEMPLATE;
        if (query.hasTimeRange()) {
            try {
                timeRangeFilter = this.constructTimeRangeFilter(query.getTimeRange());
                if (timeRangeFilter.isPresent()) {
                    jobIdByNameQuery = jobIdByNameQuery + " AND " + timeRangeFilter;
                }
            }
            catch (ParseException pe) {
                LOGGER.error("Failed to parse the query time range", (Throwable)pe);
                throw new SQLException(pe);
            }
        }
        jobIdByNameQuery = jobIdByNameQuery + " ORDER BY created_ts DESC";
        ArrayList jobExecutionInfos = Lists.newArrayList();
        try (PreparedStatement queryStatement = connection.prepareStatement(jobIdByNameQuery);){
            int limit = query.getLimit();
            if (limit > 0) {
                queryStatement.setMaxRows(limit);
            }
            queryStatement.setString(1, jobName);
            if (timeRangeFilter.isPresent()) {
                timeRangeFilter.addParameters(queryStatement, 2);
            }
            try (ResultSet rs = queryStatement.executeQuery();){
                while (rs.next()) {
                    jobExecutionInfos.add(this.processQueryById(connection, rs.getString(1), query, tableFilter));
                }
            }
        }
        return jobExecutionInfos;
    }

    private List<JobExecutionInfo> processQueryByTable(Connection connection, JobExecutionQuery query) throws SQLException {
        Preconditions.checkArgument((boolean)query.getId().isTable());
        Filter tableFilter = this.constructTableFilter(query.getId().getTable());
        String jobNameByTableQuery = String.format(JOB_NAME_QUERY_BY_TABLE_STATEMENT_TEMPLATE, tableFilter);
        ArrayList jobExecutionInfos = Lists.newArrayList();
        try (PreparedStatement queryStatement = connection.prepareStatement(jobNameByTableQuery);){
            if (tableFilter.isPresent()) {
                tableFilter.addParameters(queryStatement, 1);
            }
            try (ResultSet rs = queryStatement.executeQuery();){
                while (rs.next()) {
                    jobExecutionInfos.addAll(this.processQueryByJobName(connection, rs.getString(1), query, tableFilter));
                }
            }
        }
        return jobExecutionInfos;
    }

    /*
     * Exception decompiling
     */
    private List<JobExecutionInfo> processListQuery(Connection connection, JobExecutionQuery query) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private JobExecutionInfo resultSetToJobExecutionInfo(ResultSet rs) throws SQLException {
        String trackingUrl;
        JobExecutionInfo jobExecutionInfo = new JobExecutionInfo();
        jobExecutionInfo.setJobName(rs.getString("job_name"));
        jobExecutionInfo.setJobId(rs.getString("job_id"));
        try {
            jobExecutionInfo.setStartTime(rs.getTimestamp("start_time").getTime());
        }
        catch (SQLException se) {
            jobExecutionInfo.setStartTime(0L);
        }
        try {
            jobExecutionInfo.setEndTime(rs.getTimestamp("end_time").getTime());
        }
        catch (SQLException se) {
            jobExecutionInfo.setEndTime(0L);
        }
        jobExecutionInfo.setDuration(rs.getLong("duration"));
        String state = rs.getString("state");
        if (!Strings.isNullOrEmpty((String)state)) {
            jobExecutionInfo.setState(JobStateEnum.valueOf((String)state));
        }
        jobExecutionInfo.setLaunchedTasks(rs.getInt("launched_tasks"));
        jobExecutionInfo.setCompletedTasks(rs.getInt("completed_tasks"));
        String launcherType = rs.getString("launcher_type");
        if (!Strings.isNullOrEmpty((String)launcherType)) {
            jobExecutionInfo.setLauncherType(LauncherTypeEnum.valueOf((String)launcherType));
        }
        if (!Strings.isNullOrEmpty((String)(trackingUrl = rs.getString("tracking_url")))) {
            jobExecutionInfo.setTrackingUrl(trackingUrl);
        }
        return jobExecutionInfo;
    }

    private static TaskExecutionInfo resultSetToTaskExecutionInfo(ResultSet rs) throws SQLException {
        String type;
        String name;
        String failureException;
        TaskExecutionInfo taskExecutionInfo = new TaskExecutionInfo();
        taskExecutionInfo.setTaskId(rs.getString("task_id"));
        taskExecutionInfo.setJobId(rs.getString("job_id"));
        try {
            taskExecutionInfo.setStartTime(rs.getTimestamp("start_time").getTime());
        }
        catch (SQLException se) {
            taskExecutionInfo.setStartTime(0L);
        }
        try {
            taskExecutionInfo.setEndTime(rs.getTimestamp("end_time").getTime());
        }
        catch (SQLException se) {
            taskExecutionInfo.setEndTime(0L);
        }
        taskExecutionInfo.setDuration(rs.getLong("duration"));
        String state = rs.getString("state");
        if (!Strings.isNullOrEmpty((String)state)) {
            taskExecutionInfo.setState(TaskStateEnum.valueOf((String)state));
        }
        if (!Strings.isNullOrEmpty((String)(failureException = rs.getString("failure_exception")))) {
            taskExecutionInfo.setFailureException(failureException);
        }
        taskExecutionInfo.setLowWatermark(rs.getLong("low_watermark"));
        taskExecutionInfo.setHighWatermark(rs.getLong("high_watermark"));
        Table table = new Table();
        String namespace = rs.getString("table_namespace");
        if (!Strings.isNullOrEmpty((String)namespace)) {
            table.setNamespace(namespace);
        }
        if (!Strings.isNullOrEmpty((String)(name = rs.getString("table_name")))) {
            table.setName(name);
        }
        if (!Strings.isNullOrEmpty((String)(type = rs.getString("table_type")))) {
            table.setType(TableTypeEnum.valueOf((String)type));
        }
        taskExecutionInfo.setTable(table);
        return taskExecutionInfo;
    }

    private static Metric resultSetToMetric(ResultSet rs) throws SQLException {
        Metric metric = new Metric();
        metric.setGroup(rs.getString("metric_group"));
        metric.setName(rs.getString("metric_name"));
        metric.setType(MetricTypeEnum.valueOf((String)rs.getString("metric_type")));
        metric.setValue(rs.getString("metric_value"));
        return metric;
    }

    private static AbstractMap.SimpleEntry<String, String> resultSetToProperty(ResultSet rs) throws SQLException {
        return new AbstractMap.SimpleEntry<String, String>(rs.getString(1), rs.getString(2));
    }

    private Filter constructTimeRangeFilter(TimeRange timeRange) throws ParseException {
        ArrayList values = Lists.newArrayList();
        StringBuilder sb = new StringBuilder();
        if (!timeRange.hasTimeFormat()) {
            LOGGER.warn("Skipping the time range filter as there is no time format in: " + timeRange);
            return Filter.MISSING;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(timeRange.getTimeFormat());
        boolean hasStartTime = timeRange.hasStartTime();
        if (hasStartTime) {
            sb.append("start_time>?");
            values.add(new Timestamp(dateFormat.parse(timeRange.getStartTime()).getTime()).toString());
        }
        if (timeRange.hasEndTime()) {
            if (hasStartTime) {
                sb.append(" AND ");
            }
            sb.append("end_time<?");
            values.add(new Timestamp(dateFormat.parse(timeRange.getEndTime()).getTime()).toString());
        }
        if (sb.length() > 0) {
            return new Filter(sb.toString(), values);
        }
        return Filter.MISSING;
    }

    private Filter constructTableFilter(Table table) {
        boolean hasName;
        ArrayList values = Lists.newArrayList();
        StringBuilder sb = new StringBuilder();
        boolean hasNamespace = table.hasNamespace();
        if (hasNamespace) {
            sb.append("table_namespace=?");
            values.add(table.getNamespace());
        }
        if (hasName = table.hasName()) {
            if (hasNamespace) {
                sb.append(" AND ");
            }
            sb.append("table_name=?");
            values.add(table.getName());
        }
        if (table.hasType()) {
            if (hasName) {
                sb.append(" AND ");
            }
            sb.append("table_type=?");
            values.add(table.getType().name());
        }
        if (sb.length() > 0) {
            return new Filter(sb.toString(), values);
        }
        return Filter.MISSING;
    }

    private static Calendar getCalendarUTCInstance() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    }
}

