/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metastore.nameParser;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.io.LineReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import org.apache.gobblin.metastore.nameParser.DatasetUrnStateStoreNameParser;
import org.apache.gobblin.util.guid.Guid;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class GuidDatasetUrnStateStoreNameParser
implements DatasetUrnStateStoreNameParser {
    private static final String TMP_SUFFIX = "_tmp";
    private final FileSystem fs;
    private Path versionIdentifier;
    private final StateStoreNameVersion version;
    @VisibleForTesting
    protected final BiMap<String, String> sanitizedNameToDatasetURNMap;

    public GuidDatasetUrnStateStoreNameParser(FileSystem fs, Path jobStatestoreRootDir) throws IOException {
        this.fs = fs;
        this.sanitizedNameToDatasetURNMap = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
        this.versionIdentifier = new Path(jobStatestoreRootDir, StateStoreNameVersion.V1.getDatasetUrnNameMapFile());
        if (this.fs.exists(this.versionIdentifier)) {
            this.version = StateStoreNameVersion.V1;
            try (FSDataInputStream in = this.fs.open(this.versionIdentifier);){
                LineReader lineReader = new LineReader((Readable)new InputStreamReader((InputStream)in, Charsets.UTF_8));
                String shortenName = lineReader.readLine();
                while (shortenName != null) {
                    String datasetUrn = lineReader.readLine();
                    this.sanitizedNameToDatasetURNMap.put((Object)shortenName, (Object)datasetUrn);
                    shortenName = lineReader.readLine();
                }
            }
        } else {
            this.version = StateStoreNameVersion.V0;
        }
    }

    @Override
    public String getDatasetUrnFromStateStoreName(String stateStoreName) throws IOException {
        if (this.version == StateStoreNameVersion.V0 || !this.sanitizedNameToDatasetURNMap.containsKey((Object)stateStoreName)) {
            return stateStoreName;
        }
        return (String)this.sanitizedNameToDatasetURNMap.get((Object)stateStoreName);
    }

    @Override
    public void persistDatasetUrns(Collection<String> datasetUrns) throws IOException {
        for (String datasetUrn : datasetUrns) {
            String key = Guid.fromStrings((String[])new String[]{datasetUrn}).toString();
            if (!this.sanitizedNameToDatasetURNMap.containsKey((Object)key)) {
                this.sanitizedNameToDatasetURNMap.put((Object)key, (Object)datasetUrn);
                continue;
            }
            if (((String)this.sanitizedNameToDatasetURNMap.get((Object)key)).equals(datasetUrn)) continue;
            throw new RuntimeException("Found a collision for " + datasetUrn + " with existing: " + (String)this.sanitizedNameToDatasetURNMap.get((Object)key));
        }
        Path tmpMapFile = new Path(this.versionIdentifier.getParent(), this.versionIdentifier.getName() + TMP_SUFFIX);
        try (FSDataOutputStream fsout = this.fs.create(tmpMapFile);){
            for (String key : this.sanitizedNameToDatasetURNMap.keySet()) {
                fsout.write(key.getBytes(Charsets.UTF_8));
                fsout.writeByte(10);
                fsout.write(((String)this.sanitizedNameToDatasetURNMap.get((Object)key)).getBytes(Charsets.UTF_8));
                fsout.writeByte(10);
            }
        }
        if (this.fs.exists(this.versionIdentifier) && !this.fs.rename(this.versionIdentifier, new Path(this.versionIdentifier.getParent(), this.versionIdentifier.getName() + "_" + System.currentTimeMillis()))) {
            throw new IOException("Failed to back up existing datasetUrn to stateStore name mapping file: " + this.versionIdentifier);
        }
        if (!this.fs.rename(tmpMapFile, this.versionIdentifier)) {
            throw new IOException("Failed to rename from " + tmpMapFile + " to " + this.versionIdentifier);
        }
    }

    @Override
    public String getStateStoreNameFromDatasetUrn(String datasetUrn) throws IOException {
        if (!this.sanitizedNameToDatasetURNMap.inverse().containsKey((Object)datasetUrn)) {
            String guid = Guid.fromStrings((String[])new String[]{datasetUrn}).toString();
            this.sanitizedNameToDatasetURNMap.put((Object)guid, (Object)datasetUrn);
        }
        return (String)this.sanitizedNameToDatasetURNMap.inverse().get((Object)datasetUrn);
    }

    public static enum StateStoreNameVersion {
        V0(""),
        V1("datasetUrnNameMapV1");

        private String datasetUrnNameMapFile;

        private StateStoreNameVersion(String datasetUrnNameMapFile) {
            this.datasetUrnNameMapFile = datasetUrnNameMapFile;
        }

        public String getDatasetUrnNameMapFile() {
            return this.datasetUrnNameMapFile;
        }
    }
}

