/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;

public class LeaderHistory
extends HelixProperty {
    private static final int HISTORY_SIZE = 10;

    public LeaderHistory(String id) {
        super(id);
    }

    public LeaderHistory(ZNRecord record) {
        super(record);
    }

    public void updateHistory(String clusterName, String instanceName) {
        List<String> list = this._record.getListField(clusterName);
        if (list == null) {
            list = new ArrayList<String>();
            this._record.setListField(clusterName, list);
        }
        if (list.size() == 10) {
            list.remove(0);
        }
        list.add(instanceName);
        List<String> historyList = this._record.getListField(ConfigProperty.HISTORY.name());
        if (historyList == null) {
            historyList = new ArrayList<String>();
            this._record.setListField(ConfigProperty.HISTORY.name(), historyList);
        }
        if (historyList.size() == 10) {
            historyList.remove(0);
        }
        HashMap<String, String> historyEntry = new HashMap<String, String>();
        long currentTime = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateTime = df.format(new Date(currentTime));
        historyEntry.put(ConfigProperty.CONTROLLER.name(), instanceName);
        historyEntry.put(ConfigProperty.TIME.name(), String.valueOf(currentTime));
        historyEntry.put(ConfigProperty.DATE.name(), dateTime);
        historyList.add(((Object)historyEntry).toString());
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private static enum ConfigProperty {
        HISTORY,
        TIME,
        DATE,
        CONTROLLER;

    }
}

