/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import org.apache.helix.monitoring.mbeans.JobMonitorMBean;
import org.apache.helix.task.TaskState;

public class JobMonitor
implements JobMonitorMBean {
    private static final String JOB_KEY = "Job";
    private String _clusterName;
    private String _jobType;
    private long _successfullJobCount;
    private long _failedJobCount;
    private long _abortedJobCount;
    private long _existingJobGauge;
    private long _queuedJobGauge;
    private long _runningJobGauge;

    public JobMonitor(String clusterName, String jobType) {
        this._clusterName = clusterName;
        this._jobType = jobType;
        this._successfullJobCount = 0L;
        this._failedJobCount = 0L;
        this._abortedJobCount = 0L;
        this._existingJobGauge = 0L;
        this._queuedJobGauge = 0L;
        this._runningJobGauge = 0L;
    }

    @Override
    public long getSuccessfulJobCount() {
        return this._successfullJobCount;
    }

    @Override
    public long getFailedJobCount() {
        return this._failedJobCount;
    }

    @Override
    public long getAbortedJobCount() {
        return this._abortedJobCount;
    }

    @Override
    public long getExistingJobGauge() {
        return this._existingJobGauge;
    }

    @Override
    public long getQueuedJobGauge() {
        return this._queuedJobGauge;
    }

    @Override
    public long getRunningJobGauge() {
        return this._runningJobGauge;
    }

    @Override
    public String getSensorName() {
        return String.format("%s.%s.%s", this._clusterName, JOB_KEY, this._jobType);
    }

    public String getJobType() {
        return this._jobType;
    }

    public void updateJobCounters(TaskState to) {
        if (to.equals((Object)TaskState.FAILED)) {
            ++this._failedJobCount;
        } else if (to.equals((Object)TaskState.COMPLETED)) {
            ++this._successfullJobCount;
        } else if (to.equals((Object)TaskState.ABORTED)) {
            ++this._abortedJobCount;
        }
    }

    public void resetJobGauge() {
        this._queuedJobGauge = 0L;
        this._existingJobGauge = 0L;
        this._runningJobGauge = 0L;
    }

    public void updateJobGauge(TaskState to) {
        ++this._existingJobGauge;
        if (to == null || to.equals((Object)TaskState.NOT_STARTED)) {
            ++this._queuedJobGauge;
        } else if (to.equals((Object)TaskState.IN_PROGRESS)) {
            ++this._runningJobGauge;
        }
    }
}

