/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.kafka;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.avro.Schema;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.gobblin.kafka.schemareg.HttpClientFactory;
import org.apache.gobblin.metrics.kafka.KafkaSchemaRegistry;
import org.apache.gobblin.metrics.kafka.SchemaRegistryException;
import org.apache.gobblin.metrics.reporter.util.KafkaAvroReporterUtil;
import org.apache.gobblin.util.AvroUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAvroSchemaRegistry
extends KafkaSchemaRegistry<String, Schema> {
    private static final Logger log = LoggerFactory.getLogger(KafkaAvroSchemaRegistry.class);
    private static final Logger LOG = LoggerFactory.getLogger(KafkaAvroSchemaRegistry.class);
    private static final String GET_RESOURCE_BY_ID = "/id=";
    private static final String GET_RESOURCE_BY_TYPE = "/latest_with_type=";
    private static final String SCHEMA_ID_HEADER_NAME = "Location";
    private static final String SCHEMA_ID_HEADER_PREFIX = "/id=";
    public static final int SCHEMA_ID_LENGTH_BYTE = 16;
    public static final byte MAGIC_BYTE = 0;
    private final GenericObjectPool<HttpClient> httpClientPool;
    private final String url;
    private final Optional<Map<String, String>> namespaceOverride;

    public KafkaAvroSchemaRegistry(Properties props) {
        super(props);
        Preconditions.checkArgument((boolean)props.containsKey("kafka.schema.registry.url"), (Object)String.format("Property %s not provided.", "kafka.schema.registry.url"));
        this.url = props.getProperty("kafka.schema.registry.url");
        this.namespaceOverride = KafkaAvroReporterUtil.extractOverrideNamespace(props);
        int objPoolSize = Integer.parseInt(props.getProperty("kafka.source.work.units.creation.threads", "30"));
        LOG.info("Create HttpClient pool with size " + objPoolSize);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(objPoolSize);
        config.setMaxIdle(objPoolSize);
        HttpClientFactory factory = new HttpClientFactory();
        if (this.props.containsKey("kafka.schema.registry.httpclient.so.timeout")) {
            String soTimeout = this.props.getProperty("kafka.schema.registry.httpclient.so.timeout");
            factory.setSoTimeout(Integer.parseInt(soTimeout));
        }
        if (this.props.containsKey("kafka.schema.registry.httpclient.conn.timeout")) {
            String connTimeout = this.props.getProperty("kafka.schema.registry.httpclient.conn.timeout");
            factory.setConnTimeout(Integer.parseInt(connTimeout));
        }
        this.httpClientPool = new GenericObjectPool((PooledObjectFactory)factory, config);
    }

    public int getSchemaIdLengthByte() {
        return 16;
    }

    @Override
    public Schema getSchemaByKey(String key) throws SchemaRegistryException {
        try {
            return (Schema)this.cachedSchemasByKeys.get((Object)key);
        }
        catch (ExecutionException e) {
            throw new SchemaRegistryException(String.format("Schema with key %s cannot be retrieved", key), e);
        }
    }

    @Override
    public Schema getLatestSchemaByTopic(String topic) throws SchemaRegistryException {
        Schema schema;
        String schemaUrl = this.url + GET_RESOURCE_BY_TYPE + topic;
        LOG.debug("Fetching from URL : " + schemaUrl);
        int retryInterval = Integer.parseInt(this.props.getProperty("kafka.schema.registry.retry.interval.inMillis", Integer.toString(5000)));
        int retryTimes = Integer.parseInt(this.props.getProperty("kafka.schema.registry.retry.times", Integer.toString(10)));
        GetMethod get = new GetMethod(schemaUrl);
        int statusCode = -1;
        String schemaString = "";
        HttpClient httpClient = this.borrowClient();
        int loop = 0;
        try {
            while (++loop <= retryTimes) {
                try {
                    statusCode = httpClient.executeMethod((HttpMethod)get);
                    schemaString = get.getResponseBodyAsString();
                    break;
                }
                catch (Exception e) {
                    if (loop >= retryTimes) {
                        throw e;
                    }
                    log.error("Exception when fetching schema : {}", (Object)e.toString());
                    Thread.sleep(retryInterval);
                }
            }
        }
        catch (HttpException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            get.releaseConnection();
            this.httpClientPool.returnObject((Object)httpClient);
        }
        if (statusCode != 200) {
            throw new SchemaRegistryException(String.format("Latest schema for topic %s cannot be retrieved. Status code = %d", topic, statusCode));
        }
        try {
            schema = new Schema.Parser().parse(schemaString);
        }
        catch (Throwable t) {
            throw new SchemaRegistryException(String.format("Latest schema for topic %s cannot be retrieved", topic), t);
        }
        return schema;
    }

    private HttpClient borrowClient() throws SchemaRegistryException {
        try {
            return (HttpClient)this.httpClientPool.borrowObject();
        }
        catch (Exception e) {
            throw new SchemaRegistryException("Unable to borrow " + HttpClient.class.getSimpleName());
        }
    }

    @Override
    public String register(Schema schema, String overrideName) throws SchemaRegistryException {
        return this.register(AvroUtils.switchName((Schema)schema, (String)overrideName));
    }

    @Override
    public synchronized String register(Schema schema) throws SchemaRegistryException {
        if (this.namespaceOverride.isPresent()) {
            schema = AvroUtils.switchNamespace((Schema)schema, (Map)((Map)this.namespaceOverride.get()));
        }
        LOG.info("Registering schema " + schema.toString());
        PostMethod post = new PostMethod(this.url);
        post.addParameter("schema", schema.toString());
        HttpClient httpClient = this.borrowClient();
        try {
            String schemaKey;
            Header[] headers;
            LOG.debug("Loading: " + post.getURI());
            int statusCode = httpClient.executeMethod((HttpMethod)post);
            if (statusCode != 201) {
                throw new SchemaRegistryException("Error occurred while trying to register schema: " + statusCode);
            }
            String response = post.getResponseBodyAsString();
            if (response != null) {
                LOG.info("Received response " + response);
            }
            if ((headers = post.getResponseHeaders(SCHEMA_ID_HEADER_NAME)).length != 1) {
                throw new SchemaRegistryException("Error reading schema id returned by registerSchema call: headers.length = " + headers.length);
            }
            if (!headers[0].getValue().startsWith("/id=")) {
                throw new SchemaRegistryException("Error parsing schema id returned by registerSchema call: header = " + headers[0].getValue());
            }
            LOG.info("Registered schema successfully");
            String string = schemaKey = headers[0].getValue().substring("/id=".length());
            return string;
        }
        catch (Throwable t) {
            throw new SchemaRegistryException(t);
        }
        finally {
            post.releaseConnection();
            this.httpClientPool.returnObject((Object)httpClient);
        }
    }

    @Override
    protected Schema fetchSchemaByKey(String key) throws SchemaRegistryException {
        Schema schema;
        String schemaString;
        int statusCode;
        String schemaUrl = this.url + "/id=" + key;
        GetMethod get = new GetMethod(schemaUrl);
        HttpClient httpClient = this.borrowClient();
        try {
            statusCode = httpClient.executeMethod((HttpMethod)get);
            schemaString = get.getResponseBodyAsString();
        }
        catch (IOException e) {
            throw new SchemaRegistryException(e);
        }
        finally {
            get.releaseConnection();
            this.httpClientPool.returnObject((Object)httpClient);
        }
        if (statusCode != 200) {
            throw new SchemaRegistryException(String.format("Schema with key %s cannot be retrieved, statusCode = %d", key, statusCode));
        }
        try {
            schema = new Schema.Parser().parse(schemaString);
        }
        catch (Throwable t) {
            throw new SchemaRegistryException(String.format("Schema with ID = %s cannot be parsed", key), t);
        }
        return schema;
    }
}

