/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka.workunit.packer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.moment.GeometricMean;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaPartition;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaUtils;
import org.apache.gobblin.source.extractor.extract.kafka.workunit.packer.KafkaWorkUnitSizeEstimator;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAvgRecordTimeBasedWorkUnitSizeEstimator
implements KafkaWorkUnitSizeEstimator {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaAvgRecordTimeBasedWorkUnitSizeEstimator.class);
    private static final GeometricMean GEOMETRIC_MEAN = new GeometricMean();
    private static final double EPS = 0.01;
    private final Map<String, Double> estAvgMillis = Maps.newHashMap();
    private double avgEstAvgMillis = 0.0;

    KafkaAvgRecordTimeBasedWorkUnitSizeEstimator(SourceState state) {
        this.readPrevAvgRecordMillis(state);
    }

    @Override
    public double calcEstimatedSize(WorkUnit workUnit) {
        double avgMillis = this.getEstAvgMillisForTopic(KafkaUtils.getTopicName((State)workUnit));
        long numOfRecords = workUnit.getPropAsLong("workunit.high.water.mark") - workUnit.getPropAsLong("workunit.low.water.mark");
        return avgMillis * (double)numOfRecords;
    }

    private static double geometricMean(List<Double> numbers) {
        Preconditions.checkArgument((!numbers.isEmpty() ? 1 : 0) != 0);
        double[] numberArray = new double[numbers.size()];
        for (int i = 0; i < numbers.size(); ++i) {
            numberArray[i] = Math.max(numbers.get(i), 0.01);
        }
        return GEOMETRIC_MEAN.evaluate(numberArray, 0, numberArray.length);
    }

    private double getEstAvgMillisForTopic(String topic) {
        if (this.estAvgMillis.containsKey(topic)) {
            return this.estAvgMillis.get(topic);
        }
        return this.avgEstAvgMillis;
    }

    private void readPrevAvgRecordMillis(SourceState state) {
        HashMap prevAvgMillis = Maps.newHashMap();
        for (WorkUnitState workUnitState : state.getPreviousWorkUnitStates()) {
            List<KafkaPartition> partitions = KafkaUtils.getPartitions((State)workUnitState);
            for (KafkaPartition partition : partitions) {
                if (!KafkaUtils.containsPartitionAvgRecordMillis((State)workUnitState, partition)) continue;
                double prevAvgMillisForPartition = KafkaUtils.getPartitionAvgRecordMillis((State)workUnitState, partition);
                if (prevAvgMillis.containsKey(partition.getTopicName())) {
                    ((List)prevAvgMillis.get(partition.getTopicName())).add(prevAvgMillisForPartition);
                    continue;
                }
                prevAvgMillis.put(partition.getTopicName(), Lists.newArrayList((Object[])new Double[]{prevAvgMillisForPartition}));
            }
        }
        this.estAvgMillis.clear();
        if (prevAvgMillis.isEmpty()) {
            this.avgEstAvgMillis = 1.0;
        } else {
            ArrayList allEstAvgMillis = Lists.newArrayList();
            for (Map.Entry entry : prevAvgMillis.entrySet()) {
                String topic = (String)entry.getKey();
                List prevAvgMillisForPartitions = (List)entry.getValue();
                double estAvgMillisForTopic = KafkaAvgRecordTimeBasedWorkUnitSizeEstimator.geometricMean(prevAvgMillisForPartitions);
                this.estAvgMillis.put(topic, estAvgMillisForTopic);
                LOG.info(String.format("Estimated avg time to pull a record for topic %s is %f milliseconds", topic, estAvgMillisForTopic));
                allEstAvgMillis.add(estAvgMillisForTopic);
            }
            this.avgEstAvgMillis = KafkaAvgRecordTimeBasedWorkUnitSizeEstimator.geometricMean(allEstAvgMillis);
        }
        LOG.info("For all topics not pulled in the previous run, estimated avg time to pull a record is " + this.avgEstAvgMillis + " milliseconds");
    }
}

