/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.azkaban;

import azkaban.jobExecutor.AbstractJob;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.apache.gobblin.azkaban.AzkabanJobLauncher;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.yarn.GobblinYarnAppLauncher;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.log4j.Logger;

public class AzkabanGobblinYarnAppLauncher
extends AbstractJob {
    private static final Logger LOGGER = Logger.getLogger(AzkabanJobLauncher.class);
    private final GobblinYarnAppLauncher gobblinYarnAppLauncher;

    public AzkabanGobblinYarnAppLauncher(String jobId, Properties props) throws IOException {
        super(jobId, LOGGER);
        Config gobblinConfig = ConfigUtils.propertiesToConfig((Properties)props);
        this.gobblinYarnAppLauncher = new GobblinYarnAppLauncher(gobblinConfig, new YarnConfiguration());
    }

    public void run() throws Exception {
        this.gobblinYarnAppLauncher.launch();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    AzkabanGobblinYarnAppLauncher.this.gobblinYarnAppLauncher.stop();
                }
                catch (IOException ioe) {
                    LOGGER.error((Object)("Failed to shutdown the " + GobblinYarnAppLauncher.class.getSimpleName()), (Throwable)ioe);
                }
                catch (TimeoutException te) {
                    LOGGER.error((Object)("Timed out in shutting down the " + GobblinYarnAppLauncher.class.getSimpleName()), (Throwable)te);
                }
            }
        });
    }

    public void cancel() throws Exception {
        try {
            this.gobblinYarnAppLauncher.stop();
        }
        finally {
            super.cancel();
        }
    }
}

