/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.hive.HiveRegistrationUnit;

@Alpha
public class HiveTable
extends HiveRegistrationUnit {
    private List<HiveRegistrationUnit.Column> partitionKeys;
    private Optional<String> owner;
    private Optional<String> tableType;
    private Optional<Long> retention;

    private HiveTable(Builder builder) {
        super(builder);
        this.partitionKeys = ImmutableList.copyOf((Collection)builder.partitionKeys);
    }

    @Override
    protected void populateTablePartitionFields(State state) {
        super.populateTablePartitionFields(state);
        this.owner = HiveTable.populateField(state, "owner", new TypeToken<String>(){});
        this.tableType = HiveTable.populateField(state, "table.type", new TypeToken<String>(){});
        this.retention = HiveTable.populateField(state, "retention", new TypeToken<Long>(){});
    }

    public void setOwner(String owner) {
        this.owner = Optional.of((Object)owner);
    }

    public void setTableType(String tableType) {
        this.tableType = Optional.of((Object)tableType);
    }

    public void setRetention(long retention) {
        this.retention = Optional.of((Object)retention);
    }

    @Override
    protected void updateTablePartitionFields(State state, String key, Object value) {
        super.updateTablePartitionFields(state, key, value);
        boolean isExistingField = true;
        switch (key) {
            case "owner": {
                this.owner = Optional.of((Object)((String)value));
                break;
            }
            case "table.type": {
                this.tableType = Optional.of((Object)((String)value));
                break;
            }
            case "retention": {
                this.retention = Optional.of((Object)((Long)value));
                break;
            }
            default: {
                isExistingField = false;
            }
        }
        if (isExistingField) {
            state.removeProp(key);
        }
    }

    public List<HiveRegistrationUnit.Column> getPartitionKeys() {
        return this.partitionKeys;
    }

    public Optional<String> getOwner() {
        return this.owner;
    }

    public Optional<String> getTableType() {
        return this.tableType;
    }

    public Optional<Long> getRetention() {
        return this.retention;
    }

    @Override
    public String toString() {
        return "HiveTable(partitionKeys=" + this.getPartitionKeys() + ", owner=" + this.getOwner() + ", tableType=" + this.getTableType() + ", retention=" + this.getRetention() + ")";
    }

    public void setPartitionKeys(List<HiveRegistrationUnit.Column> partitionKeys) {
        this.partitionKeys = partitionKeys;
    }

    public static class Builder
    extends HiveRegistrationUnit.Builder<Builder> {
        private List<HiveRegistrationUnit.Column> partitionKeys = Lists.newArrayList();

        public Builder withPartitionKeys(List<HiveRegistrationUnit.Column> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        @Override
        public HiveTable build() {
            return new HiveTable(this);
        }
    }
}

