/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.typesafe.config.Config;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.cluster.GobblinHelixJob;
import org.apache.gobblin.cluster.GobblinHelixJobLauncher;
import org.apache.gobblin.cluster.event.DeleteJobConfigArrivalEvent;
import org.apache.gobblin.cluster.event.NewJobConfigArrivalEvent;
import org.apache.gobblin.cluster.event.UpdateJobConfigArrivalEvent;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.instrumented.StandardMetricsBridge;
import org.apache.gobblin.metrics.ContextAwareTimer;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.runtime.JobContext;
import org.apache.gobblin.runtime.JobException;
import org.apache.gobblin.runtime.JobLauncher;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.api.MutableJobCatalog;
import org.apache.gobblin.runtime.listeners.AbstractJobListener;
import org.apache.gobblin.runtime.listeners.JobListener;
import org.apache.gobblin.scheduler.JobScheduler;
import org.apache.gobblin.scheduler.SchedulerService;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.fs.Path;
import org.apache.helix.HelixManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class GobblinHelixJobScheduler
extends JobScheduler
implements StandardMetricsBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(GobblinHelixJobScheduler.class);
    static final String HELIX_MANAGER_KEY = "helixManager";
    static final String APPLICATION_WORK_DIR_KEY = "applicationWorkDir";
    static final String METADATA_TAGS = "metadataTags";
    static final String JOB_RUNNING_MAP = "jobRunningMap";
    private final Properties properties;
    private final HelixManager helixManager;
    private final EventBus eventBus;
    private final Path appWorkDir;
    private final List<? extends Tag<?>> metadataTags;
    private final ConcurrentHashMap<String, Boolean> jobRunningMap;
    private final MutableJobCatalog jobCatalog;
    private final MetricContext metricContext;
    private final Metrics metrics;

    public GobblinHelixJobScheduler(Properties properties, HelixManager helixManager, EventBus eventBus, Path appWorkDir, List<? extends Tag<?>> metadataTags, SchedulerService schedulerService, MutableJobCatalog jobCatalog) throws Exception {
        super(properties, schedulerService);
        this.properties = properties;
        this.helixManager = helixManager;
        this.eventBus = eventBus;
        this.jobRunningMap = new ConcurrentHashMap();
        this.appWorkDir = appWorkDir;
        this.metadataTags = metadataTags;
        this.jobCatalog = jobCatalog;
        this.metricContext = Instrumented.getMetricContext((State)new State(properties), ((Object)((Object)this)).getClass());
        this.metrics = new Metrics(this.metricContext);
    }

    @Nonnull
    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    public boolean isInstrumentationEnabled() {
        return GobblinMetrics.isEnabled((Properties)this.properties);
    }

    public StandardMetricsBridge.StandardMetrics getStandardMetrics() {
        return this.metrics;
    }

    protected void startUp() throws Exception {
        this.eventBus.register((Object)this);
        super.startUp();
    }

    public void scheduleJob(Properties jobProps, JobListener jobListener) throws JobException {
        HashMap additionalJobDataMap = Maps.newHashMap();
        additionalJobDataMap.put(HELIX_MANAGER_KEY, this.helixManager);
        additionalJobDataMap.put(APPLICATION_WORK_DIR_KEY, this.appWorkDir);
        additionalJobDataMap.put(METADATA_TAGS, this.metadataTags);
        additionalJobDataMap.put(JOB_RUNNING_MAP, this.jobRunningMap);
        try {
            this.scheduleJob(jobProps, jobListener, additionalJobDataMap, GobblinHelixJob.class);
        }
        catch (Exception e) {
            throw new JobException("Failed to schedule job " + jobProps.getProperty("job.name"), (Throwable)e);
        }
    }

    protected void startServices() throws Exception {
    }

    public void runJob(Properties jobProps, JobListener jobListener) throws JobException {
        try {
            GobblinHelixJobLauncher jobLauncher = this.buildGobblinHelixJobLauncher(jobProps);
            this.runJob(jobProps, jobListener, (JobLauncher)jobLauncher);
        }
        catch (Exception e) {
            throw new JobException("Failed to run job " + jobProps.getProperty("job.name"), (Throwable)e);
        }
    }

    private GobblinHelixJobLauncher buildGobblinHelixJobLauncher(Properties jobProps) throws Exception {
        return new GobblinHelixJobLauncher(jobProps, this.helixManager, this.appWorkDir, this.metadataTags, this.jobRunningMap);
    }

    @Subscribe
    public void handleNewJobConfigArrival(NewJobConfigArrivalEvent newJobArrival) {
        LOGGER.info("Received new job configuration of job " + newJobArrival.getJobName());
        try {
            Properties jobConfig = new Properties();
            jobConfig.putAll((Map<?, ?>)this.properties);
            jobConfig.putAll((Map<?, ?>)newJobArrival.getJobConfig());
            this.metrics.updateTimeBeforeJobScheduling(jobConfig);
            if (jobConfig.containsKey("job.schedule")) {
                LOGGER.info("Scheduling job " + newJobArrival.getJobName());
                this.scheduleJob(jobConfig, (JobListener)new MetricsTrackingListener(this.metrics));
            } else {
                LOGGER.info("No job schedule found, so running job " + newJobArrival.getJobName());
                this.jobExecutor.execute(new NonScheduledJobRunner(newJobArrival.getJobName(), jobConfig, (JobListener)new MetricsTrackingListener(this.metrics)));
            }
        }
        catch (JobException je) {
            LOGGER.error("Failed to schedule or run job " + newJobArrival.getJobName(), (Throwable)je);
        }
    }

    @Subscribe
    public void handleUpdateJobConfigArrival(UpdateJobConfigArrivalEvent updateJobArrival) {
        LOGGER.info("Received update for job configuration of job " + updateJobArrival.getJobName());
        try {
            this.handleDeleteJobConfigArrival(new DeleteJobConfigArrivalEvent(updateJobArrival.getJobName(), updateJobArrival.getJobConfig()));
        }
        catch (Exception je) {
            LOGGER.error("Failed to update job " + updateJobArrival.getJobName(), (Throwable)je);
        }
        try {
            this.handleNewJobConfigArrival(new NewJobConfigArrivalEvent(updateJobArrival.getJobName(), updateJobArrival.getJobConfig()));
        }
        catch (Exception je) {
            LOGGER.error("Failed to update job " + updateJobArrival.getJobName(), (Throwable)je);
        }
    }

    @Subscribe
    public void handleDeleteJobConfigArrival(DeleteJobConfigArrivalEvent deleteJobArrival) {
        LOGGER.info("Received delete for job configuration of job " + deleteJobArrival.getJobName());
        try {
            this.unscheduleJob(deleteJobArrival.getJobName());
        }
        catch (JobException je) {
            LOGGER.error("Failed to unschedule job " + deleteJobArrival.getJobName());
        }
    }

    class NonScheduledJobRunner
    implements Runnable {
        private final String jobUri;
        private final Properties jobConfig;
        private final JobListener jobListener;
        private final Long creationTimeInMillis;

        public NonScheduledJobRunner(String jobUri, Properties jobConfig, JobListener jobListener) {
            this.jobUri = jobUri;
            this.jobConfig = jobConfig;
            this.jobListener = jobListener;
            this.creationTimeInMillis = System.currentTimeMillis();
        }

        @Override
        public void run() {
            try {
                ((MetricsTrackingListener)this.jobListener).metrics.updateTimeBeforeJobLaunching(this.jobConfig);
                ((MetricsTrackingListener)this.jobListener).metrics.updateTimeBetweenJobSchedulingAndJobLaunching(this.creationTimeInMillis, System.currentTimeMillis());
                GobblinHelixJobScheduler.this.runJob(this.jobConfig, this.jobListener);
                if (GobblinHelixJobScheduler.this.jobCatalog != null) {
                    try {
                        GobblinHelixJobScheduler.this.jobCatalog.remove(new URI(this.jobUri));
                    }
                    catch (URISyntaxException e) {
                        LOGGER.error("Failed to remove job with bad uri " + this.jobUri, (Throwable)e);
                    }
                }
            }
            catch (JobException je) {
                LOGGER.error("Failed to run job " + this.jobConfig.getProperty("job.name"), (Throwable)je);
            }
        }
    }

    private class MetricsTrackingListener
    extends AbstractJobListener {
        private final Metrics metrics;
        private static final String START_TIME = "startTime";

        MetricsTrackingListener(Metrics metrics) {
            this.metrics = metrics;
        }

        public void onJobPrepare(JobContext jobContext) throws Exception {
            super.onJobPrepare(jobContext);
            jobContext.getJobState().setProp(START_TIME, (Object)Long.toString(System.nanoTime()));
            if (GobblinHelixJobScheduler.this.isInstrumentationEnabled()) {
                this.metrics.totalJobsLaunched.incrementAndGet();
            }
        }

        public void onJobCompletion(JobContext jobContext) throws Exception {
            super.onJobCompletion(jobContext);
            long startTime = jobContext.getJobState().getPropAsLong(START_TIME);
            if (GobblinHelixJobScheduler.this.isInstrumentationEnabled()) {
                this.metrics.totalJobsCompleted.incrementAndGet();
                Instrumented.updateTimer((Optional)Optional.of((Object)this.metrics.timeForCompletedJobs), (long)(System.nanoTime() - startTime), (TimeUnit)TimeUnit.NANOSECONDS);
                if (jobContext.getJobState().getState() == JobState.RunningState.FAILED) {
                    this.metrics.totalJobsFailed.incrementAndGet();
                    Instrumented.updateTimer((Optional)Optional.of((Object)this.metrics.timeForFailedJobs), (long)(System.nanoTime() - startTime), (TimeUnit)TimeUnit.NANOSECONDS);
                } else {
                    this.metrics.totalJobsCommitted.incrementAndGet();
                    Instrumented.updateTimer((Optional)Optional.of((Object)this.metrics.timeForCommittedJobs), (long)(System.nanoTime() - startTime), (TimeUnit)TimeUnit.NANOSECONDS);
                }
            }
        }

        public void onJobCancellation(JobContext jobContext) throws Exception {
            super.onJobCancellation(jobContext);
            if (GobblinHelixJobScheduler.this.isInstrumentationEnabled()) {
                this.metrics.totalJobsCancelled.incrementAndGet();
            }
        }
    }

    private class Metrics
    extends StandardMetricsBridge.StandardMetrics {
        private final AtomicLong totalJobsLaunched;
        private final AtomicLong totalJobsCompleted;
        private final AtomicLong totalJobsCommitted;
        private final AtomicLong totalJobsFailed;
        private final AtomicLong totalJobsCancelled;
        private final ContextAwareTimer timeForCompletedJobs;
        private final ContextAwareTimer timeForFailedJobs;
        private final ContextAwareTimer timeForCommittedJobs;
        private final ContextAwareTimer timeBeforeJobScheduling;
        private final ContextAwareTimer timeBeforeJobLaunching;
        private final ContextAwareTimer timeBetwenJobSchedulingAndLaunching;
        private final ThreadPoolExecutor threadPoolExecutor;

        public Metrics(MetricContext metricContext) {
            this.threadPoolExecutor = (ThreadPoolExecutor)GobblinHelixJobScheduler.this.jobExecutor;
            int windowSize = ConfigUtils.getInt((Config)ConfigUtils.propertiesToConfig((Properties)GobblinHelixJobScheduler.this.properties), (String)"metrics.timer.window.size.in.minutes", (Integer)15);
            this.totalJobsLaunched = new AtomicLong(0L);
            this.totalJobsCompleted = new AtomicLong(0L);
            this.totalJobsCommitted = new AtomicLong(0L);
            this.totalJobsFailed = new AtomicLong(0L);
            this.totalJobsCancelled = new AtomicLong(0L);
            this.contextAwareMetrics.add(metricContext.newContextAwareGauge("numJobsLaunched", () -> this.totalJobsLaunched.get()));
            this.contextAwareMetrics.add(metricContext.newContextAwareGauge("numJobsCompleted", () -> this.totalJobsCompleted.get()));
            this.contextAwareMetrics.add(metricContext.newContextAwareGauge("numJobsCommitted", () -> this.totalJobsCommitted.get()));
            this.contextAwareMetrics.add(metricContext.newContextAwareGauge("numJobsFailed", () -> this.totalJobsFailed.get()));
            this.contextAwareMetrics.add(metricContext.newContextAwareGauge("numJobsCancelled", () -> this.totalJobsCancelled.get()));
            this.contextAwareMetrics.add(metricContext.newContextAwareGauge("numJobsRunning", () -> (int)(this.totalJobsLaunched.get() - this.totalJobsCompleted.get())));
            this.timeForCompletedJobs = metricContext.contextAwareTimer("timeForCompletedJobs", (long)windowSize, TimeUnit.MINUTES);
            this.timeForFailedJobs = metricContext.contextAwareTimer("timeForFailedJobs", (long)windowSize, TimeUnit.MINUTES);
            this.timeForCommittedJobs = metricContext.contextAwareTimer("timerForCommittedJobs", (long)windowSize, TimeUnit.MINUTES);
            this.timeBeforeJobScheduling = metricContext.contextAwareTimer("timerBeforeJobScheduling", (long)windowSize, TimeUnit.MINUTES);
            this.timeBeforeJobLaunching = metricContext.contextAwareTimer("timerBeforeJobLaunching", (long)windowSize, TimeUnit.MINUTES);
            this.timeBetwenJobSchedulingAndLaunching = metricContext.contextAwareTimer("timerBetwenJobSchedulingAndLaunching", (long)windowSize, TimeUnit.MINUTES);
            this.contextAwareMetrics.add(metricContext.newContextAwareGauge("executorActiveCount", () -> this.threadPoolExecutor.getActiveCount()));
            this.contextAwareMetrics.add(metricContext.newContextAwareGauge("executorMaximumPoolSize", () -> this.threadPoolExecutor.getMaximumPoolSize()));
            this.contextAwareMetrics.add(metricContext.newContextAwareGauge("executorPoolSize", () -> this.threadPoolExecutor.getPoolSize()));
            this.contextAwareMetrics.add(metricContext.newContextAwareGauge("executorCorePoolSize", () -> this.threadPoolExecutor.getCorePoolSize()));
            this.contextAwareMetrics.add(metricContext.newContextAwareGauge("executorQueueSize", () -> this.threadPoolExecutor.getQueue().size()));
            this.contextAwareMetrics.add(this.timeForCommittedJobs);
            this.contextAwareMetrics.add(this.timeForCompletedJobs);
            this.contextAwareMetrics.add(this.timeForFailedJobs);
            this.contextAwareMetrics.add(this.timeBeforeJobScheduling);
            this.contextAwareMetrics.add(this.timeBeforeJobLaunching);
            this.contextAwareMetrics.add(this.timeBetwenJobSchedulingAndLaunching);
        }

        private void updateTimeBeforeJobScheduling(Properties jobConfig) {
            long jobCreationTime = Long.parseLong(jobConfig.getProperty("flow.executionId", "0"));
            Instrumented.updateTimer((Optional)Optional.of((Object)this.timeBeforeJobScheduling), (long)(System.currentTimeMillis() - jobCreationTime), (TimeUnit)TimeUnit.MILLISECONDS);
        }

        private void updateTimeBeforeJobLaunching(Properties jobConfig) {
            long jobCreationTime = Long.parseLong(jobConfig.getProperty("flow.executionId", "0"));
            Instrumented.updateTimer((Optional)Optional.of((Object)this.timeBeforeJobLaunching), (long)(System.currentTimeMillis() - jobCreationTime), (TimeUnit)TimeUnit.MILLISECONDS);
        }

        private void updateTimeBetweenJobSchedulingAndJobLaunching(long scheduledTime, long launchingTime) {
            Instrumented.updateTimer((Optional)Optional.of((Object)this.timeBetwenJobSchedulingAndLaunching), (long)(launchingTime - scheduledTime), (TimeUnit)TimeUnit.MILLISECONDS);
        }

        public String getName() {
            return GobblinHelixJobScheduler.class.getName();
        }
    }
}

