/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ServiceManager;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.gobblin.cluster.GobblinClusterException;
import org.apache.gobblin.cluster.GobblinClusterUtils;
import org.apache.gobblin.cluster.GobblinHelixTaskStateTracker;
import org.apache.gobblin.cluster.SingleTask;
import org.apache.gobblin.cluster.TaskAttemptBuilder;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.runtime.TaskExecutor;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.runtime.TaskStateTracker;
import org.apache.gobblin.runtime.util.StateStores;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SingleTaskRunner {
    private static final Logger logger = LoggerFactory.getLogger(SingleTaskRunner.class);
    private final String jobId;
    private final String workUnitFilePath;
    private final Config clusterConfig;
    private final Path appWorkPath;
    private SingleTask task;
    private TaskExecutor taskExecutor;
    private GobblinHelixTaskStateTracker taskStateTracker;
    private ServiceManager serviceManager;

    SingleTaskRunner(String clusterConfigFilePath, String jobId, String workUnitFilePath) {
        this.jobId = jobId;
        this.workUnitFilePath = workUnitFilePath;
        this.clusterConfig = ConfigFactory.parseFile((File)new File(clusterConfigFilePath));
        String workDir = this.clusterConfig.getString("gobblin.cluster.workDir");
        this.appWorkPath = new Path(workDir);
    }

    void run() throws IOException, InterruptedException {
        logger.info("SingleTaskRunner running.");
        this.startServices();
        this.runTask();
        this.shutdownServices();
    }

    private void startServices() {
        logger.info("SingleTaskRunner start services.");
        this.getServices();
        this.serviceManager.startAsync();
        try {
            this.serviceManager.awaitHealthy(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new GobblinClusterException("Timeout waiting for services to start.", e);
        }
    }

    private void shutdownServices() {
        logger.info("SingleTaskRunner shutting down services.");
        this.serviceManager.stopAsync();
        try {
            this.serviceManager.awaitStopped(1L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            logger.error("Timeout waiting for services to shutdown.", (Throwable)e);
        }
    }

    private void runTask() throws IOException, InterruptedException {
        logger.info("SingleTaskRunner running task.");
        this.getSingleHelixTask();
        this.task.run();
    }

    private void getSingleHelixTask() throws IOException {
        FileSystem fs = this.getFileSystem();
        StateStores stateStores = new StateStores(this.clusterConfig, this.appWorkPath, "_taskstates", this.appWorkPath, "_workunits", this.appWorkPath, "_jobstates");
        Path jobStateFilePath = GobblinClusterUtils.getJobStateFilePath(stateStores.haveJobStateStore(), this.appWorkPath, this.jobId);
        TaskAttemptBuilder taskAttemptBuilder = this.getTaskAttemptBuilder(stateStores);
        this.task = new SingleTask(this.jobId, new Path(this.workUnitFilePath), jobStateFilePath, fs, taskAttemptBuilder, stateStores);
    }

    private TaskAttemptBuilder getTaskAttemptBuilder(StateStores stateStores) {
        TaskAttemptBuilder taskAttemptBuilder = new TaskAttemptBuilder((TaskStateTracker)this.taskStateTracker, this.taskExecutor);
        taskAttemptBuilder.setTaskStateStore((StateStore<TaskState>)stateStores.getTaskStateStore());
        return taskAttemptBuilder;
    }

    private void getServices() {
        Properties properties = ConfigUtils.configToProperties((Config)this.clusterConfig);
        this.taskExecutor = new TaskExecutor(properties);
        this.taskStateTracker = new GobblinHelixTaskStateTracker(properties);
        ArrayList services = Lists.newArrayList((Object[])new Service[]{this.taskExecutor, this.taskStateTracker});
        this.serviceManager = new ServiceManager((Iterable)services);
    }

    private FileSystem getFileSystem() throws IOException {
        Configuration conf = HadoopUtils.newConfiguration();
        FileSystem fs = this.clusterConfig.hasPath("fs.uri") ? FileSystem.get((URI)URI.create(this.clusterConfig.getString("fs.uri")), (Configuration)conf) : FileSystem.get((Configuration)conf);
        return fs;
    }
}

