/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.orchestration;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumentable;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.runtime.api.FlowSpec;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecCatalogListener;
import org.apache.gobblin.runtime.api.SpecCompiler;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.runtime.api.SpecProducer;
import org.apache.gobblin.runtime.api.TopologySpec;
import org.apache.gobblin.runtime.spec_catalog.TopologyCatalog;
import org.apache.gobblin.service.modules.flow.IdentityFlowToJobSpecCompiler;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class Orchestrator
implements SpecCatalogListener,
Instrumentable {
    protected final Logger _log;
    protected final SpecCompiler specCompiler;
    protected final Optional<TopologyCatalog> topologyCatalog;
    protected final MetricContext metricContext;
    private Optional<Meter> flowOrchestrationSuccessFulMeter;
    private Optional<Meter> flowOrchestrationFailedMeter;
    private Optional<Timer> flowOrchestrationTimer;
    private final ClassAliasResolver<SpecCompiler> aliasResolver;

    public Orchestrator(Config config, Optional<TopologyCatalog> topologyCatalog, Optional<Logger> log, boolean instrumentationEnabled) {
        Logger logger = this._log = log.isPresent() ? (Logger)log.get() : LoggerFactory.getLogger(this.getClass());
        if (instrumentationEnabled) {
            this.metricContext = Instrumented.getMetricContext((State)ConfigUtils.configToState((Config)config), IdentityFlowToJobSpecCompiler.class);
            this.flowOrchestrationSuccessFulMeter = Optional.of((Object)this.metricContext.meter("gobblin.service.flowOrchestration.successful"));
            this.flowOrchestrationFailedMeter = Optional.of((Object)this.metricContext.meter("gobblin.service.flowOrchestration.failed"));
            this.flowOrchestrationTimer = Optional.of((Object)this.metricContext.timer("gobblin.service.flowOrchestration.time"));
        } else {
            this.metricContext = null;
            this.flowOrchestrationSuccessFulMeter = Optional.absent();
            this.flowOrchestrationFailedMeter = Optional.absent();
            this.flowOrchestrationTimer = Optional.absent();
        }
        this.aliasResolver = new ClassAliasResolver(SpecCompiler.class);
        this.topologyCatalog = topologyCatalog;
        try {
            String specCompilerClassName = "org.apache.gobblin.service.modules.flow.IdentityFlowToJobSpecCompiler";
            if (config.hasPath("gobblin.service.flowCompiler.class")) {
                specCompilerClassName = config.getString("gobblin.service.flowCompiler.class");
            }
            this._log.info("Using specCompiler class name/alias " + specCompilerClassName);
            this.specCompiler = (SpecCompiler)ConstructorUtils.invokeConstructor(Class.forName(this.aliasResolver.resolve(specCompilerClassName)), (Object[])new Object[]{config});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Orchestrator(Config config, Optional<TopologyCatalog> topologyCatalog, Optional<Logger> log) {
        this(config, topologyCatalog, log, true);
    }

    public Orchestrator(Config config, Optional<TopologyCatalog> topologyCatalog, Logger log) {
        this(config, topologyCatalog, (Optional<Logger>)Optional.of((Object)log));
    }

    public Orchestrator(Config config, Logger log) {
        this(config, (Optional<TopologyCatalog>)Optional.absent(), (Optional<Logger>)Optional.of((Object)log));
    }

    public Orchestrator(Config config, Optional<TopologyCatalog> topologyCatalog) {
        this(config, topologyCatalog, (Optional<Logger>)Optional.absent());
    }

    public Orchestrator(Config config) {
        this(config, (Optional<TopologyCatalog>)Optional.absent(), (Optional<Logger>)Optional.absent());
    }

    @VisibleForTesting
    public SpecCompiler getSpecCompiler() {
        return this.specCompiler;
    }

    public void onAddSpec(Spec addedSpec) {
        if (addedSpec instanceof TopologySpec) {
            this._log.info("New Spec detected of type TopologySpec: " + addedSpec);
            this.specCompiler.onAddSpec(addedSpec);
        }
    }

    public void onDeleteSpec(URI deletedSpecURI, String deletedSpecVersion) {
        this._log.info("Spec deletion detected: " + deletedSpecURI + "/" + deletedSpecVersion);
        if (this.topologyCatalog.isPresent()) {
            this.specCompiler.onDeleteSpec(deletedSpecURI, deletedSpecVersion);
        }
    }

    public void onUpdateSpec(Spec updatedSpec) {
        this._log.info("Spec changed: " + updatedSpec);
        if (!(updatedSpec instanceof TopologySpec)) {
            return;
        }
        try {
            this.onDeleteSpec(updatedSpec.getUri(), updatedSpec.getVersion());
        }
        catch (Exception e) {
            this._log.error("Failed to update Spec: " + updatedSpec, (Throwable)e);
        }
        try {
            this.onAddSpec(updatedSpec);
        }
        catch (Exception e) {
            this._log.error("Failed to update Spec: " + updatedSpec, (Throwable)e);
        }
    }

    public void orchestrate(Spec spec) throws Exception {
        ((TopologyCatalog)this.topologyCatalog.get()).getInitComplete().await();
        long startTime = System.nanoTime();
        if (spec instanceof FlowSpec) {
            Map specExecutorInstanceMap = this.specCompiler.compileFlow(spec);
            if (specExecutorInstanceMap.isEmpty()) {
                this._log.warn("Cannot determine an executor to run on for Spec: " + spec);
                return;
            }
            for (Map.Entry specsToExecute : specExecutorInstanceMap.entrySet()) {
                SpecProducer producer = null;
                try {
                    producer = (SpecProducer)((SpecExecutor)specsToExecute.getValue()).getProducer().get();
                    Spec jobSpec = (Spec)specsToExecute.getKey();
                    this._log.info(String.format("Going to orchestrate JobSpec: %s on Executor: %s", jobSpec, producer));
                    producer.addSpec((Object)jobSpec);
                }
                catch (Exception e) {
                    this._log.error("Cannot successfully setup spec: " + specsToExecute.getKey() + " on executor: " + producer + " for flow: " + spec, (Throwable)e);
                }
            }
        } else {
            Instrumented.markMeter(this.flowOrchestrationFailedMeter);
            throw new RuntimeException("Spec not of type FlowSpec, cannot orchestrate: " + spec);
        }
        Instrumented.markMeter(this.flowOrchestrationSuccessFulMeter);
        Instrumented.updateTimer(this.flowOrchestrationTimer, (long)(System.nanoTime() - startTime), (TimeUnit)TimeUnit.NANOSECONDS);
    }

    public void remove(Spec spec) {
        if (spec instanceof FlowSpec) {
            Map specExecutorInstanceMap = this.specCompiler.compileFlow(spec);
            if (specExecutorInstanceMap.isEmpty()) {
                this._log.warn("Cannot determine an executor to delete Spec: " + spec);
                return;
            }
            for (Map.Entry specsToDelete : specExecutorInstanceMap.entrySet()) {
                SpecProducer producer = null;
                try {
                    producer = (SpecProducer)((SpecExecutor)specsToDelete.getValue()).getProducer().get();
                    Spec jobSpec = (Spec)specsToDelete.getKey();
                    this._log.info(String.format("Going to delete JobSpec: %s on Executor: %s", jobSpec, producer));
                    producer.deleteSpec(jobSpec.getUri());
                }
                catch (Exception e) {
                    this._log.error("Cannot successfully delete spec: " + specsToDelete.getKey() + " on executor: " + producer + " for flow: " + spec, (Throwable)e);
                }
            }
        } else {
            throw new RuntimeException("Spec not of type FlowSpec, cannot delete: " + spec);
        }
    }

    @Nonnull
    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    public boolean isInstrumentationEnabled() {
        return null != this.metricContext;
    }

    public List<Tag<?>> generateTags(State state) {
        return Collections.emptyList();
    }

    public void switchMetricContext(List<Tag<?>> tags) {
        throw new UnsupportedOperationException();
    }

    public void switchMetricContext(MetricContext context) {
        throw new UnsupportedOperationException();
    }

    public Optional<Meter> getFlowOrchestrationSuccessFulMeter() {
        return this.flowOrchestrationSuccessFulMeter;
    }

    public Optional<Meter> getFlowOrchestrationFailedMeter() {
        return this.flowOrchestrationFailedMeter;
    }

    public Optional<Timer> getFlowOrchestrationTimer() {
        return this.flowOrchestrationTimer;
    }
}

