/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.avro;

import io.confluent.kafka.schemaregistry.avro.AvroCompatibilityChecker;

public enum AvroCompatibilityLevel {
    NONE("NONE", AvroCompatibilityChecker.NO_OP_CHECKER),
    BACKWARD("BACKWARD", AvroCompatibilityChecker.BACKWARD_CHECKER),
    FORWARD("FORWARD", AvroCompatibilityChecker.FORWARD_CHECKER),
    FULL("FULL", AvroCompatibilityChecker.FULL_CHECKER);

    public final String name;
    public final AvroCompatibilityChecker compatibilityChecker;

    private AvroCompatibilityLevel(String name, AvroCompatibilityChecker compatibilityChecker) {
        this.name = name;
        this.compatibilityChecker = compatibilityChecker;
    }

    public static AvroCompatibilityLevel forName(String name) {
        if (name == null) {
            return null;
        }
        if (AvroCompatibilityLevel.NONE.name.equals(name = name.toUpperCase())) {
            return NONE;
        }
        if (AvroCompatibilityLevel.BACKWARD.name.equals(name)) {
            return BACKWARD;
        }
        if (AvroCompatibilityLevel.FORWARD.name.equals(name)) {
            return FORWARD;
        }
        if (AvroCompatibilityLevel.FULL.name.equals(name)) {
            return FULL;
        }
        return null;
    }
}

