/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.kafka.client;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import com.typesafe.config.Config;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kafka.api.PartitionFetchInfo;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.common.TopicAndPartition;
import kafka.javaapi.FetchRequest;
import kafka.javaapi.FetchResponse;
import kafka.javaapi.OffsetRequest;
import kafka.javaapi.OffsetResponse;
import kafka.javaapi.PartitionMetadata;
import kafka.javaapi.TopicMetadata;
import kafka.javaapi.TopicMetadataRequest;
import kafka.javaapi.consumer.SimpleConsumer;
import kafka.javaapi.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import org.apache.gobblin.kafka.client.AbstractBaseKafkaConsumerClient;
import org.apache.gobblin.kafka.client.BaseKafkaConsumerRecord;
import org.apache.gobblin.kafka.client.ByteArrayBasedKafkaRecord;
import org.apache.gobblin.kafka.client.GobblinKafkaConsumerClient;
import org.apache.gobblin.kafka.client.KafkaConsumerRecord;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaOffsetRetrievalFailureException;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaPartition;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaTopic;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Kafka08ConsumerClient
extends AbstractBaseKafkaConsumerClient {
    private static final Logger log = LoggerFactory.getLogger(Kafka08ConsumerClient.class);
    public static final String CONFIG_PREFIX = "source.kafka.";
    public static final String CONFIG_KAFKA_BUFFER_SIZE_BYTES = "source.kafka.bufferSizeBytes";
    public static final int CONFIG_KAFKA_BUFFER_SIZE_BYTES_DEFAULT = 0x100000;
    public static final String CONFIG_KAFKA_CLIENT_NAME = "source.kafka.clientName";
    public static final String CONFIG_KAFKA_CLIENT_NAME_DEFAULT = "gobblin-kafka";
    public static final String CONFIG_KAFKA_FETCH_REQUEST_CORRELATION_ID = "source.kafka.fetchCorrelationId";
    private static final int CONFIG_KAFKA_FETCH_REQUEST_CORRELATION_ID_DEFAULT = -1;
    public static final String CONFIG_KAFKA_FETCH_TOPIC_NUM_TRIES = "source.kafka.fetchTopicNumTries";
    private static final int CONFIG_KAFKA_FETCH_TOPIC_NUM_TRIES_DEFAULT = 3;
    public static final String CONFIG_KAFKA_FETCH_OFFSET_NUM_TRIES = "source.kafka.fetchOffsetNumTries";
    private static final int CONFIG_KAFKA_FETCH_OFFSET_NUM_TRIES_DEFAULT = 3;
    private final int bufferSize;
    private final String clientName;
    private final int fetchCorrelationId;
    private final int fetchTopicRetries;
    private final int fetchOffsetRetries;
    private final ConcurrentMap<String, SimpleConsumer> activeConsumers = Maps.newConcurrentMap();

    private Kafka08ConsumerClient(Config config) {
        super(config);
        this.bufferSize = ConfigUtils.getInt((Config)config, (String)CONFIG_KAFKA_BUFFER_SIZE_BYTES, (Integer)0x100000);
        this.clientName = ConfigUtils.getString((Config)config, (String)CONFIG_KAFKA_CLIENT_NAME, (String)CONFIG_KAFKA_CLIENT_NAME_DEFAULT);
        this.fetchCorrelationId = ConfigUtils.getInt((Config)config, (String)CONFIG_KAFKA_FETCH_REQUEST_CORRELATION_ID, (Integer)-1);
        this.fetchTopicRetries = ConfigUtils.getInt((Config)config, (String)CONFIG_KAFKA_FETCH_TOPIC_NUM_TRIES, (Integer)3);
        this.fetchOffsetRetries = ConfigUtils.getInt((Config)config, (String)CONFIG_KAFKA_FETCH_OFFSET_NUM_TRIES, (Integer)3);
    }

    public List<KafkaTopic> getTopics() {
        List<TopicMetadata> topicMetadataList = this.getFilteredMetadataList();
        ArrayList filteredTopics = Lists.newArrayList();
        for (TopicMetadata topicMetadata : topicMetadataList) {
            List<KafkaPartition> partitions = this.getPartitionsForTopic(topicMetadata);
            filteredTopics.add(new KafkaTopic(topicMetadata.topic(), partitions));
        }
        return filteredTopics;
    }

    private List<KafkaPartition> getPartitionsForTopic(TopicMetadata topicMetadata) {
        ArrayList partitions = Lists.newArrayList();
        for (PartitionMetadata partitionMetadata : topicMetadata.partitionsMetadata()) {
            if (null == partitionMetadata) {
                log.error("Ignoring topic with null partition metadata " + topicMetadata.topic());
                return Collections.emptyList();
            }
            if (null == partitionMetadata.leader()) {
                log.error("Ignoring topic with null partition leader " + topicMetadata.topic() + " metatada=" + partitionMetadata);
                return Collections.emptyList();
            }
            partitions.add(new KafkaPartition.Builder().withId(partitionMetadata.partitionId()).withTopicName(topicMetadata.topic()).withLeaderId(partitionMetadata.leader().id()).withLeaderHostAndPort(partitionMetadata.leader().host(), partitionMetadata.leader().port()).build());
        }
        return partitions;
    }

    private List<TopicMetadata> getFilteredMetadataList() {
        for (String broker : this.brokers) {
            List<TopicMetadata> filteredTopicMetadataList = this.fetchTopicMetadataFromBroker(broker, new String[0]);
            if (filteredTopicMetadataList == null) continue;
            return filteredTopicMetadataList;
        }
        throw new RuntimeException("Fetching topic metadata from all brokers failed. See log warning for more information.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<TopicMetadata> fetchTopicMetadataFromBroker(String broker, String ... selectedTopics) {
        log.info(String.format("Fetching topic metadata from broker %s", broker));
        try (SimpleConsumer consumer = null;){
            consumer = this.getSimpleConsumer(broker);
            for (int i = 0; i < this.fetchTopicRetries; ++i) {
                try {
                    List list = consumer.send(new TopicMetadataRequest(Arrays.asList(selectedTopics))).topicsMetadata();
                    return list;
                }
                catch (Exception e) {
                    try {
                        log.warn(String.format("Fetching topic metadata from broker %s has failed %d times.", broker, i + 1), (Throwable)e);
                        try {
                            Thread.sleep((long)(((double)i + Math.random()) * 1000.0));
                        }
                        catch (InterruptedException e2) {
                            log.warn("Caught InterruptedException: " + e2);
                        }
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return null;
                    }
                }
            }
        }
    }

    private SimpleConsumer getSimpleConsumer(String broker) {
        if (this.activeConsumers.containsKey(broker)) {
            return (SimpleConsumer)this.activeConsumers.get(broker);
        }
        SimpleConsumer consumer = this.createSimpleConsumer(broker);
        this.activeConsumers.putIfAbsent(broker, consumer);
        return consumer;
    }

    private SimpleConsumer getSimpleConsumer(HostAndPort hostAndPort) {
        return this.getSimpleConsumer(hostAndPort.toString());
    }

    private SimpleConsumer createSimpleConsumer(String broker) {
        List hostPort = Splitter.on((char)':').trimResults().omitEmptyStrings().splitToList((CharSequence)broker);
        return this.createSimpleConsumer((String)hostPort.get(0), Integer.parseInt((String)hostPort.get(1)));
    }

    private SimpleConsumer createSimpleConsumer(String host, int port) {
        return new SimpleConsumer(host, port, this.socketTimeoutMillis, this.bufferSize, this.clientName);
    }

    public long getEarliestOffset(KafkaPartition partition) throws KafkaOffsetRetrievalFailureException {
        Map<TopicAndPartition, PartitionOffsetRequestInfo> offsetRequestInfo = Collections.singletonMap(new TopicAndPartition(partition.getTopicName(), partition.getId()), new PartitionOffsetRequestInfo(kafka.api.OffsetRequest.EarliestTime(), 1));
        return this.getOffset(partition, offsetRequestInfo);
    }

    public long getLatestOffset(KafkaPartition partition) throws KafkaOffsetRetrievalFailureException {
        Map<TopicAndPartition, PartitionOffsetRequestInfo> offsetRequestInfo = Collections.singletonMap(new TopicAndPartition(partition.getTopicName(), partition.getId()), new PartitionOffsetRequestInfo(kafka.api.OffsetRequest.LatestTime(), 1));
        return this.getOffset(partition, offsetRequestInfo);
    }

    private long getOffset(KafkaPartition partition, Map<TopicAndPartition, PartitionOffsetRequestInfo> offsetRequestInfo) throws KafkaOffsetRetrievalFailureException {
        SimpleConsumer consumer = this.getSimpleConsumer(partition.getLeader().getHostAndPort());
        for (int i = 0; i < this.fetchOffsetRetries; ++i) {
            try {
                OffsetResponse offsetResponse = consumer.getOffsetsBefore(new OffsetRequest(offsetRequestInfo, kafka.api.OffsetRequest.CurrentVersion(), this.clientName));
                if (offsetResponse.hasError()) {
                    throw new RuntimeException("offsetReponse has error: " + offsetResponse.errorCode(partition.getTopicName(), partition.getId()));
                }
                return offsetResponse.offsets(partition.getTopicName(), partition.getId())[0];
            }
            catch (Exception e) {
                log.warn(String.format("Fetching offset for partition %s has failed %d time(s). Reason: %s", partition, i + 1, e));
                if (i >= this.fetchOffsetRetries - 1) continue;
                try {
                    Thread.sleep((long)(((double)i + Math.random()) * 1000.0));
                }
                catch (InterruptedException e2) {
                    log.error("Caught interrupted exception between retries of getting latest offsets. " + e2);
                }
                continue;
            }
        }
        throw new KafkaOffsetRetrievalFailureException(String.format("Fetching offset for partition %s has failed.", partition));
    }

    public Iterator<KafkaConsumerRecord> consume(KafkaPartition partition, long nextOffset, long maxOffset) {
        if (nextOffset > maxOffset) {
            return null;
        }
        FetchRequest fetchRequest = this.createFetchRequest(partition, nextOffset);
        try {
            FetchResponse fetchResponse = this.getFetchResponseForFetchRequest(fetchRequest, partition);
            return this.getIteratorFromFetchResponse(fetchResponse, partition);
        }
        catch (Exception e) {
            log.warn(String.format("Fetch message buffer for partition %s has failed: %s. Will refresh topic metadata and retry", partition, e));
            return this.refreshTopicMetadataAndRetryFetch(partition, fetchRequest);
        }
    }

    private synchronized FetchResponse getFetchResponseForFetchRequest(FetchRequest fetchRequest, KafkaPartition partition) {
        SimpleConsumer consumer = this.getSimpleConsumer(partition.getLeader().getHostAndPort());
        FetchResponse fetchResponse = consumer.fetch(fetchRequest);
        if (fetchResponse.hasError()) {
            throw new RuntimeException(String.format("error code %d", fetchResponse.errorCode(partition.getTopicName(), partition.getId())));
        }
        return fetchResponse;
    }

    private Iterator<KafkaConsumerRecord> getIteratorFromFetchResponse(FetchResponse fetchResponse, KafkaPartition partition) {
        try {
            ByteBufferMessageSet messageBuffer = fetchResponse.messageSet(partition.getTopicName(), partition.getId());
            return Iterators.transform((Iterator)messageBuffer.iterator(), (Function)new Function<MessageAndOffset, KafkaConsumerRecord>(){

                public KafkaConsumerRecord apply(MessageAndOffset input) {
                    return new Kafka08ConsumerRecord(input);
                }
            });
        }
        catch (Exception e) {
            log.warn(String.format("Failed to retrieve next message buffer for partition %s: %s.The remainder of this partition will be skipped.", partition, e));
            return null;
        }
    }

    private Iterator<KafkaConsumerRecord> refreshTopicMetadataAndRetryFetch(KafkaPartition partition, FetchRequest fetchRequest) {
        try {
            this.refreshTopicMetadata(partition);
            FetchResponse fetchResponse = this.getFetchResponseForFetchRequest(fetchRequest, partition);
            return this.getIteratorFromFetchResponse(fetchResponse, partition);
        }
        catch (Exception e) {
            log.warn(String.format("Fetch message buffer for partition %s has failed: %s. This partition will be skipped.", partition, e));
            return null;
        }
    }

    private void refreshTopicMetadata(KafkaPartition partition) {
        block0: for (String broker : this.brokers) {
            List<TopicMetadata> topicMetadataList = this.fetchTopicMetadataFromBroker(broker, partition.getTopicName());
            if (topicMetadataList == null || topicMetadataList.isEmpty()) continue;
            TopicMetadata topicMetadata = topicMetadataList.get(0);
            for (PartitionMetadata partitionMetadata : topicMetadata.partitionsMetadata()) {
                if (partitionMetadata.partitionId() != partition.getId()) continue;
                partition.setLeader(partitionMetadata.leader().id(), partitionMetadata.leader().host(), partitionMetadata.leader().port());
                break block0;
            }
        }
    }

    private FetchRequest createFetchRequest(KafkaPartition partition, long nextOffset) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(partition.getTopicName(), partition.getId());
        PartitionFetchInfo partitionFetchInfo = new PartitionFetchInfo(nextOffset, this.bufferSize);
        Map<TopicAndPartition, PartitionFetchInfo> fetchInfo = Collections.singletonMap(topicAndPartition, partitionFetchInfo);
        return new FetchRequest(this.fetchCorrelationId, this.clientName, this.fetchTimeoutMillis, this.fetchMinBytes, fetchInfo);
    }

    public void close() throws IOException {
        int numOfConsumersNotClosed = 0;
        for (SimpleConsumer consumer : this.activeConsumers.values()) {
            if (consumer == null) continue;
            try {
                consumer.close();
            }
            catch (Exception e) {
                log.warn(String.format("Failed to close Kafka Consumer %s:%d", consumer.host(), consumer.port()));
                ++numOfConsumersNotClosed;
            }
        }
        this.activeConsumers.clear();
        if (numOfConsumersNotClosed > 0) {
            throw new IOException(numOfConsumersNotClosed + " consumer(s) failed to close.");
        }
    }

    public static class Kafka08ConsumerRecord
    extends BaseKafkaConsumerRecord
    implements ByteArrayBasedKafkaRecord {
        private final MessageAndOffset messageAndOffset;

        public Kafka08ConsumerRecord(MessageAndOffset messageAndOffset) {
            super(messageAndOffset.offset(), (long)messageAndOffset.message().size());
            this.messageAndOffset = messageAndOffset;
        }

        public byte[] getMessageBytes() {
            return Kafka08ConsumerRecord.getBytes(this.messageAndOffset.message().payload());
        }

        public byte[] getKeyBytes() {
            return Kafka08ConsumerRecord.getBytes(this.messageAndOffset.message().key());
        }

        private static byte[] getBytes(ByteBuffer buf) {
            byte[] bytes = null;
            if (buf != null) {
                int size = buf.remaining();
                bytes = new byte[size];
                buf.get(bytes, buf.position(), size);
            }
            return bytes;
        }
    }

    public static class Factory
    implements GobblinKafkaConsumerClient.GobblinKafkaConsumerClientFactory {
        public GobblinKafkaConsumerClient create(Config config) {
            return new Kafka08ConsumerClient(config);
        }
    }
}

