/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.admin.AdminUtils$;
import kafka.api.FetchResponsePartitionData;
import kafka.api.OffsetRequest$;
import kafka.cluster.Broker;
import kafka.cluster.Replica;
import kafka.common.KafkaStorageException;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.message.ByteBufferMessageSet;
import kafka.server.AbstractFetcherThread;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001\u000f\t!\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012T!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI\"IQ\u0002\u0001B\u0001B\u0003%a\u0002G\u0001\u0005]\u0006lW\r\u0005\u0002\u0010+9\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\u00051\u0001K]3eK\u001aL!AF\f\u0003\rM#(/\u001b8h\u0015\t!\u0012#\u0003\u0002\u000e3%\u0011!d\u0007\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fGM\u0003\u0002\u001d\t\u0005)Q\u000f^5mg\"Aa\u0004\u0001B\u0001B\u0003%q$\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002!G5\t\u0011E\u0003\u0002#\t\u000591\r\\;ti\u0016\u0014\u0018B\u0001\u0013\"\u0005\u0019\u0011%o\\6fe\"Aa\u0005\u0001B\u0001B\u0003%q%\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u0002\nQ%\u0011\u0011F\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0003\u00135J!A\f\u0002\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\")\u0001\u0007\u0001C\u0001c\u00051A(\u001b8jiz\"RAM\u001a5kY\u0002\"!\u0003\u0001\t\u000b5y\u0003\u0019\u0001\b\t\u000byy\u0003\u0019A\u0010\t\u000b\u0019z\u0003\u0019A\u0014\t\u000b-z\u0003\u0019\u0001\u0017\t\u000ba\u0002A\u0011A\u001d\u0002)A\u0014xnY3tgB\u000b'\u000f^5uS>tG)\u0019;b)\u0011QT(\u0012&\u0011\u0005AY\u0014B\u0001\u001f\u0012\u0005\u0011)f.\u001b;\t\u000by:\u0004\u0019A \u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002A\u00076\t\u0011I\u0003\u0002C\t\u000511m\\7n_:L!\u0001R!\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0003Go\u0001\u0007q)A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bC\u0001\tI\u0013\tI\u0015C\u0001\u0003M_:<\u0007\"B&8\u0001\u0004a\u0015!\u00049beRLG/[8o\t\u0006$\u0018\r\u0005\u0002N!6\taJ\u0003\u0002P\t\u0005\u0019\u0011\r]5\n\u0005Es%A\u0007$fi\u000eD'+Z:q_:\u001cX\rU1si&$\u0018n\u001c8ECR\f\u0007\"B*\u0001\t\u0003!\u0016A\u00065b]\u0012dWm\u00144gg\u0016$x*\u001e;PMJ\u000bgnZ3\u0015\u0005\u001d+\u0006\"\u0002 S\u0001\u0004y\u0004\"B,\u0001\t\u0003A\u0016A\u00075b]\u0012dW\rU1si&$\u0018n\u001c8t/&$\b.\u0012:s_J\u001cHC\u0001\u001eZ\u0011\u0015Qf\u000b1\u0001\\\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u00049\u0012|dBA/c\u001d\tq\u0016-D\u0001`\u0015\t\u0001g!\u0001\u0004=e>|GOP\u0005\u0002%%\u00111-E\u0001\ba\u0006\u001c7.Y4f\u0013\t)gM\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\t\u0019\u0017\u0003")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    public final Broker kafka$server$ReplicaFetcherThread$$sourceBroker;
    public final KafkaConfig kafka$server$ReplicaFetcherThread$$brokerConfig;
    private final ReplicaManager replicaMgr;

    @Override
    public void processPartitionData(TopicAndPartition topicAndPartition, long fetchOffset, FetchResponsePartitionData partitionData) {
        try {
            String topic = topicAndPartition.topic();
            int partitionId = topicAndPartition.partition();
            Replica replica = (Replica)this.replicaMgr.getReplica(topic, partitionId, this.replicaMgr.getReplica$default$3()).get();
            ByteBufferMessageSet messageSet = (ByteBufferMessageSet)partitionData.messages();
            if (fetchOffset != replica.logEndOffset().messageOffset()) {
                throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset())})));
            }
            this.trace((Function0<String>)new Serializable(this, topicAndPartition, partitionData, replica, messageSet){
                public static final long serialVersionUID = 0L;
                private final TopicAndPartition topicAndPartition$1;
                private final FetchResponsePartitionData partitionData$1;
                private final Replica replica$1;
                private final ByteBufferMessageSet messageSet$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Follower %d has replica log end offset %d for partition %s. Received %d messages and leader hw %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replica$1.brokerId()), BoxesRunTime.boxToLong((long)this.replica$1.logEndOffset().messageOffset()), this.topicAndPartition$1, BoxesRunTime.boxToInteger((int)this.messageSet$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.partitionData$1.hw())}));
                }
                {
                    this.topicAndPartition$1 = topicAndPartition$1;
                    this.partitionData$1 = partitionData$1;
                    this.replica$1 = replica$1;
                    this.messageSet$1 = messageSet$1;
                }
            });
            ((Log)replica.log().get()).append(messageSet, false);
            this.trace((Function0<String>)new Serializable(this, topicAndPartition, replica, messageSet){
                public static final long serialVersionUID = 0L;
                private final TopicAndPartition topicAndPartition$1;
                private final Replica replica$1;
                private final ByteBufferMessageSet messageSet$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Follower %d has replica log end offset %d after appending %d bytes of messages for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replica$1.brokerId()), BoxesRunTime.boxToLong((long)this.replica$1.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger((int)this.messageSet$1.sizeInBytes()), this.topicAndPartition$1}));
                }
                {
                    this.topicAndPartition$1 = topicAndPartition$1;
                    this.replica$1 = replica$1;
                    this.messageSet$1 = messageSet$1;
                }
            });
            long followerHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(replica.logEndOffset().messageOffset()), partitionData.hw());
            replica.highWatermark_$eq(new LogOffsetMetadata(followerHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            this.trace((Function0<String>)new Serializable(this, topic, partitionId, replica, followerHighWatermark){
                public static final long serialVersionUID = 0L;
                private final String topic$1;
                private final int partitionId$1;
                private final Replica replica$1;
                private final long followerHighWatermark$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Follower %d set replica high watermark for partition [%s,%d] to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replica$1.brokerId()), this.topic$1, BoxesRunTime.boxToInteger((int)this.partitionId$1), BoxesRunTime.boxToLong((long)this.followerHighWatermark$1)}));
                }
                {
                    this.topic$1 = topic$1;
                    this.partitionId$1 = partitionId$1;
                    this.replica$1 = replica$1;
                    this.followerHighWatermark$1 = followerHighWatermark$1;
                }
            });
        }
        catch (KafkaStorageException kafkaStorageException) {
            this.fatal((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Disk error while replicating data.";
                }
            }, (Function0<Throwable>)new Serializable(this, kafkaStorageException){
                public static final long serialVersionUID = 0L;
                private final KafkaStorageException e$1;

                public final KafkaStorageException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            Runtime.getRuntime().halt(1);
        }
    }

    @Override
    public long handleOffsetOutOfRange(TopicAndPartition topicAndPartition) {
        long l;
        Replica replica = (Replica)this.replicaMgr.getReplica(topicAndPartition.topic(), topicAndPartition.partition(), this.replicaMgr.getReplica$default$3()).get();
        long leaderEndOffset = this.simpleConsumer().earliestOrLatestOffset(topicAndPartition, OffsetRequest$.MODULE$.LatestTime(), this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId());
        if (leaderEndOffset < replica.logEndOffset().messageOffset()) {
            if (!LogConfig$.MODULE$.fromProps(this.kafka$server$ReplicaFetcherThread$$brokerConfig.props().props(), AdminUtils$.MODULE$.fetchTopicConfig(this.replicaMgr.zkClient(), topicAndPartition.topic())).uncleanLeaderElectionEnable()) {
                this.fatal((Function0<String>)new Serializable(this, topicAndPartition, replica, leaderEndOffset){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaFetcherThread $outer;
                    private final TopicAndPartition topicAndPartition$2;
                    private final Replica replica$2;
                    private final long leaderEndOffset$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Halting because log truncation is not allowed for topic %s,")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$2.topic()}))).append((Object)new StringOps(Predef$.MODULE$.augmentString(" Current leader %d's latest offset %d is less than replica %d's latest offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$sourceBroker.id()), BoxesRunTime.boxToLong((long)this.leaderEndOffset$1), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId()), BoxesRunTime.boxToLong((long)this.replica$2.logEndOffset().messageOffset())}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topicAndPartition$2 = topicAndPartition$2;
                        this.replica$2 = replica$2;
                        this.leaderEndOffset$1 = leaderEndOffset$1;
                    }
                });
                Runtime.getRuntime().halt(1);
            }
            this.replicaMgr.logManager().truncateTo((Map<TopicAndPartition, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)BoxesRunTime.boxToLong((long)leaderEndOffset))}))));
            this.warn((Function0<String>)new Serializable(this, topicAndPartition, replica, leaderEndOffset){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaFetcherThread $outer;
                private final TopicAndPartition topicAndPartition$2;
                private final Replica replica$2;
                private final long leaderEndOffset$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Replica %d for partition %s reset its fetch offset from %d to current leader %d's latest offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId()), this.topicAndPartition$2, BoxesRunTime.boxToLong((long)this.replica$2.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$sourceBroker.id()), BoxesRunTime.boxToLong((long)this.leaderEndOffset$1)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topicAndPartition$2 = topicAndPartition$2;
                    this.replica$2 = replica$2;
                    this.leaderEndOffset$1 = leaderEndOffset$1;
                }
            });
            l = leaderEndOffset;
        } else {
            long leaderStartOffset = this.simpleConsumer().earliestOrLatestOffset(topicAndPartition, OffsetRequest$.MODULE$.EarliestTime(), this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId());
            this.replicaMgr.logManager().truncateFullyAndStartAt(topicAndPartition, leaderStartOffset);
            this.warn((Function0<String>)new Serializable(this, topicAndPartition, replica, leaderStartOffset){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaFetcherThread $outer;
                private final TopicAndPartition topicAndPartition$2;
                private final Replica replica$2;
                private final long leaderStartOffset$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Replica %d for partition %s reset its fetch offset from %d to current leader %d's start offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId()), this.topicAndPartition$2, BoxesRunTime.boxToLong((long)this.replica$2.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$sourceBroker.id()), BoxesRunTime.boxToLong((long)this.leaderStartOffset$1)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topicAndPartition$2 = topicAndPartition$2;
                    this.replica$2 = replica$2;
                    this.leaderStartOffset$1 = leaderStartOffset$1;
                }
            });
            l = leaderStartOffset;
        }
        return l;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicAndPartition> partitions) {
    }

    public ReplicaFetcherThread(String name, Broker sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaMgr) {
        this.kafka$server$ReplicaFetcherThread$$sourceBroker = sourceBroker;
        this.kafka$server$ReplicaFetcherThread$$brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        super(name, name, sourceBroker, brokerConfig.replicaSocketTimeoutMs(), brokerConfig.replicaSocketReceiveBufferBytes(), brokerConfig.replicaFetchMaxBytes(), brokerConfig.brokerId(), brokerConfig.replicaFetchWaitMaxMs(), brokerConfig.replicaFetchMinBytes(), false);
    }
}

