/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression;

import com.linkedin.r2.filter.compression.CompressionException;
import com.linkedin.r2.filter.compression.EncodingType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AcceptEncoding
implements Comparable<AcceptEncoding> {
    private final EncodingType _type;
    private final float _quality;

    public AcceptEncoding(EncodingType type, float quality) {
        this._type = type;
        this._quality = quality;
    }

    public float getQuality() {
        return this._quality;
    }

    public EncodingType getType() {
        return this._type;
    }

    public static EncodingType[] parseAcceptEncoding(String acceptCompression) {
        if (acceptCompression.trim().isEmpty()) {
            return new EncodingType[0];
        }
        String[] entries = acceptCompression.toLowerCase().split(",");
        EncodingType[] types = new EncodingType[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            types[i] = EncodingType.get(entries[i].trim());
        }
        return types;
    }

    public static List<AcceptEncoding> parseAcceptEncodingHeader(String headerValue, Set<EncodingType> supportedEncodings) throws CompressionException {
        headerValue = headerValue.toLowerCase();
        String[] entries = headerValue.split(",");
        ArrayList<AcceptEncoding> parsedEncodings = new ArrayList<AcceptEncoding>();
        for (String entry : entries) {
            String[] content = entry.trim().split(";");
            if (content.length < 1 || content.length > 2) {
                throw new IllegalArgumentException("Illegal format in Accept-Encoding: " + entry);
            }
            EncodingType type = null;
            String encodingName = content[0].trim();
            if (EncodingType.isSupported(encodingName)) {
                type = EncodingType.get(encodingName);
            }
            Float quality = Float.valueOf(1.0f);
            if (type == null || !supportedEncodings.contains((Object)type)) continue;
            if (content.length > 1) {
                String acceptEncodingPart = content[1].trim();
                if (acceptEncodingPart.startsWith("q=")) {
                    try {
                        quality = Float.valueOf(Float.parseFloat(acceptEncodingPart.substring("q=".length())));
                    }
                    catch (NumberFormatException e) {
                        throw new CompressionException("Illegal format in Accept-Encoding: " + entry, e);
                    }
                } else {
                    throw new CompressionException("Illegal format in Accept-Encoding: " + entry);
                }
            }
            parsedEncodings.add(new AcceptEncoding(type, quality.floatValue()));
        }
        return parsedEncodings;
    }

    public static EncodingType chooseBest(List<AcceptEncoding> entries) {
        Collections.sort(entries);
        HashSet<EncodingType> bannedEncoding = new HashSet<EncodingType>();
        for (int lastEntry = entries.size() - 1; lastEntry >= 0 && (double)entries.get(lastEntry).getQuality() <= 0.0; --lastEntry) {
            AcceptEncoding removed = entries.remove(lastEntry);
            bannedEncoding.add(removed.getType());
        }
        for (AcceptEncoding type : entries) {
            if (type.getType() == EncodingType.ANY) {
                if (bannedEncoding.contains((Object)EncodingType.IDENTITY)) continue;
                return EncodingType.IDENTITY;
            }
            return type.getType();
        }
        return bannedEncoding.contains((Object)EncodingType.ANY) || bannedEncoding.contains((Object)EncodingType.IDENTITY) ? null : EncodingType.IDENTITY;
    }

    @Override
    public int compareTo(AcceptEncoding target) {
        return new Float(target.getQuality()).compareTo(Float.valueOf(this.getQuality()));
    }
}

