/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression;

import com.linkedin.r2.filter.compression.CompressionException;
import com.linkedin.r2.filter.compression.Compressor;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.iq80.snappy.Snappy;

public class SnappyCompressor
implements Compressor {
    private static final String HTTP_NAME = "snappy";

    @Override
    public String getContentEncodingName() {
        return HTTP_NAME;
    }

    @Override
    public byte[] inflate(InputStream data) throws CompressionException {
        try {
            byte[] temp = IOUtils.toByteArray((InputStream)data);
            return Snappy.uncompress((byte[])temp, (int)0, (int)temp.length);
        }
        catch (IOException e) {
            throw new CompressionException("Cannot properly decode stream: " + this.getContentEncodingName(), e);
        }
    }

    @Override
    public byte[] deflate(InputStream data) throws CompressionException {
        try {
            byte[] temp = IOUtils.toByteArray((InputStream)data);
            return Snappy.compress((byte[])temp);
        }
        catch (IOException e) {
            throw new CompressionException("Cannot properly decode stream: " + this.getContentEncodingName(), e);
        }
    }
}

