/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.avro;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.EmptyIterable;
import org.apache.gobblin.converter.avro.UnsupportedDateTypeException;
import org.apache.gobblin.converter.json.JsonSchema;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.util.calendar.ZoneInfo;

public class JsonElementConversionFactory {
    public static JsonElementConverter getConvertor(JsonSchema schemaNode, String namespace, WorkUnitState state) throws UnsupportedDateTypeException {
        Type type = schemaNode.getType();
        DateTimeZone timeZone = JsonElementConversionFactory.getTimeZone(state.getProp("converter.avro.date.timezone", "UTC"));
        switch (type) {
            case DATE: {
                return new DateConverter(schemaNode, state.getProp("converter.avro.date.format", "yyyy-MM-dd HH:mm:ss"), timeZone, state);
            }
            case TIMESTAMP: {
                return new DateConverter(schemaNode, state.getProp("converter.avro.timestamp.format", "yyyy-MM-dd HH:mm:ss"), timeZone, state);
            }
            case TIME: {
                return new DateConverter(schemaNode, state.getProp("converter.avro.time.format", "HH:mm:ss"), timeZone, state);
            }
            case FIXED: {
                throw new UnsupportedDateTypeException(type.toString() + " is unsupported");
            }
            case STRING: {
                return new StringConverter(schemaNode);
            }
            case BYTES: {
                return new BinaryConverter(schemaNode, state.getProp("converter.avro.binary.charset", "UTF8"));
            }
            case INT: {
                return new IntConverter(schemaNode);
            }
            case LONG: {
                return new LongConverter(schemaNode);
            }
            case FLOAT: {
                return new FloatConverter(schemaNode);
            }
            case DOUBLE: {
                return new DoubleConverter(schemaNode);
            }
            case BOOLEAN: {
                return new BooleanConverter(schemaNode);
            }
            case ARRAY: {
                return new ArrayConverter(schemaNode, state);
            }
            case MAP: {
                return new MapConverter(schemaNode, state);
            }
            case ENUM: {
                return new EnumConverter(schemaNode, namespace);
            }
            case RECORD: {
                return new RecordConverter(schemaNode, state, namespace);
            }
            case NULL: {
                return new NullConverter(schemaNode);
            }
            case UNION: {
                return new UnionConverter(schemaNode, state);
            }
        }
        throw new UnsupportedDateTypeException(type.toString() + " is unsupported");
    }

    public static JsonElementConverter getConvertor(String fieldName, String fieldType, JsonObject schemaNode, WorkUnitState state, boolean nullable) throws UnsupportedDateTypeException {
        JsonObject dataType;
        if (!schemaNode.has("columnName")) {
            schemaNode.addProperty("columnName", fieldName);
        }
        if (!schemaNode.has("dataType")) {
            schemaNode.add("dataType", (JsonElement)new JsonObject());
        }
        if (!(dataType = schemaNode.get("dataType").getAsJsonObject()).has("type")) {
            dataType.addProperty("type", fieldType);
        }
        if (!schemaNode.has("isNullable")) {
            schemaNode.addProperty("isNullable", Boolean.valueOf(nullable));
        }
        JsonSchema schema = new JsonSchema(schemaNode);
        return JsonElementConversionFactory.getConvertor(schema, null, state);
    }

    private static DateTimeZone getTimeZone(String id) {
        DateTimeZone zone;
        try {
            zone = DateTimeZone.forID((String)id);
        }
        catch (IllegalArgumentException e) {
            TimeZone timeZone = ZoneInfo.getTimeZone(id);
            if (timeZone == null) {
                throw new IllegalArgumentException("TimeZone " + id + " not recognized");
            }
            zone = DateTimeZone.forTimeZone((TimeZone)timeZone);
        }
        return zone;
    }

    public static class UnionConverter
    extends JsonElementConverter {
        private final Schema firstSchema;
        private final Schema secondSchema;
        private final JsonElementConverter firstConverter;
        private final JsonElementConverter secondConverter;

        public UnionConverter(JsonSchema schemaNode, WorkUnitState state) {
            super(schemaNode);
            List<JsonSchema> types = schemaNode.getDataTypes();
            this.firstConverter = this.getConverter(types.get(0), state);
            this.secondConverter = this.getConverter(types.get(1), state);
            this.firstSchema = this.firstConverter.schema();
            this.secondSchema = this.secondConverter.schema();
        }

        private JsonElementConverter getConverter(JsonSchema schemaElement, WorkUnitState state) {
            try {
                return JsonElementConversionFactory.getConvertor(schemaElement, null, state);
            }
            catch (UnsupportedDateTypeException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        Object convertField(JsonElement value) {
            try {
                return this.firstConverter.convert(value);
            }
            catch (Exception e) {
                return this.secondConverter.convert(value);
            }
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.UNION;
        }

        @Override
        protected Schema schema() {
            return Schema.createUnion(Arrays.asList(this.firstSchema, this.secondSchema));
        }
    }

    public static class NullConverter
    extends JsonElementConverter {
        public NullConverter(JsonSchema schema) {
            super(schema);
        }

        @Override
        Object convertField(JsonElement value) {
            return value.getAsJsonNull();
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.NULL;
        }
    }

    public static class EnumConverter
    extends JsonElementConverter {
        String enumName;
        String namespace;
        List<String> enumSet = new ArrayList<String>();
        Schema schema;

        public EnumConverter(JsonSchema schema, String namespace) {
            super(schema);
            JsonObject dataType = schema.getDataType();
            for (JsonElement elem : dataType.get("symbols").getAsJsonArray()) {
                this.enumSet.add(elem.getAsString());
            }
            String enumName = schema.getName();
            this.enumName = enumName.isEmpty() ? null : enumName;
            this.namespace = namespace;
        }

        @Override
        Object convertField(JsonElement value) {
            return new GenericData.EnumSymbol(this.schema, value.getAsString());
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.ENUM;
        }

        @Override
        public Schema schema() {
            this.schema = Schema.createEnum((String)this.enumName, (String)"", (String)this.namespace, this.enumSet);
            this.schema.addProp("source.type", Type.ENUM.toString().toLowerCase());
            return this.buildUnionIfNullable(this.schema);
        }
    }

    public static class RecordConverter
    extends ComplexConverter {
        private static final java.util.logging.Logger log = java.util.logging.Logger.getLogger(RecordConverter.class.getName());
        private static final Logger LOG = LoggerFactory.getLogger(RecordConverter.class);
        private HashMap<String, JsonElementConverter> converters = new HashMap();
        private Schema _schema;
        private long numFailedConversion = 0L;
        private State workUnit;

        public RecordConverter(JsonSchema schema, WorkUnitState state, String namespace) throws UnsupportedDateTypeException {
            super(schema);
            this.workUnit = state;
            String name = schema.isRoot() ? schema.getColumnName() : schema.getName();
            this._schema = this.buildRecordSchema(schema.getValuesWithinDataType(), state, name, namespace);
        }

        private Schema buildRecordSchema(JsonSchema schema, WorkUnitState workUnit, String name, String namespace) {
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
            for (int i = 0; i < schema.fieldsCount(); ++i) {
                Schema fldSchema;
                String sourceType;
                JsonSchema map = schema.getFieldSchemaAt(i);
                String childNamespace = RecordConverter.buildNamespace(namespace, name);
                try {
                    sourceType = map.isType(Type.UNION) ? Type.UNION.toString().toLowerCase() : map.getType().toString().toLowerCase();
                    JsonElementConverter converter = JsonElementConversionFactory.getConvertor(map, childNamespace, workUnit);
                    this.converters.put(map.getColumnName(), converter);
                    fldSchema = converter.schema();
                }
                catch (UnsupportedDateTypeException e) {
                    throw new UnsupportedOperationException(e);
                }
                Schema.Field fld = new Schema.Field(map.getColumnName(), fldSchema, map.getComment(), (JsonNode)(map.isNullable() ? JsonNodeFactory.instance.nullNode() : null));
                fld.addProp("source.type", sourceType);
                fields.add(fld);
            }
            Schema avroSchema = Schema.createRecord((String)(name.isEmpty() ? null : name), (String)"", (String)namespace, (boolean)false);
            avroSchema.setFields(fields);
            return avroSchema;
        }

        @Override
        Object convertField(JsonElement value) {
            GenericData.Record avroRecord = new GenericData.Record(this._schema);
            long maxFailedConversions = this.workUnit.getPropAsLong("converter.avro.max.conversion.failures", 0L);
            for (Map.Entry entry : ((JsonObject)value).entrySet()) {
                try {
                    avroRecord.put((String)entry.getKey(), this.converters.get(entry.getKey()).convert((JsonElement)entry.getValue()));
                }
                catch (Exception e) {
                    ++this.numFailedConversion;
                    if (this.numFailedConversion < maxFailedConversions) {
                        LOG.error("Dropping record " + value + " because it cannot be converted to Avro", (Throwable)e);
                        return new EmptyIterable();
                    }
                    throw new RuntimeException("Unable to convert field:" + (String)entry.getKey() + " for value:" + entry.getValue() + " for record: " + value, e);
                }
            }
            return avroRecord;
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.RECORD;
        }

        @Override
        public Schema schema() {
            Schema schema = this._schema;
            schema.addProp("source.type", Type.RECORD.toString().toLowerCase());
            return this.buildUnionIfNullable(schema);
        }
    }

    public static class MapConverter
    extends ComplexConverter {
        public MapConverter(JsonSchema schema, WorkUnitState state) throws UnsupportedDateTypeException {
            super(schema);
            this.processNestedItems(schema, state);
        }

        @Override
        Object convertField(JsonElement value) {
            HashMap map = new HashMap();
            for (Map.Entry entry : ((JsonObject)value).entrySet()) {
                map.put(entry.getKey(), this.getElementConverter().convertField((JsonElement)entry.getValue()));
            }
            return map;
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.MAP;
        }

        @Override
        public Schema schema() {
            Schema schema = Schema.createMap((Schema)this.getElementConverter().schema());
            schema.addProp("source.type", Type.MAP.toString().toLowerCase());
            return this.buildUnionIfNullable(schema);
        }
    }

    public static class ArrayConverter
    extends ComplexConverter {
        public ArrayConverter(JsonSchema schema, WorkUnitState state) throws UnsupportedDateTypeException {
            super(schema);
            this.processNestedItems(schema, state);
        }

        @Override
        Object convertField(JsonElement value) {
            if (this.isNullable() && value.isJsonNull()) {
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonElement elem : (JsonArray)value) {
                list.add(this.getElementConverter().convertField(elem));
            }
            return new GenericData.Array(this.arraySchema(), list);
        }

        private Schema arraySchema() {
            Schema schema = Schema.createArray((Schema)this.getElementConverter().schema());
            schema.addProp("source.type", Type.ARRAY.toString().toLowerCase());
            return schema;
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.ARRAY;
        }

        @Override
        public Schema schema() {
            return this.buildUnionIfNullable(this.arraySchema());
        }
    }

    public static abstract class ComplexConverter
    extends JsonElementConverter {
        private JsonElementConverter elementConverter;

        public ComplexConverter(JsonSchema schema) {
            super(schema);
        }

        public ComplexConverter(String fieldName, boolean nullable, String sourceType) {
            super(fieldName, nullable, sourceType);
        }

        protected void setElementConverter(JsonElementConverter elementConverter) {
            this.elementConverter = elementConverter;
        }

        public JsonElementConverter getElementConverter() {
            return this.elementConverter;
        }

        protected void processNestedItems(JsonSchema schema, WorkUnitState state) throws UnsupportedDateTypeException {
            JsonSchema nestedItem = null;
            if (schema.isType(Type.ARRAY)) {
                nestedItem = schema.getItemsWithinDataType();
            }
            if (schema.isType(Type.MAP)) {
                nestedItem = schema.getValuesWithinDataType();
            }
            this.setElementConverter(JsonElementConversionFactory.getConvertor(nestedItem, null, state));
        }
    }

    public static class BinaryConverter
    extends JsonElementConverter {
        private String charSet;

        public BinaryConverter(JsonSchema schema, String charSet) {
            super(schema);
            this.charSet = charSet;
        }

        @Override
        Object convertField(JsonElement value) {
            try {
                return ByteBuffer.wrap(value.getAsString().getBytes(this.charSet));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.BYTES;
        }
    }

    public static class DateConverter
    extends JsonElementConverter {
        private String inputPatterns;
        private DateTimeZone timeZone;
        private WorkUnitState state;

        public DateConverter(JsonSchema schema, String pattern, DateTimeZone zone, WorkUnitState state) {
            super(schema);
            this.inputPatterns = pattern;
            this.timeZone = zone;
            this.state = state;
        }

        @Override
        Object convertField(JsonElement value) {
            List<String> patterns = Arrays.asList(this.inputPatterns.split(","));
            int patternFailCount = 0;
            Long formattedDate = null;
            for (String pattern : patterns) {
                DateTimeFormatter dtf = DateTimeFormat.forPattern((String)pattern).withZone(this.timeZone);
                try {
                    formattedDate = dtf.parseDateTime(value.getAsString()).withZone(DateTimeZone.forID((String)"UTC")).getMillis();
                    if (!Boolean.valueOf(this.state.getProp("converter.is.epoch.time.in.seconds")).booleanValue()) break;
                    formattedDate = formattedDate / 1000L;
                    break;
                }
                catch (Exception e) {
                    ++patternFailCount;
                }
            }
            if (patternFailCount == patterns.size()) {
                throw new RuntimeException("Failed to parse the date");
            }
            return formattedDate;
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.LONG;
        }
    }

    public static class BooleanConverter
    extends JsonElementConverter {
        public BooleanConverter(JsonSchema schema) {
            super(schema);
        }

        @Override
        Object convertField(JsonElement value) {
            return value.getAsBoolean();
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.BOOLEAN;
        }
    }

    public static class FloatConverter
    extends JsonElementConverter {
        public FloatConverter(JsonSchema schema) {
            super(schema);
        }

        @Override
        Object convertField(JsonElement value) {
            return Float.valueOf(value.getAsFloat());
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.FLOAT;
        }
    }

    public static class DoubleConverter
    extends JsonElementConverter {
        public DoubleConverter(JsonSchema schema) {
            super(schema);
        }

        @Override
        Object convertField(JsonElement value) {
            return value.getAsDouble();
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.DOUBLE;
        }
    }

    public static class LongConverter
    extends JsonElementConverter {
        public LongConverter(JsonSchema schema) {
            super(schema);
        }

        @Override
        Object convertField(JsonElement value) {
            return value.getAsLong();
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.LONG;
        }
    }

    public static class IntConverter
    extends JsonElementConverter {
        public IntConverter(JsonSchema schema) {
            super(schema);
        }

        @Override
        Object convertField(JsonElement value) {
            return value.getAsInt();
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.INT;
        }
    }

    public static class StringConverter
    extends JsonElementConverter {
        public StringConverter(JsonSchema schema) {
            super(schema);
        }

        @Override
        Object convertField(JsonElement value) {
            return new Utf8(value.getAsString());
        }

        @Override
        public Schema.Type getTargetType() {
            return Schema.Type.STRING;
        }
    }

    public static abstract class JsonElementConverter {
        private final JsonSchema jsonSchema;

        public JsonElementConverter(JsonSchema jsonSchema) {
            this.jsonSchema = jsonSchema;
        }

        public JsonElementConverter(String fieldName, boolean nullable, String sourceType) {
            JsonSchema jsonSchema = JsonSchema.buildBaseSchema(Type.valueOf(sourceType.toUpperCase()));
            jsonSchema.setColumnName(fieldName);
            jsonSchema.setNullable(nullable);
            this.jsonSchema = jsonSchema;
        }

        public String getName() {
            return this.jsonSchema.getColumnName();
        }

        public boolean isNullable() {
            return this.jsonSchema.isNullable();
        }

        public Schema getSchema() {
            if (this.isNullable()) {
                ArrayList<Schema> list = new ArrayList<Schema>();
                list.add(Schema.create((Schema.Type)Schema.Type.NULL));
                list.add(this.schema());
                return Schema.createUnion(list);
            }
            return this.schema();
        }

        protected Schema schema() {
            Schema schema = Schema.create((Schema.Type)this.getTargetType());
            schema.addProp("source.type", this.jsonSchema.getType().toString().toLowerCase());
            return this.buildUnionIfNullable(schema);
        }

        public Object convert(JsonElement value) {
            if (value.isJsonNull()) {
                if (this.isNullable()) {
                    return null;
                }
                throw new RuntimeException("Field: " + this.getName() + " is not nullable and contains a null value");
            }
            return this.convertField(value);
        }

        abstract Object convertField(JsonElement var1);

        public abstract Schema.Type getTargetType();

        protected static String buildNamespace(String namespace, String name) {
            if (namespace == null || namespace.isEmpty()) {
                return null;
            }
            if (name == null || name.isEmpty()) {
                return null;
            }
            return namespace.trim() + "." + name.trim();
        }

        protected Schema buildUnionIfNullable(Schema schema) {
            if (this.isNullable()) {
                return Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), schema));
            }
            return schema;
        }
    }

    public static enum Type {
        DATE,
        TIMESTAMP,
        TIME,
        FIXED,
        STRING,
        BYTES,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN,
        ARRAY,
        MAP,
        ENUM,
        RECORD,
        NULL,
        UNION;

        private static List<Type> primitiveTypes;

        public static boolean isPrimitive(Type type) {
            return primitiveTypes.contains((Object)type);
        }

        static {
            primitiveTypes = Arrays.asList(NULL, BOOLEAN, INT, LONG, FLOAT, DOUBLE, BYTES, STRING, ENUM, FIXED);
        }
    }
}

