/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.json;

import com.google.common.base.Charsets;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;

public class BytesToJsonConverter
extends Converter<String, String, byte[], JsonObject> {
    public String convertSchema(String inputSchema, WorkUnitState workUnit) {
        return inputSchema;
    }

    public Iterable<JsonObject> convertRecord(String outputSchema, byte[] inputRecord, WorkUnitState workUnit) throws DataConversionException {
        if (inputRecord == null) {
            throw new DataConversionException("Input record is null");
        }
        String jsonString = new String(inputRecord, Charsets.UTF_8);
        JsonParser parser = new JsonParser();
        JsonObject outputRecord = parser.parse(jsonString).getAsJsonObject();
        return new SingleRecordIterable((Object)outputRecord);
    }
}

