/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Evolving
@InterfaceAudience.Public
public class CacheDirectiveStats {
    private final long bytesNeeded;
    private final long bytesCached;
    private final long filesNeeded;
    private final long filesCached;
    private final boolean hasExpired;

    private CacheDirectiveStats(long bytesNeeded, long bytesCached, long filesNeeded, long filesCached, boolean hasExpired) {
        this.bytesNeeded = bytesNeeded;
        this.bytesCached = bytesCached;
        this.filesNeeded = filesNeeded;
        this.filesCached = filesCached;
        this.hasExpired = hasExpired;
    }

    public long getBytesNeeded() {
        return this.bytesNeeded;
    }

    public long getBytesCached() {
        return this.bytesCached;
    }

    public long getFilesNeeded() {
        return this.filesNeeded;
    }

    public long getFilesCached() {
        return this.filesCached;
    }

    public boolean hasExpired() {
        return this.hasExpired;
    }

    public String toString() {
        return "{bytesNeeded: " + this.bytesNeeded + ", " + "bytesCached: " + this.bytesCached + ", " + "filesNeeded: " + this.filesNeeded + ", " + "filesCached: " + this.filesCached + ", " + "hasExpired: " + this.hasExpired + "}";
    }

    public static class Builder {
        private long bytesNeeded;
        private long bytesCached;
        private long filesNeeded;
        private long filesCached;
        private boolean hasExpired;

        public CacheDirectiveStats build() {
            return new CacheDirectiveStats(this.bytesNeeded, this.bytesCached, this.filesNeeded, this.filesCached, this.hasExpired);
        }

        public Builder setBytesNeeded(long bytesNeeded) {
            this.bytesNeeded = bytesNeeded;
            return this;
        }

        public Builder setBytesCached(long bytesCached) {
            this.bytesCached = bytesCached;
            return this;
        }

        public Builder setFilesNeeded(long filesNeeded) {
            this.filesNeeded = filesNeeded;
            return this;
        }

        public Builder setFilesCached(long filesCached) {
            this.filesCached = filesCached;
            return this;
        }

        public Builder setHasExpired(boolean hasExpired) {
            this.hasExpired = hasExpired;
            return this;
        }
    }
}

