/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma.transactionalobjects;

import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.LockMode;
import org.multiverse.api.Txn;
import org.multiverse.api.TxnThreadLocal;
import org.multiverse.api.exceptions.LockedException;
import org.multiverse.api.functions.Function;
import org.multiverse.api.predicates.Predicate;
import org.multiverse.api.references.TxnRef;
import org.multiverse.stms.gamma.GammaStm;
import org.multiverse.stms.gamma.GammaStmUtils;
import org.multiverse.stms.gamma.Listeners;
import org.multiverse.stms.gamma.ThreadLocalGammaObjectPool;
import org.multiverse.stms.gamma.transactionalobjects.BaseGammaTxnRef;
import org.multiverse.stms.gamma.transactionalobjects.Tranlocal;
import org.multiverse.stms.gamma.transactions.GammaTxn;

public class GammaTxnRef<E>
extends BaseGammaTxnRef
implements TxnRef<E> {
    public GammaTxnRef(E value) {
        this((GammaStm)GlobalStmInstance.getGlobalStmInstance(), value);
    }

    public GammaTxnRef(GammaTxn tx) {
        this(tx, null);
    }

    public GammaTxnRef(GammaTxn tx, E value) {
        super(tx.getConfig().stm, 5);
        this.arriveAndLock(1, 3);
        Tranlocal tranlocal = this.openForConstruction(tx);
        tranlocal.ref_value = value;
    }

    public GammaTxnRef(GammaStm stm) {
        this(stm, null);
    }

    public GammaTxnRef(GammaStm stm, E value) {
        super(stm, 5);
        this.ref_value = value;
        this.version = 1L;
    }

    @Override
    public final E get() {
        return this.get(GammaStmUtils.getRequiredThreadLocalGammaTxn());
    }

    @Override
    public final E get(Txn tx) {
        return this.get(GammaStmUtils.asGammaTxn(tx));
    }

    public final E get(GammaTxn tx) {
        return this.openForRead((GammaTxn)tx, (int)0).ref_value;
    }

    @Override
    public final E getAndLock(LockMode lockMode) {
        return this.getAndLock(GammaStmUtils.getRequiredThreadLocalGammaTxn(), lockMode);
    }

    @Override
    public final E getAndLock(Txn tx, LockMode lockMode) {
        return this.getAndLock(GammaStmUtils.asGammaTxn(tx), lockMode);
    }

    public final E getAndLock(GammaTxn tx, LockMode lockMode) {
        return (E)this.getObject(tx, lockMode);
    }

    @Override
    public final E set(E value) {
        return this.set(TxnThreadLocal.getRequiredThreadLocalTxn(), value);
    }

    @Override
    public final E set(Txn tx, E value) {
        return this.set(GammaStmUtils.asGammaTxn(tx), value);
    }

    public final E set(GammaTxn tx, E value) {
        Tranlocal tranlocal = this.openForWrite(tx, 0);
        tranlocal.ref_value = value;
        return value;
    }

    @Override
    public final E setAndLock(E value, LockMode lockMode) {
        return this.setAndLock(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value, lockMode);
    }

    @Override
    public final E setAndLock(Txn tx, E value, LockMode lockMode) {
        return this.setAndLock(GammaStmUtils.asGammaTxn(tx), value, lockMode);
    }

    public final E setAndLock(GammaTxn tx, E value, LockMode lockMode) {
        return (E)this.setObject(tx, lockMode, value, false);
    }

    @Override
    public final E getAndSet(E value) {
        return this.getAndSet(TxnThreadLocal.getRequiredThreadLocalTxn(), value);
    }

    @Override
    public final E getAndSet(Txn tx, E value) {
        return this.getAndSet(GammaStmUtils.asGammaTxn(tx), value);
    }

    public final E getAndSet(GammaTxn tx, E value) {
        Tranlocal tranlocal = this.openForWrite(tx, 0);
        Object oldValue = tranlocal.ref_value;
        tranlocal.ref_value = value;
        return oldValue;
    }

    @Override
    public final E getAndSetAndLock(E value, LockMode lockMode) {
        return this.getAndSetAndLock(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value, lockMode);
    }

    @Override
    public final E getAndSetAndLock(Txn tx, E value, LockMode lockMode) {
        return this.getAndSetAndLock(GammaStmUtils.asGammaTxn(tx), value, lockMode);
    }

    public final E getAndSetAndLock(GammaTxn tx, E value, LockMode lockMode) {
        return (E)this.setObject(tx, lockMode, value, true);
    }

    @Override
    public final E atomicGet() {
        return (E)this.atomicObjectGet();
    }

    @Override
    public final E atomicWeakGet() {
        return (E)this.ref_value;
    }

    @Override
    public final E atomicSet(E newValue) {
        return (E)this.atomicSetObject(newValue, false);
    }

    @Override
    public final E atomicGetAndSet(E newValue) {
        return (E)this.atomicSetObject(newValue, true);
    }

    @Override
    public final void commute(Function<E> function) {
        this.commute(TxnThreadLocal.getRequiredThreadLocalTxn(), function);
    }

    @Override
    public final void commute(Txn tx, Function<E> function) {
        this.commute(GammaStmUtils.asGammaTxn(tx), function);
    }

    public final void commute(GammaTxn tx, Function<E> function) {
        this.openForCommute(tx, function);
    }

    @Override
    public final E atomicAlterAndGet(Function<E> function) {
        return this.atomicAlter(function, false);
    }

    @Override
    public final E atomicGetAndAlter(Function<E> function) {
        return this.atomicAlter(function, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E atomicAlter(Function<E> function, boolean returnOld) {
        Object newValue;
        if (function == null) {
            throw new NullPointerException("Function can't be null");
        }
        int arriveStatus = this.arriveAndExclusiveLockOrBackoff();
        if (arriveStatus == 0) {
            throw new LockedException();
        }
        Object oldValue = this.ref_value;
        boolean abort = true;
        try {
            newValue = function.call(oldValue);
            abort = false;
        }
        finally {
            if (abort) {
                this.departAfterFailureAndUnlock();
            }
        }
        if (oldValue == newValue) {
            if ((arriveStatus & 2) != 0) {
                this.unlockByUnregistered();
            } else {
                this.departAfterReadingAndUnlock();
            }
            return (E)oldValue;
        }
        if ((arriveStatus & 4) != 0) {
            this.stm.globalConflictCounter.signalConflict();
        }
        this.ref_value = newValue;
        ++this.version;
        Listeners listeners = this.___removeListenersAfterWrite();
        this.departAfterUpdateAndUnlock();
        if (listeners != null) {
            listeners.openAll(ThreadLocalGammaObjectPool.getThreadLocalGammaObjectPool());
        }
        return (E)(returnOld ? oldValue : newValue);
    }

    @Override
    public final E alterAndGet(Function<E> function) {
        return this.alterAndGet(TxnThreadLocal.getRequiredThreadLocalTxn(), function);
    }

    @Override
    public final E alterAndGet(Txn tx, Function<E> function) {
        return this.alterAndGet(GammaStmUtils.asGammaTxn(tx), function);
    }

    public final E alterAndGet(GammaTxn tx, Function<E> function) {
        return this.alter(tx, function, false);
    }

    @Override
    public final E getAndAlter(Function<E> function) {
        return this.getAndAlter(TxnThreadLocal.getRequiredThreadLocalTxn(), function);
    }

    @Override
    public final E getAndAlter(Txn tx, Function<E> function) {
        return this.getAndAlter(GammaStmUtils.asGammaTxn(tx), function);
    }

    public final E getAndAlter(GammaTxn tx, Function<E> function) {
        return this.alter(tx, function, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E alter(GammaTxn tx, Function<E> function, boolean returnOld) {
        if (tx == null) {
            throw new NullPointerException();
        }
        if (function == null) {
            tx.abort();
            throw new NullPointerException("Function can't be null");
        }
        Tranlocal write = this.openForWrite(tx, 0);
        boolean abort = true;
        try {
            Object oldValue = write.ref_value;
            write.ref_value = function.call(oldValue);
            abort = false;
            Object e = returnOld ? oldValue : write.ref_value;
            return e;
        }
        finally {
            if (abort) {
                tx.abort();
            }
        }
    }

    @Override
    public final boolean atomicCompareAndSet(E expectedValue, E newValue) {
        int arriveStatus = this.arriveAndExclusiveLockOrBackoff();
        if (arriveStatus == 0) {
            throw new LockedException();
        }
        Object currentValue = this.ref_value;
        if (currentValue != expectedValue) {
            this.departAfterFailureAndUnlock();
            return false;
        }
        if (expectedValue == newValue) {
            if ((arriveStatus & 2) != 0) {
                this.unlockByUnregistered();
            } else {
                this.departAfterReadingAndUnlock();
            }
            return true;
        }
        if ((arriveStatus & 4) != 0) {
            this.stm.globalConflictCounter.signalConflict();
        }
        this.ref_value = newValue;
        ++this.version;
        Listeners listeners = this.___removeListenersAfterWrite();
        this.departAfterUpdateAndUnlock();
        if (listeners != null) {
            listeners.openAll(ThreadLocalGammaObjectPool.getThreadLocalGammaObjectPool());
        }
        return true;
    }

    @Override
    public final boolean isNull() {
        return this.isNull(GammaStmUtils.getRequiredThreadLocalGammaTxn());
    }

    @Override
    public final boolean isNull(Txn tx) {
        return this.isNull(GammaStmUtils.asGammaTxn(tx));
    }

    public final boolean isNull(GammaTxn tx) {
        return this.openForRead((GammaTxn)tx, (int)0).ref_value == null;
    }

    @Override
    public final boolean atomicIsNull() {
        return this.atomicGet() == null;
    }

    @Override
    public final E awaitNotNullAndGet() {
        return this.awaitNotNullAndGet(GammaStmUtils.getRequiredThreadLocalGammaTxn());
    }

    @Override
    public final E awaitNotNullAndGet(Txn tx) {
        return this.awaitNotNullAndGet(GammaStmUtils.asGammaTxn(tx));
    }

    public final E awaitNotNullAndGet(GammaTxn tx) {
        Tranlocal tranlocal = this.openForRead(tx, 0);
        if (tranlocal.ref_value == null) {
            tx.retry();
        }
        return tranlocal.ref_value;
    }

    @Override
    public final void awaitNull() {
        this.await(GammaStmUtils.getRequiredThreadLocalGammaTxn(), (Object)null);
    }

    @Override
    public final void awaitNull(Txn tx) {
        this.await(GammaStmUtils.asGammaTxn(tx), (Object)null);
    }

    public final void awaitNull(GammaTxn tx) {
        this.await(tx, (Object)null);
    }

    @Override
    public final void await(E value) {
        this.await(TxnThreadLocal.getRequiredThreadLocalTxn(), value);
    }

    @Override
    public final void await(Txn tx, E value) {
        this.await(GammaStmUtils.asGammaTxn(tx), value);
    }

    public final void await(GammaTxn tx, E value) {
        if (this.openForRead((GammaTxn)tx, (int)0).ref_value != value) {
            tx.retry();
        }
    }

    @Override
    public final void await(Predicate<E> predicate) {
        this.await(TxnThreadLocal.getRequiredThreadLocalTxn(), predicate);
    }

    @Override
    public final void await(Txn tx, Predicate<E> predicate) {
        this.await(GammaStmUtils.asGammaTxn(tx), predicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void await(GammaTxn tx, Predicate<E> predicate) {
        Tranlocal tranlocal = this.openForRead(tx, 0);
        boolean abort = true;
        try {
            if (!predicate.evaluate(tranlocal.ref_value)) {
                tx.retry();
            }
            abort = false;
        }
        finally {
            if (abort) {
                tx.abort();
            }
        }
    }

    @Override
    public final String toDebugString() {
        return String.format("GammaTxnRef{orec=%s, version=%s, value=%s, hasListeners=%s)", this.___toOrecString(), this.version, this.ref_value, this.listeners != null);
    }

    @Override
    public final String toString() {
        return this.toString(GammaStmUtils.getRequiredThreadLocalGammaTxn());
    }

    @Override
    public final String toString(Txn tx) {
        return this.toString(GammaStmUtils.asGammaTxn(tx));
    }

    public final String toString(GammaTxn tx) {
        E value = this.get(tx);
        return value == null ? "null" : value.toString();
    }

    @Override
    public final String atomicToString() {
        E value = this.atomicGet();
        return value == null ? "null" : value.toString();
    }
}

