/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterTrash {
    public static final Logger LOG = LoggerFactory.getLogger(TestRouterTrash.class);
    private static StateStoreDFSCluster cluster;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static MountTableResolver mountTable;
    private static FileSystem routerFs;
    private static FileSystem nnFs;
    private static final String TEST_USER = "test-trash";
    private static MiniRouterDFSCluster.NamenodeContext nnContext;
    private static String ns0;
    private static String ns1;
    private static final String MOUNT_POINT = "/home/data";
    private static final String FILE = "/home/data/file1";
    private static final String TRASH_ROOT = "/user/test-trash/.Trash";
    private static final String CURRENT = "/Current";

    @BeforeClass
    public static void globalSetUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 2);
        Configuration conf = new RouterConfigBuilder().stateStore().admin().rpc().http().build();
        conf.set("fs.trash.interval", "100");
        cluster.addRouterOverrides(conf);
        cluster.startCluster();
        cluster.startRouters();
        cluster.waitClusterUp();
        ns0 = cluster.getNameservices().get(0);
        ns1 = cluster.getNameservices().get(1);
        routerContext = cluster.getRandomRouter();
        routerFs = routerContext.getFileSystem();
        nnContext = cluster.getNamenode(ns0, null);
        nnFs = nnContext.getFileSystem();
        Router router = routerContext.getRouter();
        mountTable = (MountTableResolver)router.getSubclusterResolver();
    }

    @AfterClass
    public static void tearDown() {
        if (cluster != null) {
            cluster.stopRouter(routerContext);
            cluster.shutdown();
            cluster = null;
        }
    }

    @After
    public void clearMountTable() throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        GetMountTableEntriesRequest req1 = GetMountTableEntriesRequest.newInstance((String)"/");
        GetMountTableEntriesResponse response = mountTableManager.getMountTableEntries(req1);
        for (MountTable entry : response.getEntries()) {
            RemoveMountTableEntryRequest req2 = RemoveMountTableEntryRequest.newInstance((String)entry.getSourcePath());
            mountTableManager.removeMountTableEntry(req2);
        }
    }

    @After
    public void clearFile() throws IOException {
        FileStatus[] fileStatuses;
        for (FileStatus file : fileStatuses = nnFs.listStatus(new Path("/"))) {
            nnFs.delete(file.getPath(), true);
        }
    }

    private boolean addMountTable(MountTable entry) throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)entry);
        AddMountTableEntryResponse addResponse = mountTableManager.addMountTableEntry(addRequest);
        mountTable.loadCache(true);
        return addResponse.getStatus();
    }

    @Test
    public void testMoveToTrashNoMountPoint() throws IOException, URISyntaxException, InterruptedException {
        MountTable addEntry = MountTable.newInstance((String)MOUNT_POINT, Collections.singletonMap(ns0, MOUNT_POINT));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        DFSClient client = nnContext.getClient();
        client.setOwner("/", TEST_USER, TEST_USER);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)TEST_USER);
        client = nnContext.getClient(ugi);
        client.mkdirs(MOUNT_POINT, new FsPermission("777"), true);
        Assert.assertTrue((boolean)client.exists(MOUNT_POINT));
        client.create(FILE, true);
        Path filePath = new Path(FILE);
        FileStatus[] fileStatuses = routerFs.listStatus(filePath);
        Assert.assertEquals((long)1L, (long)fileStatuses.length);
        Assert.assertEquals((Object)TEST_USER, (Object)fileStatuses[0].getOwner());
        Configuration routerConf = routerContext.getConf();
        FileSystem fs = DFSTestUtil.getFileSystemAs((UserGroupInformation)ugi, (Configuration)routerConf);
        Trash trash = new Trash(fs, routerConf);
        Assert.assertTrue((boolean)trash.moveToTrash(filePath));
        fileStatuses = nnFs.listStatus(new Path("/user/test-trash/.Trash/Current/home/data"));
        Assert.assertEquals((long)1L, (long)fileStatuses.length);
        Assert.assertTrue((boolean)nnFs.exists(new Path("/user/test-trash/.Trash/Current/home/data/file1")));
        Assert.assertTrue((boolean)nnFs.exists(new Path("/user/test-trash/.Trash/Current/home/data/file1")));
        client.create(FILE, true);
        filePath = new Path(FILE);
        fileStatuses = routerFs.listStatus(filePath);
        Assert.assertEquals((long)1L, (long)fileStatuses.length);
        Assert.assertTrue((boolean)trash.moveToTrash(filePath));
        fileStatuses = routerFs.listStatus(new Path("/user/test-trash/.Trash/Current/home/data"));
        Assert.assertEquals((long)2L, (long)fileStatuses.length);
    }

    @Test
    public void testMoveToTrashWithKerberosUser() throws IOException, URISyntaxException, InterruptedException {
        String kerberosUser = "randomUser/dev@HADOOP.COM";
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)kerberosUser);
        MountTable addEntry = MountTable.newInstance((String)MOUNT_POINT, Collections.singletonMap(ns1, MOUNT_POINT));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        MiniRouterDFSCluster.NamenodeContext nn1Context = cluster.getNamenode(ns1, null);
        DFSClient currentUserClientNs0 = nnContext.getClient();
        DFSClient currentUserClientNs1 = nn1Context.getClient();
        currentUserClientNs0.setOwner("/", ugi.getShortUserName(), ugi.getShortUserName());
        currentUserClientNs1.setOwner("/", ugi.getShortUserName(), ugi.getShortUserName());
        DFSClient testUserClientNs1 = nn1Context.getClient(ugi);
        testUserClientNs1.mkdirs(MOUNT_POINT, new FsPermission("777"), true);
        Assert.assertTrue((boolean)testUserClientNs1.exists(MOUNT_POINT));
        testUserClientNs1.create(FILE, true);
        Path filePath = new Path(FILE);
        FileStatus[] fileStatuses = routerFs.listStatus(filePath);
        Assert.assertEquals((long)1L, (long)fileStatuses.length);
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)fileStatuses[0].getOwner());
        Configuration routerConf = routerContext.getConf();
        FileSystem fs = DFSTestUtil.getFileSystemAs((UserGroupInformation)ugi, (Configuration)routerConf);
        Trash trash = new Trash(fs, routerConf);
        Assert.assertTrue((boolean)trash.moveToTrash(filePath));
        fileStatuses = fs.listStatus(new Path("/user/" + ugi.getShortUserName() + "/.Trash/Current" + MOUNT_POINT));
        Assert.assertEquals((long)1L, (long)fileStatuses.length);
    }

    @Test
    public void testDeleteToTrashExistMountPoint() throws IOException, URISyntaxException, InterruptedException {
        MountTable addEntry = MountTable.newInstance((String)MOUNT_POINT, Collections.singletonMap(ns0, MOUNT_POINT));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        addEntry = MountTable.newInstance((String)TRASH_ROOT, Collections.singletonMap(ns1, TRASH_ROOT));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        DFSClient client = nnContext.getClient();
        client.setOwner("/", TEST_USER, TEST_USER);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)TEST_USER);
        client = nnContext.getClient(ugi);
        client.mkdirs(MOUNT_POINT, new FsPermission("777"), true);
        Assert.assertTrue((boolean)client.exists(MOUNT_POINT));
        client.create(FILE, true);
        Path filePath = new Path(FILE);
        FileStatus[] fileStatuses = routerFs.listStatus(filePath);
        Assert.assertEquals((long)1L, (long)fileStatuses.length);
        Assert.assertEquals((Object)TEST_USER, (Object)fileStatuses[0].getOwner());
        Configuration routerConf = routerContext.getConf();
        FileSystem fs = DFSTestUtil.getFileSystemAs((UserGroupInformation)ugi, (Configuration)routerConf);
        Trash trash = new Trash(fs, routerConf);
        Assert.assertTrue((boolean)trash.moveToTrash(filePath));
        fileStatuses = nnFs.listStatus(new Path("/user/test-trash/.Trash/Current/home/data"));
        Assert.assertEquals((long)1L, (long)fileStatuses.length);
        Assert.assertTrue((boolean)nnFs.exists(new Path("/user/test-trash/.Trash/Current/home/data/file1")));
        client.create(FILE, true);
        filePath = new Path(FILE);
        fileStatuses = nnFs.listStatus(filePath);
        Assert.assertEquals((long)1L, (long)fileStatuses.length);
        Assert.assertTrue((boolean)trash.moveToTrash(filePath));
        fileStatuses = nnFs.listStatus(new Path("/user/test-trash/.Trash/Current/home/data"));
        Assert.assertEquals((long)2L, (long)fileStatuses.length);
    }

    @Test
    public void testIsTrashPath() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Assert.assertNotNull((Object)ugi);
        Assert.assertTrue((boolean)MountTableResolver.isTrashPath((String)("/user/" + ugi.getUserName() + "/.Trash/Current" + MOUNT_POINT)));
        Assert.assertTrue((boolean)MountTableResolver.isTrashPath((String)("/user/" + ugi.getUserName() + "/.Trash/" + Time.now() + MOUNT_POINT)));
        Assert.assertFalse((boolean)MountTableResolver.isTrashPath((String)MOUNT_POINT));
        Assert.assertFalse((boolean)MountTableResolver.isTrashPath((String)("/home/user/" + ugi.getUserName() + "/.Trash/Current" + MOUNT_POINT)));
        Assert.assertFalse((boolean)MountTableResolver.isTrashPath((String)("/home/user/" + ugi.getUserName() + "/.Trash/" + Time.now() + MOUNT_POINT)));
        Assert.assertFalse((boolean)MountTableResolver.isTrashPath((String)""));
        Assert.assertFalse((boolean)MountTableResolver.isTrashPath((String)"/home/user/empty.Trash/Current"));
        Assert.assertFalse((boolean)MountTableResolver.isTrashPath((String)"/home/user/.Trash"));
        Assert.assertFalse((boolean)MountTableResolver.isTrashPath((String)"/.Trash/Current"));
    }

    @Test
    public void testSubtractTrashCurrentPath() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Assert.assertNotNull((Object)ugi);
        Assert.assertEquals((Object)MOUNT_POINT, (Object)MountTableResolver.subtractTrashCurrentPath((String)("/user/" + ugi.getUserName() + "/.Trash/Current" + MOUNT_POINT)));
        Assert.assertEquals((Object)MOUNT_POINT, (Object)MountTableResolver.subtractTrashCurrentPath((String)("/user/" + ugi.getUserName() + "/.Trash/" + Time.now() + MOUNT_POINT)));
        Assert.assertEquals((Object)("/home/user/" + ugi.getUserName() + "/.Trash/Current" + MOUNT_POINT), (Object)MountTableResolver.subtractTrashCurrentPath((String)("/home/user/" + ugi.getUserName() + "/.Trash/Current" + MOUNT_POINT)));
        long time = Time.now();
        Assert.assertEquals((Object)("/home/user/" + ugi.getUserName() + "/.Trash/" + time + MOUNT_POINT), (Object)MountTableResolver.subtractTrashCurrentPath((String)("/home/user/" + ugi.getUserName() + "/.Trash/" + time + MOUNT_POINT)));
        Assert.assertEquals((Object)"", (Object)MountTableResolver.subtractTrashCurrentPath((String)""));
        Assert.assertEquals((Object)"/home/user/empty.Trash/Current", (Object)MountTableResolver.subtractTrashCurrentPath((String)"/home/user/empty.Trash/Current"));
        Assert.assertEquals((Object)"/home/user/.Trash", (Object)MountTableResolver.subtractTrashCurrentPath((String)"/home/user/.Trash"));
        Assert.assertEquals((Object)"/.Trash/Current", (Object)MountTableResolver.subtractTrashCurrentPath((String)"/.Trash/Current"));
    }
}

