/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestFcLocalFsPermission;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.util.Shell;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestLocalFileSystemPermission {
    public static final Logger LOGGER = LoggerFactory.getLogger(TestFcLocalFsPermission.class);
    static final String TEST_PATH_PREFIX = GenericTestUtils.getTempPath(TestLocalFileSystemPermission.class.getSimpleName());

    private Path writeFile(FileSystem fs, String name) throws IOException {
        Path f = new Path(TEST_PATH_PREFIX + name);
        FSDataOutputStream stm = fs.create(f);
        stm.writeBytes("42\n");
        stm.close();
        return f;
    }

    private Path writeFile(FileSystem fs, String name, FsPermission perm) throws IOException {
        Path f = new Path(TEST_PATH_PREFIX + name);
        FSDataOutputStream stm = fs.create(f, perm, true, 2048, (short)1, 0x2000000L, null);
        stm.writeBytes("42\n");
        stm.close();
        return f;
    }

    private void cleanup(FileSystem fs, Path name) throws IOException {
        if (name != null) {
            Assert.assertTrue((boolean)fs.exists(name));
            fs.delete(name, true);
            Assert.assertFalse((boolean)fs.exists(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalFSDirsetPermission() throws IOException {
        PlatformAssumptions.assumeNotWindows();
        LocalFileSystem localfs = FileSystem.getLocal((Configuration)new Configuration());
        Configuration conf = localfs.getConf();
        conf.set("fs.permissions.umask-mode", "044");
        Path dir = new Path(TEST_PATH_PREFIX + "dir");
        localfs.mkdirs(dir);
        Path dir1 = new Path(TEST_PATH_PREFIX + "dir1");
        Path dir2 = new Path(TEST_PATH_PREFIX + "dir2");
        try {
            FsPermission initialPermission = this.getPermission(localfs, dir);
            Assert.assertEquals((Object)FsPermission.getDirDefault().applyUMask(FsPermission.getUMask((Configuration)conf)), (Object)initialPermission);
            FsPermission perm = new FsPermission(493);
            localfs.mkdirs(dir1, perm);
            initialPermission = this.getPermission(localfs, dir1);
            Assert.assertEquals((Object)perm.applyUMask(FsPermission.getUMask((Configuration)conf)), (Object)initialPermission);
            localfs.mkdirs(dir2);
            initialPermission = this.getPermission(localfs, dir2);
            Path copyPath = new Path(TEST_PATH_PREFIX + "dir_copy");
            localfs.rename(dir2, copyPath);
            FsPermission copyPermission = this.getPermission(localfs, copyPath);
            Assert.assertEquals((Object)initialPermission, (Object)copyPermission);
            dir2 = copyPath;
        }
        finally {
            this.cleanup((FileSystem)localfs, dir);
            this.cleanup((FileSystem)localfs, dir1);
            if (localfs.exists(dir2)) {
                localfs.delete(dir2, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalFSsetPermission() throws IOException {
        PlatformAssumptions.assumeNotWindows();
        Configuration conf = new Configuration();
        conf.set("fs.permissions.umask-mode", "044");
        LocalFileSystem localfs = FileSystem.getLocal((Configuration)conf);
        Path f = null;
        Path f1 = null;
        Path f2 = null;
        String filename = "foo";
        String filename1 = "foo1";
        String filename2 = "foo2";
        FsPermission perm = new FsPermission(493);
        try {
            f = this.writeFile((FileSystem)localfs, filename);
            f1 = this.writeFile((FileSystem)localfs, filename1, perm);
            f2 = this.writeFile((FileSystem)localfs, filename2);
            FsPermission initialPermission = this.getPermission(localfs, f);
            Assert.assertEquals((Object)FsPermission.getFileDefault().applyUMask(FsPermission.getUMask((Configuration)conf)), (Object)initialPermission);
            initialPermission = this.getPermission(localfs, f1);
            Assert.assertEquals((Object)perm.applyUMask(FsPermission.getUMask((Configuration)conf)), (Object)initialPermission);
            initialPermission = this.getPermission(localfs, f2);
            Path copyPath = new Path(TEST_PATH_PREFIX + "/foo_copy");
            localfs.rename(f2, copyPath);
            FsPermission copyPermission = this.getPermission(localfs, copyPath);
            Assert.assertEquals((Object)copyPermission, (Object)initialPermission);
            f2 = copyPath;
            FsPermission all = new FsPermission(511);
            FsPermission none = new FsPermission(0);
            localfs.setPermission(f, none);
            Assert.assertEquals((Object)none, (Object)this.getPermission(localfs, f));
            localfs.setPermission(f, all);
            Assert.assertEquals((Object)all, (Object)this.getPermission(localfs, f));
        }
        catch (Throwable throwable) {
            this.cleanup((FileSystem)localfs, f);
            this.cleanup((FileSystem)localfs, f1);
            if (localfs.exists(f2)) {
                localfs.delete(f2, true);
            }
            throw throwable;
        }
        this.cleanup((FileSystem)localfs, f);
        this.cleanup((FileSystem)localfs, f1);
        if (localfs.exists(f2)) {
            localfs.delete(f2, true);
        }
    }

    FsPermission getPermission(LocalFileSystem fs, Path p) throws IOException {
        return fs.getFileStatus(p).getPermission();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalFSsetOwner() throws IOException {
        PlatformAssumptions.assumeNotWindows();
        Configuration conf = new Configuration();
        conf.set("fs.permissions.umask-mode", "044");
        LocalFileSystem localfs = FileSystem.getLocal((Configuration)conf);
        String filename = "bar";
        Path f = this.writeFile((FileSystem)localfs, filename);
        try {
            List<String> groups = TestLocalFileSystemPermission.getGroups();
            LOGGER.info("{}: {}", (Object)filename, (Object)this.getPermission(localfs, f));
            String g0 = groups.get(0);
            localfs.setOwner(f, null, g0);
            Assert.assertEquals((Object)g0, (Object)this.getGroup(localfs, f));
            if (groups.size() > 1) {
                String g1 = groups.get(1);
                localfs.setOwner(f, null, g1);
                Assert.assertEquals((Object)g1, (Object)this.getGroup(localfs, f));
            } else {
                LOGGER.info("Not testing changing the group since user belongs to only one group.");
            }
        }
        finally {
            this.cleanup((FileSystem)localfs, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetUmaskInRealTime() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        LocalFileSystem localfs = FileSystem.getLocal((Configuration)new Configuration());
        Configuration conf = localfs.getConf();
        conf.set("fs.permissions.umask-mode", "022");
        LOGGER.info("Current umask is {}", (Object)conf.get("fs.permissions.umask-mode"));
        Path dir = new Path(TEST_PATH_PREFIX + "dir");
        Path dir2 = new Path(TEST_PATH_PREFIX + "dir2");
        try {
            Assert.assertTrue((boolean)localfs.mkdirs(dir));
            FsPermission initialPermission = this.getPermission(localfs, dir);
            Assert.assertEquals((String)"With umask 022 permission should be 755 since the default permission is 777", (Object)new FsPermission("755"), (Object)initialPermission);
            conf.set("fs.permissions.umask-mode", "062");
            Assert.assertTrue((boolean)localfs.mkdirs(dir2));
            FsPermission finalPermission = localfs.getFileStatus(dir2).getPermission();
            Assert.assertThat((String)"With umask 062 permission should not be 755 since the default permission is 777", (Object)new FsPermission("755"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)finalPermission)));
            Assert.assertEquals((String)"With umask 062 we expect 715 since the default permission is 777", (Object)new FsPermission("715"), (Object)finalPermission);
        }
        finally {
            conf.set("fs.permissions.umask-mode", "022");
            this.cleanup((FileSystem)localfs, dir);
            this.cleanup((FileSystem)localfs, dir2);
        }
    }

    static List<String> getGroups() throws IOException {
        ArrayList<String> a = new ArrayList<String>();
        String s = Shell.execCommand((String[])Shell.getGroupsCommand());
        StringTokenizer t = new StringTokenizer(s);
        while (t.hasMoreTokens()) {
            a.add(t.nextToken());
        }
        return a;
    }

    String getGroup(LocalFileSystem fs, Path p) throws IOException {
        return fs.getFileStatus(p).getGroup();
    }

    static {
        GenericTestUtils.setLogLevel(FileSystem.LOG, Level.DEBUG);
    }
}

