/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.shell.CopyCommands;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Progressable;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;

public class TestCopy {
    static Configuration conf;
    static Path path;
    static Path tmpPath;
    static CopyCommands.Put cmd;
    static FileSystem mockFs;
    static PathData target;
    static FileStatus fileStat;

    @BeforeClass
    public static void setup() throws IOException {
        conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        fileStat = (FileStatus)Mockito.mock(FileStatus.class);
        Mockito.when((Object)fileStat.isDirectory()).thenReturn((Object)false);
    }

    @Before
    public void resetMock() throws IOException {
        Mockito.reset((Object[])new FileSystem[]{mockFs});
        target = new PathData(path.toString(), conf);
        cmd = new CopyCommands.Put();
        cmd.setConf(conf);
    }

    @Test
    public void testCopyStreamTarget() throws Exception {
        FSDataOutputStream out = (FSDataOutputStream)Mockito.mock(FSDataOutputStream.class);
        this.whenFsCreate().thenReturn((Object)out);
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)tmpPath))).thenReturn((Object)fileStat);
        Mockito.when((Object)mockFs.rename((Path)Mockito.eq((Object)tmpPath), (Path)Mockito.eq((Object)path))).thenReturn((Object)true);
        FSInputStream in = (FSInputStream)Mockito.mock(FSInputStream.class);
        Mockito.when((Object)in.read((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)-1);
        this.tryCopyStream((InputStream)in, true);
        ((FSInputStream)Mockito.verify((Object)in)).close();
        ((FSDataOutputStream)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)2))).close();
        ((FSDataOutputStream)Mockito.verify((Object)out, (VerificationMode)Mockito.never())).write((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt());
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).delete((Path)Mockito.eq((Object)path), Mockito.anyBoolean());
        ((FileSystem)Mockito.verify((Object)mockFs)).rename((Path)Mockito.eq((Object)tmpPath), (Path)Mockito.eq((Object)path));
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).delete((Path)Mockito.eq((Object)tmpPath), Mockito.anyBoolean());
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).close();
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).exists((Path)Mockito.eq((Object)tmpPath));
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).exists((Path)Mockito.eq((Object)path));
    }

    @Test
    public void testCopyStreamTargetExists() throws Exception {
        FSDataOutputStream out = (FSDataOutputStream)Mockito.mock(FSDataOutputStream.class);
        this.whenFsCreate().thenReturn((Object)out);
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)path))).thenReturn((Object)fileStat);
        target.refreshStatus();
        cmd.setOverwrite(true);
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)tmpPath))).thenReturn((Object)fileStat);
        Mockito.when((Object)mockFs.delete((Path)Mockito.eq((Object)path), Mockito.eq((boolean)false))).thenReturn((Object)true);
        Mockito.when((Object)mockFs.rename((Path)Mockito.eq((Object)tmpPath), (Path)Mockito.eq((Object)path))).thenReturn((Object)true);
        FSInputStream in = (FSInputStream)Mockito.mock(FSInputStream.class);
        Mockito.when((Object)in.read((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)-1);
        this.tryCopyStream((InputStream)in, true);
        ((FileSystem)Mockito.verify((Object)mockFs)).delete((Path)Mockito.eq((Object)path), Mockito.anyBoolean());
        ((FileSystem)Mockito.verify((Object)mockFs)).rename((Path)Mockito.eq((Object)tmpPath), (Path)Mockito.eq((Object)path));
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).delete((Path)Mockito.eq((Object)tmpPath), Mockito.anyBoolean());
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testInterruptedCreate() throws Exception {
        this.whenFsCreate().thenThrow(new Throwable[]{new InterruptedIOException()});
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)tmpPath))).thenReturn((Object)fileStat);
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        this.tryCopyStream((InputStream)in, false);
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).rename((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class));
        ((FileSystem)Mockito.verify((Object)mockFs)).delete((Path)Mockito.eq((Object)tmpPath), Mockito.anyBoolean());
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).delete((Path)Mockito.eq((Object)path), Mockito.anyBoolean());
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testFailedWrite() throws Exception {
        FSDataOutputStream out = (FSDataOutputStream)Mockito.mock(FSDataOutputStream.class);
        ((FSDataOutputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("mocked")}).when((Object)out)).write((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt());
        this.whenFsCreate().thenReturn((Object)out);
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)tmpPath))).thenReturn((Object)fileStat);
        FSInputStream in = (FSInputStream)Mockito.mock(FSInputStream.class);
        ((FSInputStream)Mockito.doReturn((Object)0).when((Object)in)).read((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt());
        Throwable thrown = this.tryCopyStream((InputStream)in, false);
        GenericTestUtils.assertExceptionContains("mocked", thrown);
        ((FSInputStream)Mockito.verify((Object)in)).close();
        ((FSDataOutputStream)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)2))).close();
        ((FileSystem)Mockito.verify((Object)mockFs)).delete((Path)Mockito.eq((Object)tmpPath), Mockito.anyBoolean());
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).rename((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class));
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).delete((Path)Mockito.eq((Object)path), Mockito.anyBoolean());
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testInterruptedCopyBytes() throws Exception {
        FSDataOutputStream out = (FSDataOutputStream)Mockito.mock(FSDataOutputStream.class);
        this.whenFsCreate().thenReturn((Object)out);
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)tmpPath))).thenReturn((Object)fileStat);
        FSInputStream in = (FSInputStream)Mockito.mock(FSInputStream.class);
        Mockito.when((Object)in.read((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt())).thenThrow(new Throwable[]{new InterruptedIOException()});
        this.tryCopyStream((InputStream)in, false);
        ((FileSystem)Mockito.verify((Object)mockFs)).delete((Path)Mockito.eq((Object)tmpPath), Mockito.anyBoolean());
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).rename((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class));
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).delete((Path)Mockito.eq((Object)path), Mockito.anyBoolean());
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testInterruptedRename() throws Exception {
        FSDataOutputStream out = (FSDataOutputStream)Mockito.mock(FSDataOutputStream.class);
        this.whenFsCreate().thenReturn((Object)out);
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)tmpPath))).thenReturn((Object)fileStat);
        Mockito.when((Object)mockFs.rename((Path)Mockito.eq((Object)tmpPath), (Path)Mockito.eq((Object)path))).thenThrow(new Throwable[]{new InterruptedIOException()});
        FSInputStream in = (FSInputStream)Mockito.mock(FSInputStream.class);
        Mockito.when((Object)in.read((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)-1);
        this.tryCopyStream((InputStream)in, false);
        ((FileSystem)Mockito.verify((Object)mockFs)).delete((Path)Mockito.eq((Object)tmpPath), Mockito.anyBoolean());
        ((FileSystem)Mockito.verify((Object)mockFs)).rename((Path)Mockito.eq((Object)tmpPath), (Path)Mockito.eq((Object)path));
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).delete((Path)Mockito.eq((Object)path), Mockito.anyBoolean());
        ((FileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).close();
    }

    private OngoingStubbing<FSDataOutputStream> whenFsCreate() throws IOException {
        return Mockito.when((Object)mockFs.create((Path)Mockito.eq((Object)tmpPath), (FsPermission)Mockito.any(FsPermission.class), Mockito.anyBoolean(), Mockito.anyInt(), Mockito.anyShort(), Mockito.anyLong(), (Progressable)Mockito.any()));
    }

    private Throwable tryCopyStream(InputStream in, boolean shouldPass) {
        try {
            cmd.copyStreamToTarget((InputStream)new FSDataInputStream(in), target);
            return null;
        }
        catch (InterruptedIOException e) {
            if (shouldPass) {
                throw new AssertionError("copy failed", e);
            }
            return e;
        }
        catch (Throwable e) {
            if (shouldPass) {
                throw new AssertionError(e.getMessage(), e);
            }
            return e;
        }
    }

    static {
        path = new Path("mockfs:/file");
        tmpPath = new Path("mockfs:/file._COPYING_");
    }

    static class MockFileSystem
    extends FilterFileSystem {
        Configuration conf;

        MockFileSystem() {
            super(mockFs);
        }

        public void initialize(URI uri, Configuration conf) {
            this.conf = conf;
        }

        public Path makeQualified(Path path) {
            return path;
        }

        public Configuration getConf() {
            return this.conf;
        }
    }
}

