/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AllocationFileParser {
    private static final Logger LOG = LoggerFactory.getLogger(AllocationFileParser.class);
    private static final String QUEUE_MAX_RESOURCES_DEFAULT = "queueMaxResourcesDefault";
    private static final String USER_MAX_APPS_DEFAULT = "userMaxAppsDefault";
    private static final String DEFAULT_FAIR_SHARE_PREEMPTION_TIMEOUT = "defaultFairSharePreemptionTimeout";
    private static final String FAIR_SHARE_PREEMPTION_TIMEOUT = "fairSharePreemptionTimeout";
    private static final String DEFAULT_MIN_SHARE_PREEMPTION_TIMEOUT = "defaultMinSharePreemptionTimeout";
    private static final String QUEUE_MAX_APPS_DEFAULT = "queueMaxAppsDefault";
    private static final String DEFAULT_FAIR_SHARE_PREEMPTION_THRESHOLD = "defaultFairSharePreemptionThreshold";
    private static final String QUEUE_MAX_AM_SHARE_DEFAULT = "queueMaxAMShareDefault";
    private static final String RESERVATION_PLANNER = "reservation-planner";
    private static final String RESERVATION_AGENT = "reservation-agent";
    private static final String RESERVATION_ADMISSION_POLICY = "reservation-policy";
    private static final String QUEUE_PLACEMENT_POLICY = "queuePlacementPolicy";
    private static final String QUEUE = "queue";
    private static final String POOL = "pool";
    private static final String USER = "user";
    private static final String USERNAME = "name";
    private static final String MAX_RUNNING_APPS = "maxRunningApps";
    private static final String DEFAULT_QUEUE_SCHEDULING_POLICY = "defaultQueueSchedulingPolicy";
    private static final String DEFAULT_QUEUE_SCHEDULING_MODE = "defaultQueueSchedulingMode";
    private static final Set<String> VALID_TAG_NAMES = Sets.newHashSet((Object[])new String[]{"queueMaxResourcesDefault", "userMaxAppsDefault", "defaultFairSharePreemptionTimeout", "fairSharePreemptionTimeout", "defaultMinSharePreemptionTimeout", "queueMaxAppsDefault", "defaultFairSharePreemptionThreshold", "queueMaxAMShareDefault", "reservation-planner", "reservation-agent", "reservation-policy", "queuePlacementPolicy", "queue", "pool", "user", "defaultQueueSchedulingPolicy", "defaultQueueSchedulingMode"});
    private final NodeList elements;
    private final Map<String, String> textValues = Maps.newHashMap();
    private Element queuePlacementPolicyElement;
    private final List<Element> queueElements = new ArrayList<Element>();
    private final Map<String, Integer> userMaxApps = new HashMap<String, Integer>();
    private SchedulingPolicy defaultSchedulingPolicy;

    public AllocationFileParser(NodeList elements) {
        this.elements = elements;
    }

    public void parse() throws AllocationConfigurationException {
        for (int i = 0; i < this.elements.getLength(); ++i) {
            Node node = this.elements.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            String tagName = element.getTagName();
            if (VALID_TAG_NAMES.contains(tagName)) {
                if (tagName.equals(QUEUE_PLACEMENT_POLICY)) {
                    this.queuePlacementPolicyElement = element;
                    continue;
                }
                if (this.isSchedulingPolicy(element)) {
                    this.defaultSchedulingPolicy = this.extractSchedulingPolicy(element);
                    continue;
                }
                if (this.isQueue(element)) {
                    this.queueElements.add(element);
                    continue;
                }
                if (tagName.equals(USER)) {
                    this.extractUserData(element);
                    continue;
                }
                this.textValues.put(tagName, this.getTrimmedTextData(element));
                continue;
            }
            LOG.warn("Bad element in allocations file: " + tagName);
        }
    }

    private boolean isSchedulingPolicy(Element element) {
        return DEFAULT_QUEUE_SCHEDULING_POLICY.equals(element.getTagName()) || DEFAULT_QUEUE_SCHEDULING_MODE.equals(element.getTagName());
    }

    private void extractUserData(Element element) {
        String userName = element.getAttribute(USERNAME);
        NodeList fields = element.getChildNodes();
        for (int j = 0; j < fields.getLength(); ++j) {
            Element field;
            Node fieldNode = fields.item(j);
            if (!(fieldNode instanceof Element) || !MAX_RUNNING_APPS.equals((field = (Element)fieldNode).getTagName())) continue;
            String text = this.getTrimmedTextData(field);
            int val = Integer.parseInt(text);
            this.userMaxApps.put(userName, val);
        }
    }

    private SchedulingPolicy extractSchedulingPolicy(Element element) throws AllocationConfigurationException {
        String text = this.getTrimmedTextData(element);
        if (text.equalsIgnoreCase("FIFO")) {
            throw new AllocationConfigurationException("Bad fair scheduler config file: defaultQueueSchedulingPolicy or defaultQueueSchedulingMode can't be FIFO.");
        }
        return SchedulingPolicy.parse(text);
    }

    private boolean isQueue(Element element) {
        return element.getTagName().equals(QUEUE) || element.getTagName().equals(POOL);
    }

    private String getTrimmedTextData(Element element) {
        return ((Text)element.getFirstChild()).getData().trim();
    }

    public ConfigurableResource getQueueMaxResourcesDefault() throws AllocationConfigurationException {
        Optional<String> value = this.getTextValue(QUEUE_MAX_RESOURCES_DEFAULT);
        if (value.isPresent()) {
            return FairSchedulerConfiguration.parseResourceConfigValue(value.get());
        }
        return new ConfigurableResource(Resources.unbounded());
    }

    public int getUserMaxAppsDefault() {
        Optional<String> value = this.getTextValue(USER_MAX_APPS_DEFAULT);
        return value.map(Integer::parseInt).orElse(Integer.MAX_VALUE);
    }

    public long getDefaultFairSharePreemptionTimeout() {
        Optional<String> value = this.getTextValue(FAIR_SHARE_PREEMPTION_TIMEOUT);
        Optional<String> defaultValue = this.getTextValue(DEFAULT_FAIR_SHARE_PREEMPTION_TIMEOUT);
        if (value.isPresent() && !defaultValue.isPresent()) {
            return Long.parseLong(value.get()) * 1000L;
        }
        if (defaultValue.isPresent()) {
            return Long.parseLong(defaultValue.get()) * 1000L;
        }
        return Long.MAX_VALUE;
    }

    public long getDefaultMinSharePreemptionTimeout() {
        Optional<String> value = this.getTextValue(DEFAULT_MIN_SHARE_PREEMPTION_TIMEOUT);
        return value.map(v -> Long.parseLong(v) * 1000L).orElse(Long.MAX_VALUE);
    }

    public int getQueueMaxAppsDefault() {
        Optional<String> value = this.getTextValue(QUEUE_MAX_APPS_DEFAULT);
        return value.map(Integer::parseInt).orElse(Integer.MAX_VALUE);
    }

    public float getDefaultFairSharePreemptionThreshold() {
        Optional<String> value = this.getTextValue(DEFAULT_FAIR_SHARE_PREEMPTION_THRESHOLD);
        if (value.isPresent()) {
            float floatValue = Float.parseFloat(value.get());
            return Math.max(Math.min(floatValue, 1.0f), 0.0f);
        }
        return 0.5f;
    }

    public float getQueueMaxAMShareDefault() {
        Optional<String> value = this.getTextValue(QUEUE_MAX_AM_SHARE_DEFAULT);
        if (value.isPresent()) {
            float val = Float.parseFloat(value.get());
            return Math.min(val, 1.0f);
        }
        return 0.5f;
    }

    public Optional<String> getReservationPlanner() {
        return this.getTextValue(RESERVATION_PLANNER);
    }

    public Optional<String> getReservationAgent() {
        return this.getTextValue(RESERVATION_AGENT);
    }

    public Optional<String> getReservationAdmissionPolicy() {
        return this.getTextValue(RESERVATION_ADMISSION_POLICY);
    }

    public Optional<Element> getQueuePlacementPolicy() {
        return Optional.ofNullable(this.queuePlacementPolicyElement);
    }

    private Optional<String> getTextValue(String key) {
        return Optional.ofNullable(this.textValues.get(key));
    }

    public List<Element> getQueueElements() {
        return this.queueElements;
    }

    public Map<String, Integer> getUserMaxApps() {
        return this.userMaxApps;
    }

    public SchedulingPolicy getDefaultSchedulingPolicy() {
        if (this.defaultSchedulingPolicy != null) {
            return this.defaultSchedulingPolicy;
        }
        return SchedulingPolicy.DEFAULT_POLICY;
    }
}

