/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.ShellExecEndpoint;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.Service;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ShellExecEndpointCoprocessor
extends ShellExecEndpoint.ShellExecService
implements MasterCoprocessor,
RegionServerCoprocessor {
    private static final Logger LOG = LoggerFactory.getLogger(ShellExecEndpointCoprocessor.class);
    public static final String BACKGROUND_DELAY_MS_KEY = "hbase.it.shellexeccoproc.async.delay.ms";
    public static final long DEFAULT_BACKGROUND_DELAY_MS = 1000L;
    private final ExecutorService backgroundExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(ShellExecEndpointCoprocessor.class.getSimpleName() + "-{}").setDaemon(true).setUncaughtExceptionHandler((t, e) -> LOG.warn("Thread {} threw", (Object)t, (Object)e)).build());
    private Configuration conf;

    public Iterable<Service> getServices() {
        return Collections.singletonList(this);
    }

    public void start(CoprocessorEnvironment env) {
        this.conf = env.getConfiguration();
    }

    public void shellExec(RpcController controller, ShellExecEndpoint.ShellExecRequest request, RpcCallback<ShellExecEndpoint.ShellExecResponse> done) {
        String command = request.getCommand();
        if (StringUtils.isBlank((CharSequence)command)) {
            throw new RuntimeException("Request contained an empty command.");
        }
        boolean awaitResponse = !request.hasAwaitResponse() || request.getAwaitResponse();
        String[] subShellCmd = new String[]{"/usr/bin/env", "bash", "-c", command};
        Shell.ShellCommandExecutor shell = new Shell.ShellCommandExecutor(subShellCmd);
        String msgFmt = "Executing command" + (!awaitResponse ? " on a background thread" : "") + ": {}";
        LOG.info(msgFmt, (Object)command);
        if (awaitResponse) {
            this.runForegroundTask(shell, controller, done);
        } else {
            this.runBackgroundTask(shell, done);
        }
    }

    private void runForegroundTask(Shell.ShellCommandExecutor shell, RpcController controller, RpcCallback<ShellExecEndpoint.ShellExecResponse> done) {
        ShellExecEndpoint.ShellExecResponse.Builder builder = ShellExecEndpoint.ShellExecResponse.newBuilder();
        try {
            this.doExec(shell, builder);
        }
        catch (IOException e) {
            LOG.error("Failure launching process", (Throwable)e);
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }

    private void runBackgroundTask(Shell.ShellCommandExecutor shell, RpcCallback<ShellExecEndpoint.ShellExecResponse> done) {
        long sleepDuration = this.conf.getLong(BACKGROUND_DELAY_MS_KEY, 1000L);
        this.backgroundExecutor.execute(() -> {
            try {
                Thread.sleep(sleepDuration);
                this.doExec(shell, ShellExecEndpoint.ShellExecResponse.newBuilder());
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted before launching process.", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error("Failure launching process", (Throwable)e);
            }
        });
        done.run((Object)ShellExecEndpoint.ShellExecResponse.newBuilder().build());
    }

    private void doExec(Shell.ShellCommandExecutor shell, ShellExecEndpoint.ShellExecResponse.Builder builder) throws IOException {
        try {
            shell.execute();
            builder.setExitCode(shell.getExitCode()).setStdout(shell.getOutput());
        }
        catch (Shell.ExitCodeException e) {
            LOG.warn("Launched process failed", (Throwable)e);
            builder.setExitCode(e.getExitCode()).setStdout(shell.getOutput()).setStderr(e.getMessage());
        }
    }
}

