/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.RegionSizeCalculator;
import org.apache.hadoop.hbase.mapreduce.TableRecordReader;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public abstract class MultiTableInputFormatBase
extends InputFormat<ImmutableBytesWritable, Result> {
    private static final Logger LOG = LoggerFactory.getLogger(MultiTableInputFormatBase.class);
    private List<Scan> scans;
    private TableRecordReader tableRecordReader = null;

    public RecordReader<ImmutableBytesWritable, Result> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        TableSplit tSplit = (TableSplit)split;
        LOG.info(MessageFormat.format("Input split length: {0} bytes.", tSplit.getLength()));
        if (tSplit.getTable() == null) {
            throw new IOException("Cannot create a record reader because of a previous error. Please look at the previous logs lines from the task's full log for more details.");
        }
        final Connection connection = ConnectionFactory.createConnection((Configuration)context.getConfiguration());
        Table table = connection.getTable(tSplit.getTable());
        if (this.tableRecordReader == null) {
            this.tableRecordReader = new TableRecordReader();
        }
        final TableRecordReader trr = this.tableRecordReader;
        try {
            Scan sc = tSplit.getScan();
            sc.withStartRow(tSplit.getStartRow());
            sc.withStopRow(tSplit.getEndRow());
            trr.setScan(sc);
            trr.setTable(table);
            return new RecordReader<ImmutableBytesWritable, Result>(){

                public void close() throws IOException {
                    trr.close();
                    connection.close();
                }

                public ImmutableBytesWritable getCurrentKey() throws IOException, InterruptedException {
                    return trr.getCurrentKey();
                }

                public Result getCurrentValue() throws IOException, InterruptedException {
                    return trr.getCurrentValue();
                }

                public float getProgress() throws IOException, InterruptedException {
                    return trr.getProgress();
                }

                public void initialize(InputSplit inputsplit, TaskAttemptContext context) throws IOException, InterruptedException {
                    trr.initialize(inputsplit, context);
                }

                public boolean nextKeyValue() throws IOException, InterruptedException {
                    return trr.nextKeyValue();
                }
            };
        }
        catch (IOException ioe) {
            trr.close();
            connection.close();
            throw ioe;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<InputSplit> getSplits(JobContext context) throws IOException {
        if (this.scans.isEmpty()) {
            throw new IOException("No scans were provided.");
        }
        HashMap<TableName, ArrayList<Scan>> tableMaps = new HashMap<TableName, ArrayList<Scan>>();
        for (Scan scan : this.scans) {
            byte[] tableNameBytes = scan.getAttribute("scan.attributes.table.name");
            if (tableNameBytes == null) {
                throw new IOException("A scan object did not have a table name");
            }
            TableName tableName = TableName.valueOf((byte[])tableNameBytes);
            ArrayList<Scan> scanList = (ArrayList<Scan>)tableMaps.get(tableName);
            if (scanList == null) {
                scanList = new ArrayList<Scan>();
                tableMaps.put(tableName, scanList);
            }
            scanList.add(scan);
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        Iterator iter = tableMaps.entrySet().iterator();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)context.getConfiguration());){
            while (iter.hasNext()) {
                Table table;
                block42: {
                    Map.Entry entry = iter.next();
                    TableName tableName = (TableName)entry.getKey();
                    List scanList = (List)entry.getValue();
                    table = conn.getTable(tableName);
                    Throwable throwable = null;
                    try {
                        try (RegionLocator regionLocator = conn.getRegionLocator(tableName);){
                            RegionSizeCalculator sizeCalculator = new RegionSizeCalculator(regionLocator, conn.getAdmin());
                            Pair keys = regionLocator.getStartEndKeys();
                            for (Scan scan : scanList) {
                                if (keys == null) throw new IOException("Expecting at least one region for table : " + tableName.getNameAsString());
                                if (keys.getFirst() == null) throw new IOException("Expecting at least one region for table : " + tableName.getNameAsString());
                                if (((byte[][])keys.getFirst()).length == 0) {
                                    throw new IOException("Expecting at least one region for table : " + tableName.getNameAsString());
                                }
                                int count = 0;
                                byte[] startRow = scan.getStartRow();
                                byte[] stopRow = scan.getStopRow();
                                for (int i = 0; i < ((byte[][])keys.getFirst()).length; ++i) {
                                    if (!this.includeRegionInSplit(((byte[][])keys.getFirst())[i], ((byte[][])keys.getSecond())[i]) || startRow.length != 0 && ((byte[][])keys.getSecond())[i].length != 0 && Bytes.compareTo((byte[])startRow, (byte[])((byte[][])keys.getSecond())[i]) >= 0 || stopRow.length != 0 && Bytes.compareTo((byte[])stopRow, (byte[])((byte[][])keys.getFirst())[i]) <= 0) continue;
                                    byte[] splitStart = startRow.length == 0 || Bytes.compareTo((byte[])((byte[][])keys.getFirst())[i], (byte[])startRow) >= 0 ? ((byte[][])keys.getFirst())[i] : startRow;
                                    byte[] splitStop = (stopRow.length == 0 || Bytes.compareTo((byte[])((byte[][])keys.getSecond())[i], (byte[])stopRow) <= 0) && ((byte[][])keys.getSecond())[i].length > 0 ? ((byte[][])keys.getSecond())[i] : stopRow;
                                    HRegionLocation hregionLocation = regionLocator.getRegionLocation(((byte[][])keys.getFirst())[i], false);
                                    String regionHostname = hregionLocation.getHostname();
                                    RegionInfo regionInfo = hregionLocation.getRegion();
                                    String encodedRegionName = regionInfo.getEncodedName();
                                    long regionSize = sizeCalculator.getRegionSize(regionInfo.getRegionName());
                                    TableSplit split = new TableSplit(table.getName(), scan, splitStart, splitStop, regionHostname, encodedRegionName, regionSize);
                                    splits.add(split);
                                    if (!LOG.isDebugEnabled()) continue;
                                    LOG.debug("getSplits: split -> " + count++ + " -> " + split);
                                }
                            }
                        }
                        if (table == null) continue;
                        if (throwable == null) break block42;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (table == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    table.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            table.close();
                            throw throwable3;
                        }
                    }
                    try {
                        table.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                table.close();
            }
            return splits;
        }
    }

    protected boolean includeRegionInSplit(byte[] startKey, byte[] endKey) {
        return true;
    }

    protected List<Scan> getScans() {
        return this.scans;
    }

    protected void setScans(List<Scan> scans) {
        this.scans = scans;
    }

    protected void setTableRecordReader(TableRecordReader tableRecordReader) {
        this.tableRecordReader = tableRecordReader;
    }
}

