/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.ExecutorStatusChore;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.executor.TestExecutorService;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceImpl;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestExecutorStatusChore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestExecutorStatusChore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestExecutorStatusChore.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricsCollect() throws Exception {
        int maxThreads = 5;
        int maxTries = 10;
        int sleepInterval = 1000;
        Server mockedServer = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)mockedServer.getConfiguration()).thenReturn((Object)HBaseConfiguration.create());
        ExecutorService executorService = new ExecutorService("unit_test");
        executorService.startExecutorService(new ExecutorService.ExecutorConfig(executorService).setExecutorType(ExecutorType.RS_PARALLEL_SEEK).setCorePoolSize(maxThreads));
        MetricsRegionServerSource serverSource = ((MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class)).createServer(null);
        Assert.assertTrue((boolean)(serverSource instanceof MetricsRegionServerSourceImpl));
        ExecutorStatusChore statusChore = new ExecutorStatusChore(60000, (Stoppable)mockedServer, executorService, serverSource);
        AtomicBoolean lock = new AtomicBoolean(true);
        AtomicInteger counter = new AtomicInteger(0);
        for (int i = 0; i < maxThreads + 1; ++i) {
            executorService.submit((EventHandler)new TestExecutorService.TestEventHandler(mockedServer, EventType.RS_PARALLEL_SEEK, lock, counter));
        }
        for (int tries = 0; counter.get() < maxThreads && tries < maxTries; ++tries) {
            LOG.info("Waiting for all event handlers to start...");
            Thread.sleep(sleepInterval);
        }
        Assert.assertEquals((long)maxThreads, (long)counter.get());
        statusChore.chore();
        Pair executorStatus = statusChore.getExecutorStatus("RS_PARALLEL_SEEK");
        Assert.assertEquals((long)maxThreads, (long)((Long)executorStatus.getFirst()).intValue());
        Assert.assertEquals((long)1L, (long)((Long)executorStatus.getSecond()).intValue());
        AtomicBoolean atomicBoolean = lock;
        synchronized (atomicBoolean) {
            lock.set(false);
            lock.notifyAll();
        }
        executorService.shutdown();
    }
}

