/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestLocalHBaseCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLocalHBaseCluster.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();

    @Test
    public void testLocalHBaseCluster() throws Exception {
        int val;
        StartTestingClusterOption option = StartTestingClusterOption.builder().masterClass(MyHMaster.class).rsClass(MyHRegionServer.class).build();
        TEST_UTIL.startMiniCluster(option);
        try {
            val = ((MyHMaster)TEST_UTIL.getHBaseCluster().getMaster(0)).echo(42);
            Assert.assertEquals((long)42L, (long)val);
        }
        catch (ClassCastException e) {
            Assert.fail((String)"Could not cast master to our class");
        }
        try {
            val = ((MyHRegionServer)TEST_UTIL.getHBaseCluster().getRegionServer(0)).echo(42);
            Assert.assertEquals((long)42L, (long)val);
        }
        catch (ClassCastException e) {
            Assert.fail((String)"Could not cast regionserver to our class");
        }
        TEST_UTIL.shutdownMiniCluster();
    }

    public static class MyHRegionServer
    extends SingleProcessHBaseCluster.MiniHBaseClusterRegionServer {
        public MyHRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        public int echo(int val) {
            return val;
        }
    }

    public static class MyHMaster
    extends HMaster {
        public MyHMaster(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }

        public int echo(int val) {
            return val;
        }
    }
}

