/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TestMetaTableAccessor;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestMetaUpdatesGoToPriorityQueue {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaUpdatesGoToPriorityQueue.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().set("hbase.region.server.rpc.scheduler.factory.class", TestMetaTableAccessor.SpyingRpcSchedulerFactory.class.getName());
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private void multiMutate(byte[] row, List<Mutation> mutations) throws IOException {
        MultiRowMutationProtos.MutateRowsRequest.Builder builder = MultiRowMutationProtos.MutateRowsRequest.newBuilder();
        for (Mutation mutation : mutations) {
            if (mutation instanceof Put) {
                builder.addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)mutation));
                continue;
            }
            if (mutation instanceof Delete) {
                builder.addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.DELETE, (Mutation)mutation));
                continue;
            }
            throw new DoNotRetryIOException("multi in MetaEditor doesn't support " + mutation.getClass().getName());
        }
        MultiRowMutationProtos.MutateRowsRequest request = builder.build();
        AsyncTable table = UTIL.getAsyncConnection().getTable(TableName.META_TABLE_NAME);
        CompletableFuture future = table.coprocessorService(MultiRowMutationProtos.MultiRowMutationService::newStub, (stub, controller, done) -> stub.mutateRows(controller, request, done), row);
        FutureUtils.get((Future)future);
    }

    @Test
    public void test() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.getClass().getSimpleName());
        UTIL.createTable(tableName, "cf1");
        UTIL.waitTableAvailable(tableName);
        RegionInfo parent = (RegionInfo)UTIL.getAdmin().getRegions(tableName).get(0);
        long rid = 1000L;
        byte[] splitKey = Bytes.toBytes((String)"a");
        RegionInfo splitA = RegionInfoBuilder.newBuilder((TableName)parent.getTable()).setStartKey(parent.getStartKey()).setEndKey(splitKey).setSplit(false).setRegionId(rid).build();
        RegionInfo splitB = RegionInfoBuilder.newBuilder((TableName)parent.getTable()).setStartKey(splitKey).setEndKey(parent.getEndKey()).setSplit(false).setRegionId(rid).build();
        SingleProcessHBaseCluster cluster = UTIL.getMiniHBaseCluster();
        int rsIndex = cluster.getServerWithMeta();
        Assert.assertTrue((rsIndex >= 0 ? 1 : 0) != 0);
        HRegionServer rs = cluster.getRegionServer(rsIndex);
        TestMetaTableAccessor.SpyingRpcScheduler scheduler = (TestMetaTableAccessor.SpyingRpcScheduler)rs.getRpcServer().getScheduler();
        long prevCalls = scheduler.numPriorityCalls;
        long time = EnvironmentEdgeManager.currentTime();
        Put putParent = MetaTableAccessor.makePutFromRegionInfo((RegionInfo)RegionInfoBuilder.newBuilder((RegionInfo)parent).setOffline(true).setSplit(true).build(), (long)time);
        MetaTableAccessor.addDaughtersToPut((Put)putParent, (RegionInfo)splitA, (RegionInfo)splitB);
        Put putA = MetaTableAccessor.makePutFromRegionInfo((RegionInfo)splitA, (long)time);
        Put putB = MetaTableAccessor.makePutFromRegionInfo((RegionInfo)splitB, (long)time);
        this.multiMutate(putParent.getRow(), Arrays.asList(putParent, putA, putB));
        Assert.assertTrue((prevCalls < scheduler.numPriorityCalls ? 1 : 0) != 0);
    }
}

