/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncTableAdminApi2
extends TestAsyncAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableAdminApi2.class);

    @Test
    public void testDisableCatalogTable() throws Exception {
        try {
            this.admin.disableTable(TableName.META_TABLE_NAME).join();
            Assert.fail((String)"Expected to throw ConstraintException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createTableWithDefaultConf(this.tableName);
    }

    @Test
    public void testAddColumnFamily() throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)this.tableName);
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0));
        this.admin.createTable(builder.build()).join();
        this.admin.disableTable(this.tableName).join();
        this.verifyTableDescriptor(this.tableName, new byte[][]{FAMILY_0});
        this.admin.addColumnFamily(this.tableName, ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1)).join();
        this.verifyTableDescriptor(this.tableName, FAMILY_0, FAMILY_1);
    }

    @Test
    public void testAddSameColumnFamilyTwice() throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)this.tableName);
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0));
        this.admin.createTable(builder.build()).join();
        this.admin.disableTable(this.tableName).join();
        this.verifyTableDescriptor(this.tableName, new byte[][]{FAMILY_0});
        this.admin.addColumnFamily(this.tableName, ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1)).join();
        this.verifyTableDescriptor(this.tableName, FAMILY_0, FAMILY_1);
        try {
            this.admin.addColumnFamily(this.tableName, ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1)).join();
            Assert.fail((String)"Delete a non-exist column family should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testModifyColumnFamily() throws Exception {
        TableDescriptorBuilder tdBuilder = TableDescriptorBuilder.newBuilder((TableName)this.tableName);
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0);
        int blockSize = cfd.getBlocksize();
        this.admin.createTable(tdBuilder.setColumnFamily(cfd).build()).join();
        this.admin.disableTable(this.tableName).join();
        this.verifyTableDescriptor(this.tableName, new byte[][]{FAMILY_0});
        int newBlockSize = 2 * blockSize;
        cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY_0).setBlocksize(newBlockSize).build();
        this.admin.modifyColumnFamily(this.tableName, cfd).join();
        TableDescriptor htd = (TableDescriptor)this.admin.getDescriptor(this.tableName).get();
        ColumnFamilyDescriptor hcfd = htd.getColumnFamily(FAMILY_0);
        Assert.assertTrue((hcfd.getBlocksize() == newBlockSize ? 1 : 0) != 0);
    }

    @Test
    public void testModifyNonExistingColumnFamily() throws Exception {
        TableDescriptorBuilder tdBuilder = TableDescriptorBuilder.newBuilder((TableName)this.tableName);
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0);
        int blockSize = cfd.getBlocksize();
        this.admin.createTable(tdBuilder.setColumnFamily(cfd).build()).join();
        this.admin.disableTable(this.tableName).join();
        this.verifyTableDescriptor(this.tableName, new byte[][]{FAMILY_0});
        int newBlockSize = 2 * blockSize;
        cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY_1).setBlocksize(newBlockSize).build();
        try {
            this.admin.modifyColumnFamily(this.tableName, cfd).join();
            Assert.fail((String)"Modify a non-exist column family should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteColumnFamily() throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)this.tableName);
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1));
        this.admin.createTable(builder.build()).join();
        this.admin.disableTable(this.tableName).join();
        this.verifyTableDescriptor(this.tableName, FAMILY_0, FAMILY_1);
        this.admin.deleteColumnFamily(this.tableName, FAMILY_1).join();
        this.verifyTableDescriptor(this.tableName, new byte[][]{FAMILY_0});
    }

    @Test
    public void testDeleteSameColumnFamilyTwice() throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)this.tableName);
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1));
        this.admin.createTable(builder.build()).join();
        this.admin.disableTable(this.tableName).join();
        this.verifyTableDescriptor(this.tableName, FAMILY_0, FAMILY_1);
        this.admin.deleteColumnFamily(this.tableName, FAMILY_1).join();
        this.verifyTableDescriptor(this.tableName, new byte[][]{FAMILY_0});
        try {
            this.admin.deleteColumnFamily(this.tableName, FAMILY_1).join();
            Assert.fail((String)"Delete a non-exist column family should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void verifyTableDescriptor(TableName tableName, byte[] ... families) throws Exception {
        TableDescriptor htd = (TableDescriptor)this.admin.getDescriptor(tableName).get();
        this.verifyTableDescriptor(htd, tableName, families);
        MasterFileSystem mfs = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        Path tableDir = CommonFSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)tableName);
        TableDescriptor td = FSTableDescriptors.getTableDescriptorFromFs((FileSystem)mfs.getFileSystem(), (Path)tableDir);
        this.verifyTableDescriptor(td, tableName, families);
    }

    private void verifyTableDescriptor(TableDescriptor htd, TableName tableName, byte[] ... families) {
        Set htdFamilies = htd.getColumnFamilyNames();
        Assert.assertEquals((Object)tableName, (Object)htd.getTableName());
        Assert.assertEquals((long)families.length, (long)htdFamilies.size());
        for (byte[] familyName : families) {
            Assert.assertTrue((String)("Expected family " + Bytes.toString((byte[])familyName)), (boolean)htdFamilies.contains(familyName));
        }
    }

    @Test
    public void testCompactionTimestamps() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        AsyncTable table = ASYNC_CONN.getTable(this.tableName);
        Optional ts = (Optional)this.admin.getLastMajorCompactionTimestamp(this.tableName).get();
        Assert.assertFalse((boolean)ts.isPresent());
        Put p = new Put(Bytes.toBytes((String)"row1"));
        p.addColumn(FAMILY, Bytes.toBytes((String)"q"), Bytes.toBytes((String)"v"));
        table.put(p).join();
        ts = (Optional)this.admin.getLastMajorCompactionTimestamp(this.tableName).get();
        Assert.assertFalse((boolean)ts.isPresent());
        this.admin.flush(this.tableName).join();
        ts = (Optional)this.admin.getLastMajorCompactionTimestamp(this.tableName).get();
        Assert.assertFalse((boolean)ts.isPresent());
        byte[] regionName = ((HRegionLocation)ASYNC_CONN.getRegionLocator(this.tableName).getRegionLocation(Bytes.toBytes((String)"row1")).get()).getRegion().getRegionName();
        Optional ts1 = (Optional)this.admin.getLastMajorCompactionTimestampForRegion(regionName).get();
        Assert.assertFalse((boolean)ts1.isPresent());
        p = new Put(Bytes.toBytes((String)"row2"));
        p.addColumn(FAMILY, Bytes.toBytes((String)"q"), Bytes.toBytes((String)"v"));
        table.put(p).join();
        this.admin.flush(this.tableName).join();
        ts1 = (Optional)this.admin.getLastMajorCompactionTimestamp(this.tableName).get();
        Assert.assertFalse((boolean)ts1.isPresent());
        for (int i = 0; i < 3; ++i) {
            table.put(p).join();
            this.admin.flush(this.tableName).join();
        }
        this.admin.majorCompact(this.tableName).join();
        long curt = EnvironmentEdgeManager.currentTime();
        long waitTime = 10000L;
        long endt = curt + waitTime;
        CompactionState state = (CompactionState)this.admin.getCompactionState(this.tableName).get();
        LOG.info("Current compaction state 1 is " + state);
        while (state == CompactionState.NONE && curt < endt) {
            Thread.sleep(100L);
            state = (CompactionState)this.admin.getCompactionState(this.tableName).get();
            curt = EnvironmentEdgeManager.currentTime();
            LOG.info("Current compaction state 2 is " + state);
        }
        if (state == CompactionState.MAJOR) {
            state = (CompactionState)this.admin.getCompactionState(this.tableName).get();
            LOG.info("Current compaction state 3 is " + state);
            while (state != CompactionState.NONE && curt < endt) {
                Thread.sleep(10L);
                state = (CompactionState)this.admin.getCompactionState(this.tableName).get();
                LOG.info("Current compaction state 4 is " + state);
            }
        }
        Thread.sleep(TEST_UTIL.getConfiguration().getInt("hbase.regionserver.msginterval", 3000) * 2);
        ts = (Optional)this.admin.getLastMajorCompactionTimestamp(this.tableName).get();
        Assert.assertTrue((boolean)ts.isPresent());
        Assert.assertTrue(((Long)ts.get() > 0L ? 1 : 0) != 0);
        ts1 = (Optional)this.admin.getLastMajorCompactionTimestampForRegion(regionName).get();
        Assert.assertTrue((boolean)ts1.isPresent());
        Assert.assertEquals(ts.get(), ts1.get());
        table.put(p).join();
        this.admin.flush(this.tableName).join();
        ts = (Optional)this.admin.getLastMajorCompactionTimestamp(this.tableName).join();
        Assert.assertTrue((boolean)ts.isPresent());
        Assert.assertEquals(ts.get(), ts1.get());
        ts1 = (Optional)this.admin.getLastMajorCompactionTimestampForRegion(regionName).get();
        Assert.assertTrue((boolean)ts1.isPresent());
        Assert.assertEquals(ts.get(), ts1.get());
    }
}

