/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncClusterConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRegionLocator;
import org.apache.hadoop.hbase.client.AsyncRegionReplicationRetryingCaller;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestFallbackToUseReplay {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFallbackToUseReplay.class);
    private static Configuration CONF = HBaseConfiguration.create();
    private static AsyncClusterConnectionImpl CONN;
    private static AsyncRegionReplicationRetryingCaller CALLER;
    private static RegionInfo REPLICA;
    private static AtomicBoolean REPLAY_CALLED;

    @BeforeClass
    public static void setUpBeforeClass() throws IOException {
        CONF.setInt("hbase.client.start.log.errors.counter", 0);
        final AsyncRegionLocator locator = (AsyncRegionLocator)Mockito.mock(AsyncRegionLocator.class);
        Mockito.when((Object)locator.getRegionLocation((TableName)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (RegionLocateType)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenReturn(CompletableFuture.completedFuture(new HRegionLocation(REPLICA, ServerName.valueOf((String)"localhost", (int)12345, (long)EnvironmentEdgeManager.currentTime()))));
        final AdminProtos.AdminService.Interface stub = (AdminProtos.AdminService.Interface)Mockito.mock(AdminProtos.AdminService.Interface.class);
        ((AdminProtos.AdminService.Interface)Mockito.doAnswer(i -> {
            HBaseRpcController controller = (HBaseRpcController)i.getArgument(0, HBaseRpcController.class);
            controller.setFailed((IOException)((Object)new DoNotRetryIOException((Throwable)new UnsupportedOperationException())));
            RpcCallback done = (RpcCallback)i.getArgument(2, RpcCallback.class);
            done.run(null);
            return null;
        }).when((Object)stub)).replicateToReplica((RpcController)ArgumentMatchers.any(), (AdminProtos.ReplicateWALEntryRequest)ArgumentMatchers.any(), (RpcCallback)ArgumentMatchers.any());
        ((AdminProtos.AdminService.Interface)Mockito.doAnswer(i -> {
            REPLAY_CALLED.set(true);
            RpcCallback done = (RpcCallback)i.getArgument(2, RpcCallback.class);
            done.run(null);
            return null;
        }).when((Object)stub)).replay((RpcController)ArgumentMatchers.any(), (AdminProtos.ReplicateWALEntryRequest)ArgumentMatchers.any(), (RpcCallback)ArgumentMatchers.any());
        CONN = new AsyncClusterConnectionImpl(CONF, (ConnectionRegistry)Mockito.mock(ConnectionRegistry.class), "test", null, User.getCurrent()){

            AsyncRegionLocator getLocator() {
                return locator;
            }

            AdminProtos.AdminService.Interface getAdminStub(ServerName serverName) throws IOException {
                return stub;
            }
        };
        CALLER = new AsyncRegionReplicationRetryingCaller(AsyncClusterConnectionImpl.RETRY_TIMER, CONN, 10, TimeUnit.SECONDS.toNanos(1L), TimeUnit.SECONDS.toNanos(10L), REPLICA, Collections.emptyList());
    }

    @AfterClass
    public static void tearDownAfterClass() throws IOException {
        Closeables.close((Closeable)CONN, (boolean)true);
    }

    @Test
    public void testFallback() {
        CALLER.call().join();
        Assert.assertTrue((boolean)REPLAY_CALLED.get());
    }

    static {
        REPLICA = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"test")).setReplicaId(1).build();
        REPLAY_CALLED = new AtomicBoolean(false);
    }
}

