/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.codahale.metrics.Counter;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.TestRegionServerNoMaster;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestReplicasClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicasClient.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicasClient.class);
    private static TableName TABLE_NAME;
    private Table table = null;
    private static final byte[] row;
    private static RegionInfo hriPrimary;
    private static RegionInfo hriSecondary;
    private static final HBaseTestingUtil HTU;
    private static final byte[] f;
    private static final int REFRESH_PERIOD = 1000;

    @BeforeClass
    public static void beforeClass() throws Exception {
        HTU.getConfiguration().setInt("hbase.regionserver.storefile.refresh.period", 1000);
        HTU.getConfiguration().setBoolean("hbase.client.log.scanner.activity", true);
        HTU.getConfiguration().setBoolean("hbase.client.metrics.enable", true);
        StartTestingClusterOption option = StartTestingClusterOption.builder().numRegionServers(1).numAlwaysStandByMasters(1).numMasters(1).build();
        HTU.startMiniCluster(option);
        TableDescriptorBuilder builder = HTU.createModifyableTableDescriptor(TableName.valueOf((String)TestReplicasClient.class.getSimpleName()), 0, 3, Integer.MAX_VALUE, ColumnFamilyDescriptorBuilder.DEFAULT_KEEP_DELETED);
        builder.setCoprocessor(SlowMeCopro.class.getName());
        TableDescriptor hdt = builder.build();
        HTU.createTable(hdt, (byte[][])new byte[][]{f}, null);
        TABLE_NAME = hdt.getTableName();
        try (RegionLocator locator = HTU.getConnection().getRegionLocator(hdt.getTableName());){
            hriPrimary = locator.getRegionLocation(row, false).getRegion();
        }
        hriSecondary = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hriPrimary, (int)1);
        LOG.info("Master is going to be stopped");
        TestRegionServerNoMaster.stopMasterAndCacheMetaLocation(HTU);
        Configuration c = new Configuration(HTU.getConfiguration());
        c.setInt("hbase.client.retries.number", 1);
        LOG.info("Master has stopped");
    }

    @AfterClass
    public static void afterClass() throws Exception {
        HRegionServer.TEST_SKIP_REPORTING_TRANSITION = false;
        HTU.shutdownMiniCluster();
    }

    @Before
    public void before() throws IOException {
        HTU.getConnection().clearRegionLocationCache();
        try {
            this.openRegion(hriPrimary);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.openRegion(hriSecondary);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.table = HTU.getConnection().getTable(TABLE_NAME);
    }

    @After
    public void after() throws IOException, KeeperException {
        try {
            this.closeRegion(hriSecondary);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.closeRegion(hriPrimary);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HTU.getConnection().clearRegionLocationCache();
    }

    private HRegionServer getRS() {
        return HTU.getMiniHBaseCluster().getRegionServer(0);
    }

    private void openRegion(RegionInfo hri) throws Exception {
        try {
            if (this.isRegionOpened(hri)) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest((ServerName)this.getRS().getServerName(), (RegionInfo)hri, null);
        AdminProtos.OpenRegionResponse responseOpen = this.getRS().getRSRpcServices().openRegion(null, orr);
        Assert.assertEquals((long)1L, (long)responseOpen.getOpeningStateCount());
        Assert.assertEquals((Object)AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED, (Object)responseOpen.getOpeningState(0));
        this.checkRegionIsOpened(hri);
    }

    private void closeRegion(RegionInfo hri) throws Exception {
        AdminProtos.CloseRegionRequest crr = ProtobufUtil.buildCloseRegionRequest((ServerName)this.getRS().getServerName(), (byte[])hri.getRegionName());
        AdminProtos.CloseRegionResponse responseClose = this.getRS().getRSRpcServices().closeRegion(null, crr);
        Assert.assertTrue((boolean)responseClose.getClosed());
        this.checkRegionIsClosed(hri.getEncodedName());
    }

    private void checkRegionIsOpened(RegionInfo hri) throws Exception {
        while (!this.getRS().getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
    }

    private boolean isRegionOpened(RegionInfo hri) throws Exception {
        return this.getRS().getRegionByEncodedName(hri.getEncodedName()).isAvailable();
    }

    private void checkRegionIsClosed(String encodedRegionName) throws Exception {
        while (!this.getRS().getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
        try {
            Assert.assertFalse((boolean)this.getRS().getRegionByEncodedName(encodedRegionName).isAvailable());
        }
        catch (NotServingRegionException notServingRegionException) {
            // empty catch block
        }
    }

    private void flushRegion(RegionInfo regionInfo) throws IOException {
        TestRegionServerNoMaster.flushRegion(HTU, regionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUseRegionWithoutReplica() throws Exception {
        byte[] b1 = Bytes.toBytes((String)"testUseRegionWithoutReplica");
        this.openRegion(hriSecondary);
        SlowMeCopro.getPrimaryCdl().set(new CountDownLatch(0));
        try {
            Get g = new Get(b1);
            Result r = this.table.get(g);
            Assert.assertFalse((boolean)r.isStale());
        }
        finally {
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocations() throws Exception {
        byte[] b1 = Bytes.toBytes((String)"testLocations");
        this.openRegion(hriSecondary);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
             RegionLocator locator = conn.getRegionLocator(TABLE_NAME);){
            conn.clearRegionLocationCache();
            List rl = locator.getRegionLocations(b1, true);
            Assert.assertEquals((long)2L, (long)rl.size());
            rl = locator.getRegionLocations(b1, false);
            Assert.assertEquals((long)2L, (long)rl.size());
            conn.clearRegionLocationCache();
            rl = locator.getRegionLocations(b1, false);
            Assert.assertEquals((long)2L, (long)rl.size());
            rl = locator.getRegionLocations(b1, true);
            Assert.assertEquals((long)2L, (long)rl.size());
        }
        finally {
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetNoResultNoStaleRegionWithReplica() throws Exception {
        byte[] b1 = Bytes.toBytes((String)"testGetNoResultNoStaleRegionWithReplica");
        this.openRegion(hriSecondary);
        try {
            Get g = new Get(b1);
            Result r = this.table.get(g);
            Assert.assertFalse((boolean)r.isStale());
        }
        finally {
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetNoResultStaleRegionWithReplica() throws Exception {
        byte[] b1 = Bytes.toBytes((String)"testGetNoResultStaleRegionWithReplica");
        this.openRegion(hriSecondary);
        SlowMeCopro.getPrimaryCdl().set(new CountDownLatch(1));
        try {
            Get g = new Get(b1);
            g.setConsistency(Consistency.TIMELINE);
            Result r = this.table.get(g);
            Assert.assertTrue((boolean)r.isStale());
        }
        finally {
            SlowMeCopro.getPrimaryCdl().get().countDown();
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetNoResultNotStaleSleepRegionWithReplica() throws Exception {
        byte[] b1 = Bytes.toBytes((String)"testGetNoResultNotStaleSleepRegionWithReplica");
        this.openRegion(hriSecondary);
        try {
            SlowMeCopro.sleepTime.set(2000L);
            Get g = new Get(b1);
            Result r = this.table.get(g);
            Assert.assertFalse((boolean)r.isStale());
        }
        finally {
            SlowMeCopro.sleepTime.set(0L);
            this.closeRegion(hriSecondary);
        }
    }

    @Test
    public void testFlushTable() throws Exception {
        this.openRegion(hriSecondary);
        try {
            this.flushRegion(hriPrimary);
            this.flushRegion(hriSecondary);
            Put p = new Put(row);
            p.addColumn(f, row, row);
            this.table.put(p);
            this.flushRegion(hriPrimary);
            this.flushRegion(hriSecondary);
        }
        finally {
            Delete d = new Delete(row);
            this.table.delete(d);
            this.closeRegion(hriSecondary);
        }
    }

    @Test
    public void testFlushPrimary() throws Exception {
        this.openRegion(hriSecondary);
        try {
            this.flushRegion(hriPrimary);
            Put p = new Put(row);
            p.addColumn(f, row, row);
            this.table.put(p);
            this.flushRegion(hriPrimary);
        }
        finally {
            Delete d = new Delete(row);
            this.table.delete(d);
            this.closeRegion(hriSecondary);
        }
    }

    @Test
    public void testFlushSecondary() throws Exception {
        this.openRegion(hriSecondary);
        try {
            this.flushRegion(hriSecondary);
            Put p = new Put(row);
            p.addColumn(f, row, row);
            this.table.put(p);
            this.flushRegion(hriSecondary);
        }
        catch (TableNotFoundException d) {
        }
        finally {
            Delete d = new Delete(row);
            this.table.delete(d);
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUseRegionWithReplica() throws Exception {
        byte[] b1 = Bytes.toBytes((String)"testUseRegionWithReplica");
        this.openRegion(hriSecondary);
        try {
            Put p = new Put(b1);
            p.addColumn(f, b1, b1);
            this.table.put(p);
            LOG.info("Put done");
            Get g = new Get(b1);
            Result r = this.table.get(g);
            Assert.assertFalse((boolean)r.isStale());
            Assert.assertFalse((boolean)r.getColumnCells(f, b1).isEmpty());
            LOG.info("get works and is not stale done");
            SlowMeCopro.sleepTime.set(2000L);
            g = new Get(b1);
            r = this.table.get(g);
            Assert.assertFalse((boolean)r.isStale());
            Assert.assertFalse((boolean)r.getColumnCells(f, b1).isEmpty());
            SlowMeCopro.sleepTime.set(0L);
            LOG.info("sleep and is not stale done");
            SlowMeCopro.getPrimaryCdl().set(new CountDownLatch(1));
            g = new Get(b1);
            g.setConsistency(Consistency.TIMELINE);
            r = this.table.get(g);
            Assert.assertTrue((boolean)r.isStale());
            Assert.assertTrue((boolean)r.getColumnCells(f, b1).isEmpty());
            SlowMeCopro.getPrimaryCdl().get().countDown();
            LOG.info("stale done");
            g = new Get(b1);
            g.setCheckExistenceOnly(true);
            r = this.table.get(g);
            Assert.assertFalse((boolean)r.isStale());
            Assert.assertTrue((boolean)r.getExists());
            LOG.info("exists not stale done");
            SlowMeCopro.getPrimaryCdl().set(new CountDownLatch(1));
            g = new Get(b1);
            g.setCheckExistenceOnly(true);
            g.setConsistency(Consistency.TIMELINE);
            r = this.table.get(g);
            Assert.assertTrue((boolean)r.isStale());
            Assert.assertFalse((String)"The secondary has stale data", (boolean)r.getExists());
            SlowMeCopro.getPrimaryCdl().get().countDown();
            LOG.info("exists stale before flush done");
            this.flushRegion(hriPrimary);
            this.flushRegion(hriSecondary);
            LOG.info("flush done");
            Thread.sleep(3000L);
            SlowMeCopro.getPrimaryCdl().set(new CountDownLatch(1));
            g = new Get(b1);
            g.setConsistency(Consistency.TIMELINE);
            r = this.table.get(g);
            Assert.assertTrue((boolean)r.isStale());
            Assert.assertFalse((boolean)r.isEmpty());
            SlowMeCopro.getPrimaryCdl().get().countDown();
            LOG.info("stale done");
            SlowMeCopro.getPrimaryCdl().set(new CountDownLatch(1));
            g = new Get(b1);
            g.setCheckExistenceOnly(true);
            g.setConsistency(Consistency.TIMELINE);
            r = this.table.get(g);
            Assert.assertTrue((boolean)r.isStale());
            Assert.assertTrue((boolean)r.getExists());
            SlowMeCopro.getPrimaryCdl().get().countDown();
            LOG.info("exists stale after flush done");
        }
        finally {
            SlowMeCopro.getPrimaryCdl().get().countDown();
            SlowMeCopro.sleepTime.set(0L);
            Delete d = new Delete(b1);
            this.table.delete(d);
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHedgedRead() throws Exception {
        byte[] b1 = Bytes.toBytes((String)"testHedgedRead");
        this.openRegion(hriSecondary);
        try {
            Put p = new Put(b1);
            p.addColumn(f, b1, b1);
            this.table.put(p);
            LOG.info("Put done");
            Get g = new Get(b1);
            Result r = this.table.get(g);
            Assert.assertFalse((boolean)r.isStale());
            Assert.assertFalse((boolean)r.getColumnCells(f, b1).isEmpty());
            LOG.info("get works and is not stale done");
            AsyncConnectionImpl conn = (AsyncConnectionImpl)HTU.getConnection().toAsyncConnection();
            Counter hedgedReadOps = ((MetricsConnection)conn.getConnectionMetrics().get()).getHedgedReadOps();
            Counter hedgedReadWin = ((MetricsConnection)conn.getConnectionMetrics().get()).getHedgedReadWin();
            hedgedReadOps.dec(hedgedReadOps.getCount());
            hedgedReadWin.dec(hedgedReadWin.getCount());
            long primaryCallTimeoutNs = conn.connConf.getPrimaryCallTimeoutNs();
            SlowMeCopro.sleepTime.set(TimeUnit.NANOSECONDS.toMillis(primaryCallTimeoutNs) + 100L);
            SlowMeCopro.getSecondaryCdl().set(new CountDownLatch(1));
            g = new Get(b1);
            g.setConsistency(Consistency.TIMELINE);
            r = this.table.get(g);
            Assert.assertFalse((boolean)r.isStale());
            Assert.assertFalse((boolean)r.getColumnCells(f, b1).isEmpty());
            Assert.assertEquals((long)1L, (long)hedgedReadOps.getCount());
            Assert.assertEquals((long)0L, (long)hedgedReadWin.getCount());
            SlowMeCopro.sleepTime.set(0L);
            SlowMeCopro.getSecondaryCdl().get().countDown();
            LOG.info("hedged read occurred but not faster");
            SlowMeCopro.getPrimaryCdl().set(new CountDownLatch(1));
            g = new Get(b1);
            g.setConsistency(Consistency.TIMELINE);
            r = this.table.get(g);
            Assert.assertTrue((boolean)r.isStale());
            Assert.assertTrue((boolean)r.getColumnCells(f, b1).isEmpty());
            Assert.assertEquals((long)2L, (long)hedgedReadOps.getCount());
            HTU.waitFor(10000L, () -> hedgedReadWin.getCount() == 1L);
            SlowMeCopro.getPrimaryCdl().get().countDown();
            LOG.info("hedged read occurred and faster");
        }
        finally {
            SlowMeCopro.getPrimaryCdl().get().countDown();
            SlowMeCopro.getSecondaryCdl().get().countDown();
            SlowMeCopro.sleepTime.set(0L);
            Delete d = new Delete(b1);
            this.table.delete(d);
            this.closeRegion(hriSecondary);
        }
    }

    static {
        row = Bytes.toBytes((String)TestReplicasClient.class.getName());
        HTU = new HBaseTestingUtil();
        f = HConstants.CATALOG_FAMILY;
    }

    public static class SlowMeCopro
    implements RegionCoprocessor,
    RegionObserver {
        static final AtomicLong sleepTime = new AtomicLong(0L);
        static final AtomicBoolean slowDownNext = new AtomicBoolean(false);
        static final AtomicInteger countOfNext = new AtomicInteger(0);
        private static final AtomicReference<CountDownLatch> primaryCdl = new AtomicReference<CountDownLatch>(new CountDownLatch(0));
        private static final AtomicReference<CountDownLatch> secondaryCdl = new AtomicReference<CountDownLatch>(new CountDownLatch(0));

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            this.slowdownCode(e);
        }

        public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan) throws IOException {
            this.slowdownCode(e);
        }

        public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> e, InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
            if (slowDownNext.get() && countOfNext.incrementAndGet() == 2) {
                sleepTime.set(2000L);
                this.slowdownCode(e);
            }
            return true;
        }

        private void slowdownCode(ObserverContext<RegionCoprocessorEnvironment> e) {
            if (((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().getReplicaId() == 0) {
                LOG.info("We're the primary replicas.");
                CountDownLatch latch = SlowMeCopro.getPrimaryCdl().get();
                try {
                    if (sleepTime.get() > 0L) {
                        LOG.info("Sleeping for " + sleepTime.get() + " ms");
                        Thread.sleep(sleepTime.get());
                    } else if (latch.getCount() > 0L) {
                        LOG.info("Waiting for the counterCountDownLatch");
                        latch.await(2L, TimeUnit.MINUTES);
                        if (latch.getCount() > 0L) {
                            throw new RuntimeException("Can't wait more");
                        }
                    }
                }
                catch (InterruptedException e1) {
                    LOG.error(e1.toString(), (Throwable)e1);
                }
            } else {
                LOG.info("We're not the primary replicas.");
                CountDownLatch latch = SlowMeCopro.getSecondaryCdl().get();
                try {
                    if (latch.getCount() > 0L) {
                        LOG.info("Waiting for the secondary counterCountDownLatch");
                        latch.await(2L, TimeUnit.MINUTES);
                        if (latch.getCount() > 0L) {
                            throw new RuntimeException("Can't wait more");
                        }
                    }
                }
                catch (InterruptedException e1) {
                    LOG.error(e1.toString(), (Throwable)e1);
                }
            }
        }

        public static AtomicReference<CountDownLatch> getPrimaryCdl() {
            return primaryCdl;
        }

        public static AtomicReference<CountDownLatch> getSecondaryCdl() {
            return secondaryCdl;
        }
    }
}

