/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.SharedConnection;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestCoprocessorSharedConnection {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCoprocessorSharedConnection.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtil HTU = new HBaseTestingUtil();

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = HTU.getConfiguration();
        conf.setStrings("hbase.coprocessor.master.classes", new String[]{TestMasterCoprocessor.class.getName()});
        conf.setStrings("hbase.coprocessor.regionserver.classes", new String[]{TestRegionServerCoprocessor.class.getName()});
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{TestRegionCoprocessor.class.getName()});
        HTU.startMiniCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        HTU.shutdownMiniCluster();
    }

    private static void checkShared(Connection connection) {
        Assert.assertTrue((boolean)(connection instanceof SharedConnection));
    }

    @Test
    public void test() throws IOException {
    }

    public static class TestRegionCoprocessor
    implements RegionCoprocessor {
        public void start(CoprocessorEnvironment env) throws IOException {
            TestCoprocessorSharedConnection.checkShared(((RegionCoprocessorEnvironment)env).getConnection());
        }
    }

    public static class TestRegionServerCoprocessor
    implements RegionServerCoprocessor {
        public void start(CoprocessorEnvironment env) throws IOException {
            TestCoprocessorSharedConnection.checkShared(((RegionServerCoprocessorEnvironment)env).getConnection());
        }
    }

    public static class TestMasterCoprocessor
    implements MasterCoprocessor {
        public void start(CoprocessorEnvironment env) throws IOException {
            TestCoprocessorSharedConnection.checkShared(((MasterCoprocessorEnvironment)env).getConnection());
        }
    }
}

