/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestIncrementAndAppendWithNullResult {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestIncrementAndAppendWithNullResult.class);
    private static final HBaseTestingUtil util = new HBaseTestingUtil();
    private static final TableName TEST_TABLE = TableName.valueOf((String)"test");
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"f1");
    private static final byte[] ROW_A = Bytes.toBytes((String)"aaa");
    private static final byte[] qualifierCol1 = Bytes.toBytes((String)"col1");
    private static Table table;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        util.getConfiguration().set("hbase.coprocessor.region.classes", MyObserver.class.getName());
        util.getConfiguration().setInt("hbase.client.retries.number", 2);
        util.startMiniCluster();
        table = util.createTable(TEST_TABLE, TEST_FAMILY);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Test
    public void testIncrement() throws Exception {
        this.testAppend(new Increment(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, 10L));
        this.testAppend(new Increment(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, 10L).setReturnResults(false));
    }

    private void testAppend(Increment inc) throws Exception {
        TestIncrementAndAppendWithNullResult.checkResult(table.increment(inc));
        List<Row> actions = Arrays.asList(inc, inc);
        Object[] results = new Object[actions.size()];
        table.batch(actions, results);
        TestIncrementAndAppendWithNullResult.checkResult(results);
    }

    @Test
    public void testAppend() throws Exception {
        this.testAppend(new Append(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, Bytes.toBytes((String)"value")));
        this.testAppend(new Append(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, Bytes.toBytes((String)"value")).setReturnResults(false));
    }

    private void testAppend(Append append) throws Exception {
        TestIncrementAndAppendWithNullResult.checkResult(table.append(append));
        List<Row> actions = Arrays.asList(append, append);
        Object[] results = new Object[actions.size()];
        table.batch(actions, results);
        TestIncrementAndAppendWithNullResult.checkResult(results);
    }

    private static void checkResult(Result r) {
        TestIncrementAndAppendWithNullResult.checkResult(new Object[]{r});
    }

    private static void checkResult(Object[] results) {
        for (int i = 0; i != results.length; ++i) {
            Assert.assertNotNull((String)("The result[" + i + "] should not be null"), (Object)results[i]);
            Assert.assertTrue((String)("The result[" + i + "] should be Result type"), (boolean)(results[i] instanceof Result));
            Assert.assertTrue((String)("The result[" + i + "] shuold be empty"), (boolean)((Result)results[i]).isEmpty());
        }
    }

    public static class MyObserver
    implements RegionCoprocessor,
    RegionObserver {
        private static final Result TMP_RESULT = Result.create(Arrays.asList(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(Bytes.toBytes((String)"row")).setFamily(Bytes.toBytes((String)"family")).setQualifier(Bytes.toBytes((String)"qualifier")).setType(Cell.Type.Put).setValue(Bytes.toBytes((String)"value")).build()));

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public Result preIncrementAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
            return TMP_RESULT;
        }

        public Result postIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment, Result result) throws IOException {
            return null;
        }

        public Result postAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append, Result result) {
            return null;
        }

        public Result preAppendAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, Append append) {
            return TMP_RESULT;
        }
    }
}

