/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={FilterTests.class, MediumTests.class})
public class TestFilterWrapper {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFilterWrapper.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFilterWrapper.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static Configuration conf = null;
    private static Admin admin = null;
    private static TableName name = TableName.valueOf((String)"test");
    private static Connection connection;

    @Test
    public void testFilterWrapper() {
        int kv_number = 0;
        int row_number = 0;
        try {
            Scan scan = new Scan();
            ArrayList<Object> fs = new ArrayList<Object>();
            DependentColumnFilter f1 = new DependentColumnFilter(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"c5"), true, CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("c5"));
            PageFilter f2 = new PageFilter(2L);
            fs.add(f1);
            fs.add(f2);
            FilterList filter = new FilterList(fs);
            scan.setFilter((Filter)filter);
            Table table = connection.getTable(name);
            ResultScanner scanner = table.getScanner(scan);
            for (Result result : scanner) {
                ++row_number;
                for (Cell kv : result.listCells()) {
                    LOG.debug(kv_number + ". kv: " + kv);
                    ++kv_number;
                    Assert.assertEquals((String)"Returned row is not correct", (Object)Bytes.toString((byte[])CellUtil.cloneRow((Cell)kv)), (Object)("row" + (row_number + 1)));
                }
            }
            scanner.close();
            table.close();
        }
        catch (Exception e) {
            Assert.assertNull((String)"Exception happens in scan", (Object)e);
        }
        LOG.debug("check the fetched kv number");
        Assert.assertEquals((String)"We should get 8 results returned.", (long)8L, (long)kv_number);
        Assert.assertEquals((String)"We should get 2 rows returned", (long)2L, (long)row_number);
    }

    private static void prepareData() {
        try {
            Table table = connection.getTable(name);
            Assert.assertTrue((String)"Fail to create the table", (boolean)admin.tableExists(name));
            ArrayList<Put> puts = new ArrayList<Put>();
            for (int i = 1; i < 4; ++i) {
                Put put = new Put(Bytes.toBytes((String)("row" + i)));
                for (int j = 1; j < 6; ++j) {
                    long timestamp = j;
                    if (i != 1) {
                        timestamp = i;
                    }
                    put.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)("c" + j)), timestamp, Bytes.toBytes((String)(i + "_c" + j)));
                }
                puts.add(put);
            }
            table.put(puts);
            table.close();
        }
        catch (IOException e) {
            Assert.assertNull((String)"Exception found while putting data into table", (Object)e);
        }
    }

    private static void createTable() {
        Assert.assertNotNull((String)"HBaseAdmin is not initialized successfully.", (Object)admin);
        if (admin != null) {
            TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)name).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])Bytes.toBytes((String)"f1"))).build();
            try {
                admin.createTable(tableDescriptor);
                Assert.assertTrue((String)"Fail to create the table", (boolean)admin.tableExists(name));
            }
            catch (IOException e) {
                Assert.assertNull((String)"Exception found while creating table", (Object)e);
            }
        }
    }

    private static void deleteTable() {
        if (admin != null) {
            try {
                admin.disableTable(name);
                admin.deleteTable(name);
            }
            catch (IOException e) {
                Assert.assertNull((String)"Exception found deleting the table", (Object)e);
            }
        }
    }

    private static void initialize(Configuration conf) {
        TestFilterWrapper.conf = HBaseConfiguration.create((Configuration)conf);
        TestFilterWrapper.conf.setInt("hbase.client.retries.number", 1);
        try {
            connection = ConnectionFactory.createConnection((Configuration)TestFilterWrapper.conf);
            admin = TEST_UTIL.getAdmin();
        }
        catch (MasterNotRunningException e) {
            Assert.assertNull((String)"Master is not running", (Object)((Object)e));
        }
        catch (ZooKeeperConnectionException e) {
            Assert.assertNull((String)"Cannot connect to ZooKeeper", (Object)((Object)e));
        }
        catch (IOException e) {
            Assert.assertNull((String)"Caught IOException", (Object)e);
        }
        TestFilterWrapper.createTable();
        TestFilterWrapper.prepareData();
    }

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        TestFilterWrapper.initialize(TEST_UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestFilterWrapper.deleteTable();
        connection.close();
        TEST_UTIL.shutdownMiniCluster();
    }
}

